/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.positionpanel;

import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.gui.NoEditableNumberSpinner;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.general.ChangePositionTool;
import es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels.PositionImagePanel;
import es.eucm.eadventure.editor.gui.otherpanels.positionpanel.PositionPanelListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PositionPanel
extends JPanel
implements Positioned {
    private static final long serialVersionUID = 1L;
    private PositionPanelListener positionPanelListener;
    private NoEditableNumberSpinner positionXTextField;
    private NoEditableNumberSpinner positionYTextField;
    private NoEditableNumberSpinner scaleTextField;
    private PositionImagePanel positionImagePanel;
    private int positionX;
    private int positionY;
    private boolean withScale = false;
    private float scale;

    public PositionPanel(PositionImagePanel positionImagePanel, int n, int n2) {
        this(null, positionImagePanel, n, n2);
    }

    public PositionPanel(PositionImagePanel positionImagePanel, int n, int n2, float f) {
        this(null, positionImagePanel, n, n2, f);
    }

    public PositionPanel(PositionPanelListener positionPanelListener, PositionImagePanel positionImagePanel, int n, int n2) {
        this.positionPanelListener = positionPanelListener;
        this.positionImagePanel = positionImagePanel;
        this.positionX = n;
        this.positionY = n2;
        this.createPanel();
    }

    public PositionPanel(PositionPanelListener positionPanelListener, PositionImagePanel positionImagePanel, int n, int n2, float f) {
        this.positionPanelListener = positionPanelListener;
        this.positionImagePanel = positionImagePanel;
        this.positionX = n;
        this.positionY = n2;
        this.scale = f;
        this.withScale = true;
        this.createPanel();
    }

    private void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel(TC.get((String)"SceneLocation.XCoordinate")));
        this.positionXTextField = new NoEditableNumberSpinner((Number)this.positionX, -2000, 5000, (Number)1);
        this.positionXTextField.addChangeListener((ChangeListener)new ChangeValueListener());
        jPanel.add((Component)this.positionXTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new JLabel(TC.get((String)"SceneLocation.YCoordinate")));
        this.positionYTextField = new NoEditableNumberSpinner((Number)this.positionY, -2000, 5000, (Number)1);
        this.positionYTextField.addChangeListener((ChangeListener)new ChangeValueListener());
        jPanel2.add((Component)this.positionYTextField);
        gridBagConstraints.gridx = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        if (this.withScale) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            jPanel3.add((Component)new JLabel(TC.get((String)"SceneLocation.Scale")), gridBagConstraints);
            this.scaleTextField = new NoEditableNumberSpinner((Number)Float.valueOf(this.scale), 0.1f, 5.0f, (Number)Float.valueOf(0.1f));
            this.scaleTextField.addChangeListener((ChangeListener)new ChangeValueListener());
            jPanel3.add((Component)this.scaleTextField);
            gridBagConstraints.gridx = 2;
            this.add((Component)jPanel3, gridBagConstraints);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.positionImagePanel.addMouseListener(new ImagePanelMouseListener());
        this.add((Component)this.positionImagePanel, gridBagConstraints);
        this.positionImagePanel.setSelectedPoint(this.positionX, this.positionY);
        this.positionImagePanel.setScale(this.scale);
        this.positionImagePanel.repaint();
    }

    public void loadImage(String string) {
        this.positionImagePanel.loadImage(string);
    }

    public void removeImage() {
        this.positionImagePanel.removeImage();
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public void setPosition(int n, int n2) {
        Controller.getInstance().addTool(new ChangePositionTool(this, n, n2));
    }

    public void setPositionX(int n) {
        this.positionX = n;
        this.positionXTextField.setValue((Object)this.positionX);
    }

    public void setPositionY(int n) {
        this.positionY = n;
        this.positionYTextField.setValue((Object)this.positionY);
    }

    public float getScale() {
        return this.scale;
    }

    public void setPositionImage(PositionImagePanel positionImagePanel) {
        this.positionImagePanel = positionImagePanel;
    }

    public class ChangeValueListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == PositionPanel.this.positionXTextField) {
                PositionPanel.this.positionX = (Integer)PositionPanel.this.positionXTextField.getValue();
            }
            if (changeEvent.getSource() == PositionPanel.this.positionYTextField) {
                PositionPanel.this.positionY = (Integer)PositionPanel.this.positionYTextField.getValue();
            }
            if (changeEvent.getSource() == PositionPanel.this.scaleTextField) {
                PositionPanel.this.scale = ((Float)PositionPanel.this.scaleTextField.getValue()).floatValue();
            }
            PositionPanel.this.positionImagePanel.setSelectedPoint(PositionPanel.this.positionX, PositionPanel.this.positionY);
            PositionPanel.this.positionImagePanel.setScale(PositionPanel.this.scale);
            PositionPanel.this.positionImagePanel.repaint();
        }
    }

    private class ImagePanelMouseListener
    extends MouseAdapter {
        private ImagePanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (PositionPanel.this.positionImagePanel.isImageLoaded()) {
                int n = PositionPanel.this.positionImagePanel.getRelativeX(mouseEvent.getX());
                int n2 = PositionPanel.this.positionImagePanel.getRelativeY(mouseEvent.getY());
                PositionPanel.this.setPosition(n, n2);
                if (PositionPanel.this.positionPanelListener != null) {
                    PositionPanel.this.positionPanelListener.updatePositionValues(PositionPanel.this.positionX, PositionPanel.this.positionY);
                }
            }
        }
    }
}

