/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels.PositionImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class ElementImagePanel
extends PositionImagePanel {
    private static final long serialVersionUID = 1L;
    private Image element;
    private Trajectory trajectory = null;

    public ElementImagePanel(String string, String string2) {
        super(string);
        this.element = string2 != null ? AssetsController.getImage(string2) : null;
    }

    public ElementImagePanel(String string, String string2, Trajectory trajectory) {
        this(string, string2);
        this.trajectory = trajectory;
    }

    public void loadElement(String string) {
        this.element = string != null ? AssetsController.getImage(string) : null;
    }

    public void removeElementImage() {
        this.element = null;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isImageLoaded()) {
            if (this.trajectory != null) {
                int n;
                for (Trajectory.Side side : this.trajectory.getSides()) {
                    Trajectory.Node node = this.trajectory.getNodeForId(side.getIDStart());
                    n = this.getAbsoluteX(node.getX());
                    int n2 = this.getAbsoluteY(node.getY());
                    node = this.trajectory.getNodeForId(side.getIDEnd());
                    int n3 = this.getAbsoluteX(node.getX());
                    int n4 = this.getAbsoluteY(node.getY());
                    graphics.drawLine(n, n2, n3, n4);
                }
                for (Trajectory.Side side : this.trajectory.getNodes()) {
                    int n5 = this.getAbsoluteX(side.getX());
                    n = this.getAbsoluteY(side.getY());
                    graphics.fillOval(n5 - 5, n - 5, 10, 10);
                }
            }
            if (this.element != null) {
                this.paintRelativeImage(graphics, this.element, this.selectedX, this.selectedY, this.scale, true);
            } else {
                int n = this.getAbsoluteX(this.selectedX);
                int n6 = this.getAbsoluteY(this.selectedY);
                graphics.setColor(Color.RED);
                graphics.fillOval(n - 3, n6 - 3, 8, 8);
                graphics.setColor(Color.BLACK);
                graphics.drawOval(n - 3, n6 - 3, 7, 7);
            }
        }
    }
}

