/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imagepanels;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int MARGIN = 20;
    protected Image image = null;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected double sizeRatio;

    public ImagePanel() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ImagePanel.this.calculateSize();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JLabel(TC.get((String)"ImagePanel.ImageNotAvalaible")));
    }

    public ImagePanel(String string) {
        this();
        this.loadImage(string);
    }

    public void removeImage() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        this.removeAll();
        this.add(new JLabel(TC.get((String)"ImagePanel.ImageNotAvalaible")));
        this.revalidate();
        this.repaint();
    }

    public void loadImage(String string) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = string != null && string.length() > 0 ? AssetsController.getImage(string) : null;
        this.calculateSize();
        this.removeAll();
        if (!this.isImageLoaded()) {
            this.add(new JLabel(TC.get((String)"ImagePanel.ImageNotAvalaible")));
            this.revalidate();
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isImageLoaded()) {
            graphics.drawImage(this.image, this.x, this.y, this.width, this.height, this);
        }
    }

    public boolean isImageLoaded() {
        return this.image != null;
    }

    public int getRelativeX(int n) {
        int n2 = 0;
        if (this.isImageLoaded()) {
            n2 = (int)((double)(n - this.x) / this.sizeRatio);
        }
        return n2;
    }

    public int getRelativeY(int n) {
        int n2 = 0;
        if (this.isImageLoaded()) {
            n2 = (int)((double)(n - this.y) / this.sizeRatio);
        }
        return n2;
    }

    public int getAbsoluteX(int n) {
        int n2 = 0;
        if (this.isImageLoaded()) {
            n2 = (int)((double)n * this.sizeRatio + (double)this.x);
        }
        return n2;
    }

    public int getAbsoluteY(int n) {
        int n2 = 0;
        if (this.isImageLoaded()) {
            n2 = (int)((double)n * this.sizeRatio + (double)this.y);
        }
        return n2;
    }

    protected int getAbsoluteWidth(int n) {
        int n2 = 0;
        if (this.isImageLoaded()) {
            n2 = (int)((double)n * this.sizeRatio);
        }
        return n2;
    }

    protected int getAbsoluteHeight(int n) {
        int n2 = 0;
        if (this.isImageLoaded()) {
            n2 = (int)((double)n * this.sizeRatio);
        }
        return n2;
    }

    protected void paintRelativeImage(Graphics graphics, Image image, int n, int n2, float f, boolean bl) {
        if (this.isImageLoaded()) {
            int n3 = (int)((double)image.getWidth(null) * this.sizeRatio * (double)f);
            int n4 = (int)((double)image.getHeight(null) * this.sizeRatio * (double)f);
            int n5 = this.getAbsoluteX((int)((float)n - (float)image.getWidth(null) * f / 2.0f));
            int n6 = this.getAbsoluteY((int)((float)n2 - (float)image.getHeight(null) * f));
            graphics.drawImage(image, n5, n6, n3, n4, null);
            if (bl) {
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n5 - 1, n6 - 1, n3 + 2, n4 + 2);
                graphics.drawRect(n5 - 3, n6 - 3, n3 + 6, n4 + 6);
                graphics.setColor(Color.RED);
                graphics.drawRect(n5 - 2, n6 - 2, n3 + 4, n4 + 4);
            }
        }
    }

    private synchronized void calculateSize() {
        if (this.isImageLoaded() && this.getWidth() > 0 && this.getHeight() > 0) {
            double d;
            double d2 = (double)this.getWidth() / (double)this.getHeight();
            if (d2 <= (d = (double)this.image.getWidth(null) / (double)this.image.getHeight(null))) {
                int n;
                this.width = n = this.getWidth() - 40;
                this.height = (int)((double)n / d);
            } else {
                int n = this.getHeight() - 40;
                this.width = (int)((double)n * d);
                this.height = n;
            }
            this.x = (this.getWidth() - this.width) / 2;
            this.y = (this.getHeight() - this.height) / 2;
            this.sizeRatio = (double)this.width / (double)this.image.getWidth(null);
            this.repaint();
        }
    }

    public Dimension getImageSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }
}

