/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageElementSelectImage
extends ImageElement {
    private static final int LIGHT_BORDER = 1;
    private static final int HARD_BORDER = 2;
    private static final int RESCALE_BORDER = 3;
    private static final int RESCALE_BORDER_ACTIVE = 4;
    private static final int RESIZE_BORDER = 5;
    private static final int RESIZE_BORDER_ACTIVE = 6;
    private int DEFAULTWIDTH = 800;
    private int DEFAULTHEIGHT = 600;
    private int width;
    private int height;
    private int originalWidth;
    private int originalHeight;
    private int marginX;
    private int marginY;
    private int x;
    private int y;
    private BufferedImage image;
    private boolean movable;
    private boolean resize;
    private boolean resizeWidth;
    private BufferedImage background;

    public ImageElementSelectImage(BufferedImage bufferedImage, String string) {
        this.originalHeight = bufferedImage.getHeight();
        this.originalWidth = bufferedImage.getWidth();
        this.image = bufferedImage;
        this.width = this.DEFAULTWIDTH;
        this.height = this.DEFAULTHEIGHT;
        bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 6);
        this.x = (this.originalWidth - this.width) / 2;
        this.y = (this.originalHeight - this.height) / 2;
        this.resize = false;
        this.resizeWidth = false;
        this.movable = false;
        this.background = (BufferedImage)AssetsController.getImage(string);
        this.fillImage();
    }

    private void fillImage() {
        this.image.getGraphics().drawImage(this.background, 0, 0, null);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.YELLOW);
        graphics2D.fillRect(this.x, this.y, this.width, this.height);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.x, this.y, this.width - 1, this.height - 1);
    }

    private void paintBorders(int n) {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        if (n == 1) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.GRAY);
            graphics2D.fillRect(this.x - 2, this.y - 2, this.width + 4, this.getRealSize(2));
            graphics2D.fillRect(this.x - 2, this.y - 2, this.getRealSize(2), this.height + 2);
            graphics2D.fillRect(this.x + this.width, this.y, this.getRealSize(2), this.height + 2);
            graphics2D.fillRect(this.x - 2, this.y + this.height, this.width + 2, this.getRealSize(2));
            graphics2D.setColor(color);
        } else if (n == 2) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.RED);
            graphics2D.fillRect(this.x - 4, this.y - 4, this.width + 8, this.getRealSize(3));
            graphics2D.fillRect(this.x - 4, this.y - 4, this.getRealSize(3), this.height + 4);
            graphics2D.fillRect(this.x + this.width, this.y, this.getRealSize(3), this.height + 4);
            graphics2D.fillRect(this.x - 4, this.y + this.height, this.width + 4, this.getRealSize(3));
            graphics2D.setColor(color);
        } else if (n == 3) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.GREEN);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.fillRect(this.x + this.width - this.getRealSize(10), this.y - this.getRealSize(10), this.getRealSize(10) * 2, this.getRealSize(10) * 2);
            graphics2D.setColor(color);
        } else if (n == 4) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.RED);
            graphics2D.fillRect(this.x - 4, this.y - 4, this.width + 8, this.getRealSize(3));
            graphics2D.fillRect(this.x - 4, this.y - 4, this.getRealSize(3), this.height + 4);
            graphics2D.fillRect(this.x + this.width, this.y, this.getRealSize(3), this.height + 4);
            graphics2D.fillRect(this.x - 4, this.y + this.height, this.width + 4, this.getRealSize(3));
            graphics2D.setColor(Color.BLUE);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.fillRect(this.x + this.width - this.getRealSize(10), this.y - this.getRealSize(10), this.getRealSize(10) * 2, this.getRealSize(10) * 2);
            graphics2D.setColor(color);
        } else if (n == 5) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.GREEN);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.fillRect(this.x + this.width - this.getRealSize(10), this.y + this.height - this.getRealSize(10), this.getRealSize(10) * 2, this.getRealSize(10) * 2);
            graphics2D.setColor(color);
        } else if (n == 6) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.RED);
            graphics2D.fillRect(this.x - 4, this.y - 4, this.width + 8, this.getRealSize(3));
            graphics2D.fillRect(this.x - 4, this.y - 4, this.getRealSize(3), this.height + 4);
            graphics2D.fillRect(this.x + this.width, this.y, this.getRealSize(3), this.height + 4);
            graphics2D.fillRect(this.x - 4, this.y + this.height, this.width + 4, this.getRealSize(3));
            graphics2D.setColor(Color.BLUE);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.fillRect(this.x + this.width - this.getRealSize(10), this.y + this.height - this.getRealSize(10), this.getRealSize(10) * 2, this.getRealSize(10) * 2);
            graphics2D.setColor(color);
        }
    }

    @Override
    public void changeSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (this.height < 600) {
            this.height = 600;
        }
        if (this.width < 800) {
            this.width = 800;
        }
        if (this.width > this.height * 4 / 3) {
            this.height = this.width / 4 * 3;
        } else {
            this.width = this.height * 4 / 3;
        }
        if (this.height > this.originalHeight) {
            this.height = this.originalHeight;
        }
        if (this.width > this.originalWidth) {
            this.width = this.originalWidth;
        }
        this.recreateImage();
    }

    public void changeWidth(int n) {
        this.width = n;
        this.height = 600;
        if (this.width < 800) {
            this.width = 800;
        }
        if (this.width > this.originalWidth) {
            this.width = this.originalWidth;
        }
        this.recreateImage();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public int getRealX(int n) {
        return this.originalWidth * (n - this.marginX) / this.DEFAULTWIDTH;
    }

    public int getRealY(int n) {
        return this.originalHeight * (n - this.marginY) / this.DEFAULTHEIGHT;
    }

    public int getRealSize(int n) {
        return this.originalWidth * n / this.DEFAULTWIDTH;
    }

    @Override
    public float getScale() {
        return this.image.getWidth() / this.DEFAULTWIDTH;
    }

    @Override
    public DataControl getDataControl() {
        return null;
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void recreateImage() {
        this.fillImage();
        if (!(this.movable || this.resize || this.resizeWidth)) {
            this.paintBorders(1);
        }
        if (this.movable) {
            this.paintBorders(2);
        }
        if (this.resizeWidth) {
            this.paintBorders(4);
        } else {
            this.paintBorders(3);
        }
        if (this.resize) {
            this.paintBorders(6);
        } else {
            this.paintBorders(5);
        }
    }

    @Override
    public int getLayer() {
        return 0;
    }

    @Override
    public void changePosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.x > this.originalWidth - this.width) {
            this.x = this.originalWidth - this.width;
        }
        if (this.y > this.originalHeight - this.height) {
            this.y = this.originalHeight - this.height;
        }
        this.recreateImage();
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        return false;
    }

    public void getMovableElement(int n, int n2) {
        this.movable = false;
        if (n >= this.x && n <= this.x + this.width && n2 >= this.y && n2 <= this.y + this.height) {
            this.movable = true;
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canRescale() {
        return true;
    }

    public boolean isResize() {
        return this.resize;
    }

    public boolean isResizeWidth() {
        return this.resizeWidth;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void getResizeElement(int n, int n2) {
        int n3 = this.x + this.width;
        int n4 = this.y;
        this.resize = false;
        this.resizeWidth = false;
        int n5 = this.getRealSize(25);
        if (n > n3 - n5 && n < n3 + n5 && n2 > n4 + this.height - n5 && n2 < n4 + this.height + n5) {
            this.resize = true;
        } else if (n > n3 - n5 && n < n3 + n5 && n2 > n4 && n2 < this.height) {
            this.resizeWidth = true;
        }
    }

    public void updateMargin(int n, int n2) {
        this.marginX = n;
        this.marginY = n2;
    }

    public void updateSize(int n, int n2) {
        this.DEFAULTHEIGHT = n2;
        this.DEFAULTWIDTH = n - this.marginX * 2;
    }

    @Override
    public void setScale(float f) {
    }
}

