/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class ImageElementReference
extends ImageElement {
    private ElementReferenceDataControl elementReferenceDataControl;

    public ImageElementReference(ElementReferenceDataControl elementReferenceDataControl) {
        this.elementReferenceDataControl = elementReferenceDataControl;
        String string = Controller.getInstance().getElementImagePath(elementReferenceDataControl.getElementId());
        this.image = string != null ? AssetsController.getImage(string) : new ImageIcon("img/assets/EmptyImage.png").getImage();
    }

    @Override
    public int getX() {
        return this.elementReferenceDataControl.getElementX();
    }

    @Override
    public int getY() {
        return this.elementReferenceDataControl.getElementY();
    }

    @Override
    public float getScale() {
        return this.elementReferenceDataControl.getElementScale();
    }

    @Override
    public DataControl getDataControl() {
        return this.elementReferenceDataControl;
    }

    @Override
    public void recreateImage() {
        String string = Controller.getInstance().getElementImagePath(this.elementReferenceDataControl.getElementId());
        this.image = string != null ? AssetsController.getImage(string) : new ImageIcon("img/assets/EmptyImage.png").getImage();
    }

    @Override
    public int getLayer() {
        return this.elementReferenceDataControl.getElementReference().getLayer();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ImageElementReference)) {
            return false;
        }
        ImageElementReference imageElementReference = (ImageElementReference)object;
        return imageElementReference.elementReferenceDataControl.getElementId().equals(this.elementReferenceDataControl.getElementId());
    }

    @Override
    public void changePosition(int n, int n2) {
        this.elementReferenceDataControl.setElementPosition(n, n2);
    }

    @Override
    public void setScale(float f) {
        if (this.elementReferenceDataControl.getInfluenceArea() != null) {
            int n = (int)((float)this.image.getWidth(null) * f - (float)this.image.getWidth(null) * this.getScale());
            int n2 = (int)((float)this.image.getHeight(null) * f - (float)this.image.getHeight(null) * this.getScale());
            this.elementReferenceDataControl.getInfluenceArea().referenceScaleChanged(n, n2);
        }
        this.elementReferenceDataControl.setElementScale(f);
    }

    @Override
    public boolean canRescale() {
        return true;
    }

    @Override
    public boolean canResize() {
        return false;
    }

    @Override
    public void changeSize(int n, int n2) {
    }

    @Override
    public int getHeight() {
        return this.image.getHeight(null);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth(null);
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        if (this.image == null || !this.elementReferenceDataControl.isVisible()) {
            return false;
        }
        int n3 = ((BufferedImage)this.image).getRGB((int)((float)n / this.getScale()), (int)((float)n2 / this.getScale())) >>> 24;
        return n3 <= 128;
    }

    @Override
    public DataControl getReferencedDataControl() {
        return this.elementReferenceDataControl.getReferencedElementDataControl();
    }

    @Override
    public boolean isVisible() {
        return this.elementReferenceDataControl.isVisible();
    }
}

