/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageElementPlayer
extends ImageElement {
    private SceneDataControl sceneDataControl;

    public ImageElementPlayer(Image image, SceneDataControl sceneDataControl) {
        this.image = image;
        if (image == null) {
            image = new BufferedImage(10, 10, 6);
        }
        this.sceneDataControl = sceneDataControl;
    }

    @Override
    public DataControl getDataControl() {
        return null;
    }

    @Override
    public int getLayer() {
        return this.sceneDataControl.getPlayerLayer();
    }

    @Override
    public float getScale() {
        if (this.sceneDataControl.getTrajectory() != null && this.sceneDataControl.getTrajectory().hasTrajectory()) {
            return 1.0f;
        }
        return this.sceneDataControl.getPlayerScale();
    }

    @Override
    public int getX() {
        if (this.sceneDataControl.getDefaultInitialPositionX() < 0) {
            return 400;
        }
        return this.sceneDataControl.getDefaultInitialPositionX();
    }

    @Override
    public int getY() {
        if (this.sceneDataControl.getDefaultInitialPositionY() < 0 && this.image != null) {
            return 300 + this.image.getHeight(null);
        }
        return this.sceneDataControl.getDefaultInitialPositionY();
    }

    @Override
    public void recreateImage() {
    }

    @Override
    public void changePosition(int n, int n2) {
        this.sceneDataControl.setDefaultInitialPosition(n, n2);
    }

    @Override
    public void setScale(float f) {
        if (f > 0.2f && f < 5.0f) {
            this.sceneDataControl.setPlayerScale(f);
        }
    }

    @Override
    public boolean canRescale() {
        return this.sceneDataControl.getTrajectory() == null || !this.sceneDataControl.getTrajectory().hasTrajectory();
    }

    @Override
    public boolean canResize() {
        return false;
    }

    @Override
    public void changeSize(int n, int n2) {
    }

    @Override
    public int getHeight() {
        if (this.image != null) {
            return this.image.getHeight(null);
        }
        return 0;
    }

    @Override
    public int getWidth() {
        if (this.image != null) {
            return this.image.getWidth(null);
        }
        return 0;
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        if (this.image == null) {
            return false;
        }
        int n3 = ((BufferedImage)this.image).getRGB((int)((float)n / this.getScale()), (int)((float)n2 / this.getScale())) >>> 24;
        return n3 <= 128;
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }
}

