/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageElementNode
extends ImageElement {
    private NodeDataControl nodeDataControl;
    private Image playerImage;

    public ImageElementNode(NodeDataControl nodeDataControl) {
        this.nodeDataControl = nodeDataControl;
        String string = nodeDataControl.getPlayerImagePath();
        if (string != null && string.length() > 0) {
            this.playerImage = AssetsController.getImage(string);
        }
        if (this.playerImage != null) {
            float f = nodeDataControl.getScale();
            this.image = new BufferedImage(Math.max(this.playerImage.getWidth(null), (int)(10.0f * (1.0f / f))), this.playerImage.getHeight(null) + (int)(10.0f * (1.0f / f)), 6);
        } else {
            this.image = new BufferedImage(20, 20, 6);
        }
        this.fillImage();
    }

    private void fillImage() {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
        graphics2D.setComposite(alphaComposite);
        if (this.playerImage != null) {
            int n = this.playerImage.getWidth(null);
            int n2 = this.playerImage.getHeight(null);
            graphics2D.drawImage(this.playerImage, 0, 0, n, n2, null);
            alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
            if (this.nodeDataControl.isInitial()) {
                graphics2D.setColor(Color.RED);
            } else {
                graphics2D.setColor(Color.BLUE);
            }
            float f = this.nodeDataControl.getScale();
            graphics2D.fillOval(n / 2 - (int)(10.0f / f), n2 - (int)(10.0f / f), (int)(19.0f / f), (int)(19.0f / f));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawOval(n / 2 - (int)(10.0f / f), n2 - (int)(10.0f / f), (int)(19.0f / f), (int)(19.0f / f));
        } else {
            if (this.nodeDataControl.isInitial()) {
                graphics2D.setColor(Color.RED);
            } else {
                graphics2D.setColor(Color.BLUE);
            }
            graphics2D.fillOval(0, 0, this.image.getWidth(null), this.image.getHeight(null));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawOval(0, 0, this.image.getWidth(null) - 1, this.image.getHeight(null) - 1);
        }
    }

    @Override
    public void changePosition(int n, int n2) {
        this.nodeDataControl.setNode(n, n2, this.nodeDataControl.getScale());
    }

    @Override
    public DataControl getDataControl() {
        return null;
    }

    @Override
    public int getLayer() {
        return 0;
    }

    @Override
    public float getScale() {
        return this.nodeDataControl.getScale();
    }

    @Override
    public int getX() {
        return this.nodeDataControl.getX();
    }

    @Override
    public int getY() {
        return this.nodeDataControl.getY() + 10;
    }

    @Override
    public void recreateImage() {
        if (this.playerImage != null) {
            float f = this.nodeDataControl.getScale();
            this.image = new BufferedImage(Math.max(this.playerImage.getWidth(null), (int)(10.0f * (1.0f / f))), this.playerImage.getHeight(null) + (int)(10.0f * (1.0f / f)), 6);
        } else {
            this.image = new BufferedImage(20, 20, 6);
        }
        this.fillImage();
    }

    public NodeDataControl getNodeDataControl() {
        return this.nodeDataControl;
    }

    @Override
    public void setScale(float f) {
        this.nodeDataControl.setNode(this.nodeDataControl.getX(), this.nodeDataControl.getY(), f);
    }

    @Override
    public boolean canRescale() {
        return true;
    }

    @Override
    public boolean canResize() {
        return false;
    }

    @Override
    public void changeSize(int n, int n2) {
    }

    @Override
    public int getHeight() {
        return this.image.getHeight(null);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth(null);
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        return false;
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }
}

