/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.InfluenceAreaDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageElementInfluenceArea
extends ImageElement {
    private InfluenceAreaDataControl influenceAreaDataControl;
    private ImageElement imageElementReference;
    private boolean visible = true;

    public ImageElementInfluenceArea(InfluenceAreaDataControl influenceAreaDataControl, ImageElement imageElement) {
        this.influenceAreaDataControl = influenceAreaDataControl;
        this.imageElementReference = imageElement;
        if (influenceAreaDataControl.hasInfluenceArea()) {
            this.image = influenceAreaDataControl.getWidth() == 0 || influenceAreaDataControl.getHeight() == 0 ? null : new BufferedImage(influenceAreaDataControl.getWidth(), influenceAreaDataControl.getHeight(), 6);
        } else {
            int n = (int)((float)imageElement.getImage().getWidth(null) * imageElement.getScale() + 40.0f);
            int n2 = (int)((float)imageElement.getImage().getHeight(null) * imageElement.getScale() + 40.0f);
            this.image = new BufferedImage(n, n2, 6);
        }
        this.fillImage();
    }

    private void fillImage() {
        if (this.image != null) {
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(Color.BLUE);
            graphics2D.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, 0, this.image.getWidth(null) - 1, this.image.getHeight(null) - 1);
        }
    }

    @Override
    public void changePosition(int n, int n2) {
        int n3;
        int n4;
        if (!this.influenceAreaDataControl.hasInfluenceArea()) {
            n4 = (int)((float)this.imageElementReference.getImage().getWidth(null) * this.imageElementReference.getScale() + 40.0f);
            n3 = (int)((float)this.imageElementReference.getImage().getHeight(null) * this.imageElementReference.getScale() + 40.0f);
            this.influenceAreaDataControl.setInfluenceArea(-20, -20, n4, n3);
        }
        n4 = this.influenceAreaDataControl.getWidth();
        n3 = this.influenceAreaDataControl.getHeight();
        int n5 = (int)((float)this.imageElementReference.getWidth() * this.imageElementReference.getScale());
        int n6 = (int)((float)this.imageElementReference.getHeight() * this.imageElementReference.getScale());
        int n7 = this.imageElementReference.getX();
        int n8 = this.imageElementReference.getY();
        int n9 = n7 - n5 / 2;
        int n10 = n8 - n6;
        int n11 = n - n4 / 2;
        int n12 = n2 - n3;
        n12 -= n10;
        if (-(n11 -= n9) > n4) {
            n11 = -n4;
        }
        if (-n12 > n3) {
            n12 = -n3;
        }
        if ((float)n11 > (float)this.imageElementReference.getWidth() * this.imageElementReference.getScale()) {
            n11 = (int)((float)this.imageElementReference.getWidth() * this.imageElementReference.getScale());
        }
        if ((float)n12 > (float)this.imageElementReference.getHeight() * this.imageElementReference.getScale()) {
            n12 = (int)((float)this.imageElementReference.getHeight() * this.imageElementReference.getScale());
        }
        this.influenceAreaDataControl.setInfluenceArea(n11, n12, n4, n3);
    }

    @Override
    public DataControl getDataControl() {
        return null;
    }

    @Override
    public int getLayer() {
        return Integer.MAX_VALUE;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public int getX() {
        if (this.influenceAreaDataControl.hasInfluenceArea()) {
            int n = (int)((float)this.imageElementReference.getX() - (float)this.imageElementReference.getWidth() * this.imageElementReference.getScale() / 2.0f);
            return n + this.influenceAreaDataControl.getX() + this.influenceAreaDataControl.getWidth() / 2;
        }
        return this.imageElementReference.getX();
    }

    @Override
    public int getY() {
        if (this.influenceAreaDataControl.hasInfluenceArea()) {
            int n = (int)((float)this.imageElementReference.getY() - (float)this.imageElementReference.getHeight() * this.imageElementReference.getScale());
            return n + this.influenceAreaDataControl.getY() + this.influenceAreaDataControl.getHeight();
        }
        return this.imageElementReference.getY() + 20;
    }

    @Override
    public void recreateImage() {
        this.imageElementReference.recreateImage();
        if (this.influenceAreaDataControl.hasInfluenceArea()) {
            this.image = new BufferedImage(this.influenceAreaDataControl.getWidth(), this.influenceAreaDataControl.getHeight(), 6);
        } else {
            int n = (int)((float)this.imageElementReference.getImage().getWidth(null) * this.imageElementReference.getScale() + 40.0f);
            int n2 = (int)((float)this.imageElementReference.getImage().getHeight(null) * this.imageElementReference.getScale() + 40.0f);
            this.image = new BufferedImage(n, n2, 6);
        }
        this.fillImage();
    }

    @Override
    public void setScale(float f) {
    }

    @Override
    public boolean canRescale() {
        return false;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void changeSize(int n, int n2) {
        int n3 = this.influenceAreaDataControl.getX();
        int n4 = this.influenceAreaDataControl.getY();
        int n5 = n3 + 5;
        int n6 = n4 + 5;
        if (n + n3 < n5) {
            n = n5 - n3;
        }
        if (n2 + n4 < n6) {
            n2 = n6 - n4;
        }
        this.influenceAreaDataControl.setInfluenceArea(n3, n4, n, n2);
    }

    @Override
    public int getHeight() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getHeight(null);
    }

    @Override
    public int getWidth() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getWidth(null);
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        return false;
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

