/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;

public class ImageElementExit
extends ImageElement {
    private ExitDataControl exitDataControl;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private Polygon polygon;

    public ImageElementExit(ExitDataControl exitDataControl) {
        this.exitDataControl = exitDataControl;
        this.createImage();
    }

    private void createImage() {
        if (this.exitDataControl.isRectangular()) {
            this.image = new BufferedImage(this.exitDataControl.getWidth(), this.exitDataControl.getHeight(), 6);
            this.fillImage();
        } else {
            this.minX = Integer.MAX_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxX = 0;
            this.maxY = 0;
            for (Point point : this.exitDataControl.getPoints()) {
                if (point.getX() > (double)this.maxX) {
                    this.maxX = (int)point.getX();
                }
                if (point.getX() < (double)this.minX) {
                    this.minX = (int)point.getX();
                }
                if (point.getY() > (double)this.maxY) {
                    this.maxY = (int)point.getY();
                }
                if (!(point.getY() < (double)this.minY)) continue;
                this.minY = (int)point.getY();
            }
            this.image = this.exitDataControl.getPoints().size() >= 3 ? new BufferedImage(this.maxX - this.minX, this.maxY - this.minY, 6) : new BufferedImage(20, 20, 6);
            this.fillImageIrregular(this.minX, this.minY);
        }
    }

    private void fillImage() {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.RED);
        graphics2D.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.image.getWidth(null) - 1, this.image.getHeight(null) - 1);
    }

    private void fillImageIrregular(int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        this.polygon = new Polygon();
        int[] nArray = new int[this.exitDataControl.getPoints().size()];
        int[] nArray2 = new int[this.exitDataControl.getPoints().size()];
        for (int i = 0; i < this.exitDataControl.getPoints().size(); ++i) {
            nArray[i] = (int)this.exitDataControl.getPoints().get(i).getX() - n;
            nArray2[i] = (int)this.exitDataControl.getPoints().get(i).getY() - n2;
            this.polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.exitDataControl.getPoints().size() >= 3) {
            graphics2D.setColor(Color.RED);
            graphics2D.fillPolygon(nArray, nArray2, this.exitDataControl.getPoints().size());
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawPolygon(nArray, nArray2, this.exitDataControl.getPoints().size());
        }
    }

    @Override
    public void changePosition(int n, int n2) {
        if (this.exitDataControl.isRectangular()) {
            int n3 = this.exitDataControl.getWidth();
            int n4 = this.exitDataControl.getHeight();
            this.exitDataControl.setExit(n - n3 / 2, n2 - n4, n3, n4);
        }
    }

    @Override
    public DataControl getDataControl() {
        return this.exitDataControl;
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public int getX() {
        if (this.exitDataControl.isRectangular()) {
            return this.exitDataControl.getX() + this.exitDataControl.getWidth() / 2;
        }
        return this.minX + (this.maxX - this.minX) / 2;
    }

    @Override
    public int getY() {
        if (this.exitDataControl.isRectangular()) {
            return this.exitDataControl.getY() + this.exitDataControl.getHeight();
        }
        return this.maxY;
    }

    @Override
    public void recreateImage() {
        this.createImage();
    }

    @Override
    public void setScale(float f) {
    }

    @Override
    public boolean canRescale() {
        return false;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void changeSize(int n, int n2) {
        int n3 = this.exitDataControl.getX();
        int n4 = this.exitDataControl.getY();
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.exitDataControl.setExit(n3, n4, n, n2);
    }

    @Override
    public int getHeight() {
        if (this.exitDataControl.isRectangular()) {
            return this.exitDataControl.getHeight();
        }
        return this.maxY - this.minY;
    }

    @Override
    public int getWidth() {
        if (this.exitDataControl.isRectangular()) {
            return this.exitDataControl.getWidth();
        }
        return this.maxX - this.minX;
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        if (this.exitDataControl.isRectangular()) {
            return false;
        }
        return !this.polygon.contains(n, n2);
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }
}

