/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageElementBarrier
extends ImageElement {
    private BarrierDataControl barrierDataControl;

    public ImageElementBarrier(BarrierDataControl barrierDataControl) {
        this.barrierDataControl = barrierDataControl;
        int n = barrierDataControl.getX();
        int n2 = barrierDataControl.getY();
        int n3 = barrierDataControl.getWidth();
        int n4 = barrierDataControl.getHeight();
        if (n3 <= 0) {
            n3 = 1;
            barrierDataControl.setBarrier(n, n2, n3, n4);
        }
        if (n4 <= 0) {
            n4 = 1;
            barrierDataControl.setBarrier(n, n2, n3, n4);
        }
        this.image = new BufferedImage(barrierDataControl.getWidth(), barrierDataControl.getHeight(), 6);
        this.fillImage();
    }

    private void fillImage() {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.YELLOW);
        graphics2D.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.image.getWidth(null) - 1, this.image.getHeight(null) - 1);
    }

    @Override
    public void changePosition(int n, int n2) {
        int n3 = this.barrierDataControl.getWidth();
        int n4 = this.barrierDataControl.getHeight();
        this.barrierDataControl.setBarrier(n - n3 / 2, n2 - n4, n3, n4);
    }

    @Override
    public DataControl getDataControl() {
        return this.barrierDataControl;
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public int getX() {
        return this.barrierDataControl.getX() + this.barrierDataControl.getWidth() / 2;
    }

    @Override
    public int getY() {
        return this.barrierDataControl.getY() + this.barrierDataControl.getHeight();
    }

    @Override
    public void recreateImage() {
        this.image = new BufferedImage(this.barrierDataControl.getWidth(), this.barrierDataControl.getHeight(), 6);
        this.fillImage();
    }

    @Override
    public void setScale(float f) {
    }

    @Override
    public boolean canRescale() {
        return false;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void changeSize(int n, int n2) {
        int n3 = this.barrierDataControl.getX();
        int n4 = this.barrierDataControl.getY();
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.barrierDataControl.setBarrier(n3, n4, n, n2);
    }

    @Override
    public int getHeight() {
        return this.barrierDataControl.getHeight();
    }

    @Override
    public int getWidth() {
        return this.barrierDataControl.getWidth();
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        return false;
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }
}

