/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.imageelements;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;

public class ImageElementActiveArea
extends ImageElement {
    private ActiveAreaDataControl activeAreaDataControl;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private Polygon polygon;

    public ImageElementActiveArea(ActiveAreaDataControl activeAreaDataControl) {
        this.activeAreaDataControl = activeAreaDataControl;
        this.createImage();
    }

    private void createImage() {
        if (this.activeAreaDataControl.isRectangular()) {
            this.image = new BufferedImage(this.activeAreaDataControl.getWidth(), this.activeAreaDataControl.getHeight(), 6);
            this.fillImage();
        } else {
            this.minX = Integer.MAX_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxX = 0;
            this.maxY = 0;
            for (Point point : this.activeAreaDataControl.getPoints()) {
                if (point.getX() > (double)this.maxX) {
                    this.maxX = (int)point.getX();
                }
                if (point.getX() < (double)this.minX) {
                    this.minX = (int)point.getX();
                }
                if (point.getY() > (double)this.maxY) {
                    this.maxY = (int)point.getY();
                }
                if (!(point.getY() < (double)this.minY)) continue;
                this.minY = (int)point.getY();
            }
            if (this.activeAreaDataControl.getPoints().size() < 3) {
                this.maxX = 20;
                this.minX = 0;
                this.maxY = 20;
                this.minY = 0;
            }
            this.image = new BufferedImage(this.maxX - this.minX, this.maxY - this.minY, 6);
            this.fillImageIrregular(this.minX, this.minY);
        }
    }

    private void fillImage() {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.GREEN);
        graphics2D.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.image.getWidth(null) - 1, this.image.getHeight(null) - 1);
    }

    private void fillImageIrregular(int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        if (this.activeAreaDataControl.getPoints().size() > 0) {
            this.polygon = new Polygon();
            int[] nArray = new int[this.activeAreaDataControl.getPoints().size()];
            int[] nArray2 = new int[this.activeAreaDataControl.getPoints().size()];
            for (int i = 0; i < this.activeAreaDataControl.getPoints().size(); ++i) {
                nArray[i] = (int)this.activeAreaDataControl.getPoints().get(i).getX() - n;
                nArray2[i] = (int)this.activeAreaDataControl.getPoints().get(i).getY() - n2;
                this.polygon.addPoint(nArray[i], nArray2[i]);
            }
            graphics2D.setColor(Color.GREEN);
            graphics2D.fillPolygon(nArray, nArray2, this.activeAreaDataControl.getPoints().size());
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawPolygon(nArray, nArray2, this.activeAreaDataControl.getPoints().size());
        }
        graphics2D.dispose();
    }

    @Override
    public void changePosition(int n, int n2) {
        if (this.activeAreaDataControl.isRectangular()) {
            int n3 = this.activeAreaDataControl.getWidth();
            int n4 = this.activeAreaDataControl.getHeight();
            this.activeAreaDataControl.setActiveArea(n - n3 / 2, n2 - n4, n3, n4);
        }
    }

    @Override
    public DataControl getDataControl() {
        return this.activeAreaDataControl;
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public int getX() {
        if (this.activeAreaDataControl.isRectangular()) {
            return this.activeAreaDataControl.getX() + this.activeAreaDataControl.getWidth() / 2;
        }
        return this.minX + (this.maxX - this.minX) / 2;
    }

    @Override
    public int getY() {
        if (this.activeAreaDataControl.isRectangular()) {
            return this.activeAreaDataControl.getY() + this.activeAreaDataControl.getHeight();
        }
        return this.maxY;
    }

    @Override
    public void recreateImage() {
        this.createImage();
    }

    @Override
    public void setScale(float f) {
    }

    @Override
    public boolean canRescale() {
        return false;
    }

    @Override
    public boolean canResize() {
        return this.activeAreaDataControl.isRectangular();
    }

    @Override
    public void changeSize(int n, int n2) {
        int n3 = this.activeAreaDataControl.getX();
        int n4 = this.activeAreaDataControl.getY();
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.activeAreaDataControl.setActiveArea(n3, n4, n, n2);
    }

    @Override
    public int getHeight() {
        if (this.activeAreaDataControl.isRectangular()) {
            return this.activeAreaDataControl.getHeight();
        }
        return this.maxY - this.minY;
    }

    @Override
    public int getWidth() {
        if (this.activeAreaDataControl.isRectangular()) {
            return this.activeAreaDataControl.getWidth();
        }
        return this.maxX - this.minX;
    }

    @Override
    public boolean transparentPoint(int n, int n2) {
        if (this.activeAreaDataControl.isRectangular()) {
            return false;
        }
        return !this.polygon.contains(n, n2);
    }

    @Override
    public DataControl getReferencedDataControl() {
        return null;
    }
}

