/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.bookpanels;

import es.eucm.eadventure.common.auxiliar.ImageTransformer;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.tools.books.ChangeArrowsPositionTool;
import es.eucm.eadventure.editor.gui.otherpanels.imagepanels.ImagePanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class BookPreviewPanel
extends ImagePanel {
    protected static final long serialVersionUID = 1L;
    protected Image arrowLeftNormal;
    protected Image arrowRightNormal;
    protected Image arrowLeftOver;
    protected Image arrowRightOver;
    protected Point nextPagePoint;
    protected Point previousPagePoint;
    protected BookDataControl dataControl;

    public BookPreviewPanel(String string) {
        super(string);
    }

    public BookPreviewPanel(BookDataControl bookDataControl) {
        this.dataControl = bookDataControl;
        this.previousPagePoint = new Point(0, 0);
        this.nextPagePoint = new Point(0, 0);
        this.loadImages(this.dataControl);
        if (this.image != null) {
            this.setMinimumSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
        }
    }

    public void setPreviousPagePosition(Point point, Point point2) {
        int n = point.x;
        int n2 = point.y;
        this.previousPagePoint.x = n < 0 ? 0 : (n > this.image.getWidth(null) - this.arrowLeftNormal.getWidth(null) ? this.image.getWidth(null) - this.arrowLeftNormal.getWidth(null) : n);
        this.previousPagePoint.y = n2 < 0 ? 0 : (n2 > this.image.getHeight(null) - this.arrowLeftNormal.getHeight(null) ? this.image.getHeight(null) - this.arrowLeftNormal.getHeight(null) : n2);
        Controller.getInstance().addTool(new ChangeArrowsPositionTool(this.dataControl, (Point)this.nextPagePoint.clone(), (Point)this.nextPagePoint.clone(), point2, (Point)this.previousPagePoint.clone()));
    }

    public void setNextPagePosition(Point point, Point point2) {
        int n = point.x;
        int n2 = point.y;
        this.nextPagePoint.x = n < 0 ? 0 : (n > this.image.getWidth(null) - this.arrowRightNormal.getWidth(null) ? this.image.getWidth(null) - this.arrowRightNormal.getWidth(null) : n);
        this.nextPagePoint.y = n2 < 0 ? 0 : (n2 > this.image.getHeight(null) - this.arrowRightNormal.getHeight(null) ? this.image.getHeight(null) - this.arrowRightNormal.getHeight(null) : n2);
        Controller.getInstance().addTool(new ChangeArrowsPositionTool(this.dataControl, point2, (Point)this.nextPagePoint.clone(), (Point)this.previousPagePoint.clone(), (Point)this.previousPagePoint.clone()));
    }

    public Point getPreviousPagePosition() {
        return this.previousPagePoint;
    }

    public Point getNextPagePosition() {
        return this.nextPagePoint;
    }

    public void loadImages(BookDataControl bookDataControl) {
        this.image = AssetsController.getImage(bookDataControl.getPreviewImage());
        this.arrowLeftNormal = AssetsController.getImage(bookDataControl.getArrowImagePath(0, 0));
        this.arrowRightNormal = AssetsController.getImage(bookDataControl.getArrowImagePath(1, 0));
        this.arrowLeftOver = AssetsController.getImage(bookDataControl.getArrowImagePath(0, 1));
        this.arrowRightOver = AssetsController.getImage(bookDataControl.getArrowImagePath(1, 1));
        if (this.arrowLeftNormal == null) {
            if (this.arrowLeftOver != null) {
                this.arrowLeftNormal = this.arrowLeftOver;
            } else if (this.arrowRightNormal != null) {
                this.arrowLeftNormal = ImageTransformer.getInstance().getScaledImage(this.arrowRightNormal, -1.0f, 1.0f);
            } else if (this.arrowRightOver != null) {
                this.arrowLeftNormal = ImageTransformer.getInstance().getScaledImage(this.arrowRightOver, -1.0f, 1.0f);
            } else {
                this.arrowLeftNormal = AssetsController.getImage("assets/special/DefaultLeftNormalArrow.png");
                this.arrowLeftOver = AssetsController.getImage("assets/special/DefaultLeftOverArrow.png");
            }
        }
        if (this.arrowRightNormal == null) {
            this.arrowRightNormal = this.arrowRightOver != null ? this.arrowRightOver : ImageTransformer.getInstance().getScaledImage(this.arrowLeftNormal, -1.0f, 1.0f);
        }
        if (this.arrowLeftOver == null) {
            this.arrowLeftOver = this.arrowLeftNormal;
        }
        if (this.arrowRightOver == null) {
            this.arrowRightOver = ImageTransformer.getInstance().getScaledImage(this.arrowLeftOver, -1.0f, 1.0f);
        }
        if (this.arrowLeftNormal != null && this.arrowRightNormal != null && !this.setArrowsPosition(bookDataControl)) {
            this.setDefaultArrowsPosition();
        }
    }

    private boolean setArrowsPosition(BookDataControl bookDataControl) {
        Point point = bookDataControl.getNextPagePosition();
        if (point == null) {
            return false;
        }
        this.nextPagePoint = point;
        Point point2 = bookDataControl.getPreviousPagePosition();
        if (point2 == null) {
            return false;
        }
        this.previousPagePoint = point2;
        return true;
    }

    protected boolean isInPreviousPage(int n, int n2) {
        int n3 = this.getAbsoluteX(this.previousPagePoint.x) + this.getAbsoluteWidth(this.arrowLeftNormal.getWidth(null));
        int n4 = this.getAbsoluteY(this.previousPagePoint.y) + this.getAbsoluteHeight(this.arrowLeftNormal.getHeight(null));
        return this.getAbsoluteX(this.previousPagePoint.x) < n && n < n3 && this.getAbsoluteY(this.previousPagePoint.y) < n2 && n2 < n4;
    }

    protected boolean isInNextPage(int n, int n2) {
        int n3 = this.getAbsoluteX(this.nextPagePoint.x) + this.getAbsoluteWidth(this.arrowRightNormal.getWidth(null));
        int n4 = this.getAbsoluteY(this.nextPagePoint.y) + this.getAbsoluteHeight(this.arrowRightNormal.getHeight(null));
        return this.getAbsoluteX(this.nextPagePoint.x) < n && n < n3 && this.getAbsoluteY(this.nextPagePoint.y) < n2 && n2 < n4;
    }

    public void setDefaultArrowsPosition() {
        int n = 20;
        Point point = (Point)this.previousPagePoint.clone();
        this.previousPagePoint = new Point(n, this.image.getHeight(null) - this.arrowLeftNormal.getHeight(null) - n);
        Point point2 = (Point)this.nextPagePoint.clone();
        this.nextPagePoint = new Point(this.image.getWidth(null) - this.arrowRightNormal.getWidth(null) - n, this.image.getHeight(null) - this.arrowRightNormal.getHeight(null) - n);
        Controller.getInstance().addTool(new ChangeArrowsPositionTool(this.dataControl, point2, (Point)this.nextPagePoint.clone(), point, (Point)this.previousPagePoint.clone()));
        Controller.getInstance().updatePanel();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isImageLoaded()) {
            this.paintBackground(graphics);
            this.paintArrows(graphics);
        }
    }

    protected void paintArrows(Graphics graphics) {
        this.paintPreviousPageArrow(graphics);
        this.paintNextPageArrow(graphics);
    }

    protected void paintPreviousPageArrow(Graphics graphics) {
        if (this.arrowLeftNormal != null) {
            graphics.drawImage(this.arrowLeftNormal, this.getAbsoluteX(this.previousPagePoint.x), this.getAbsoluteY(this.previousPagePoint.y), this.getAbsoluteWidth(this.arrowLeftNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowLeftNormal.getHeight(null)), null);
        }
    }

    protected void paintNextPageArrow(Graphics graphics) {
        if (this.arrowRightNormal != null) {
            graphics.drawImage(this.arrowRightNormal, this.getAbsoluteX(this.nextPagePoint.x), this.getAbsoluteY(this.nextPagePoint.y), this.getAbsoluteWidth(this.arrowRightNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowRightNormal.getHeight(null)), null);
        }
    }

    protected void paintBackground(Graphics graphics) {
        super.paint(graphics);
    }
}

