/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.bookpanels;

import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphsListDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPreviewPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class BookParagraphPreviewPanel
extends BookPreviewPanel {
    private static final long serialVersionUID = 1L;
    private static final int TEXT_FIRST_COLUMN = 110;
    private static final int TEXT_SECOND_COLUMN = 445;
    private static final int TEXT_TOP_POSITION = 75;
    private static final int TEXT_WIDTH = 250;
    private static final int TEXT_WIDTH_BULLET = 225;
    private static final int PAGE_TEXT_HEIGHT = 400;
    private static final int LINE_HEIGHT = 25;
    private static final int TITLE_HEIGHT = 50;
    private Image bookContinousImage;
    private int pageCount;
    private int currentPage;
    protected Image currentArrowLeft;
    protected Image currentArrowRight;
    private BookParagraphsListDataControl bookParagraphsListDataControl;

    public BookParagraphPreviewPanel(BookDataControl bookDataControl, BookParagraphsListDataControl bookParagraphsListDataControl) {
        super(bookDataControl);
        this.currentArrowLeft = this.arrowLeftNormal;
        this.currentArrowRight = this.arrowRightNormal;
        this.bookParagraphsListDataControl = bookParagraphsListDataControl;
        this.updatePreview();
        ClickMouseListener clickMouseListener = new ClickMouseListener();
        this.addMouseListener(clickMouseListener);
        this.addMouseMotionListener(clickMouseListener);
    }

    public void updatePreview() {
        this.currentPage = 0;
        int n = 0;
        ArrayList<ParagraphImage> arrayList = new ArrayList<ParagraphImage>();
        for (BookParagraphDataControl object : this.bookParagraphsListDataControl.getBookParagraphs()) {
            ParagraphImage paragraphImage = null;
            if (object.getType() == 15) {
                paragraphImage = this.createTextParagraphImage(object.getParagraphContent());
            } else if (object.getType() == 14) {
                paragraphImage = this.createTitleParagraphImage(object.getParagraphContent());
            } else if (object.getType() == 16) {
                paragraphImage = this.createBulletImageParagraph(object.getParagraphContent());
            } else if (object.getType() == 17) {
                paragraphImage = this.createImageParagraphImage(object.getParagraphContent());
            }
            if (paragraphImage.image == null) continue;
            n += paragraphImage.image.getHeight(null);
            arrayList.add(paragraphImage);
        }
        this.pageCount = (int)Math.ceil((double)n / 400.0);
        int n2 = 0;
        this.bookContinousImage = new BufferedImage(250, n + 400, 2);
        for (ParagraphImage paragraphImage : arrayList) {
            if (!paragraphImage.canBeSplitted && n2 % 400 + paragraphImage.image.getHeight(null) > 400) {
                n2 += 400 - n2 % 400;
                this.bookContinousImage.getGraphics().drawImage(paragraphImage.image, 0, n2, null);
                n2 += paragraphImage.image.getHeight(null);
                continue;
            }
            if (paragraphImage.isTitle && n2 % 400 + paragraphImage.image.getHeight(null) > 400) {
                int n3 = paragraphImage.image.getHeight(null) / 50;
                int n4 = (int)Math.floor((400 - n2 % 400) / 50);
                if (n4 > n3) {
                    this.bookContinousImage.getGraphics().drawImage(paragraphImage.image, 0, n2, null);
                    n2 += paragraphImage.image.getHeight(null);
                    continue;
                }
                int n5 = 50 * n4;
                this.bookContinousImage.getGraphics().drawImage(paragraphImage.image, 0, n2, paragraphImage.image.getWidth(null), n2 + n5, 0, 0, paragraphImage.image.getWidth(null), n4 * 50, null);
                n2 += 400 - n2 % 400;
                this.bookContinousImage.getGraphics().drawImage(paragraphImage.image, 0, n2, paragraphImage.image.getWidth(null), n2 + 50 * (n3 - n4), 0, 50 * n4, paragraphImage.image.getWidth(null), 50 * n3, null);
                n2 += 50 * (n3 - n4);
                continue;
            }
            this.bookContinousImage.getGraphics().drawImage(paragraphImage.image, 0, n2, paragraphImage.image.getWidth(null), paragraphImage.image.getHeight(null), null);
            n2 += paragraphImage.image.getHeight(null);
        }
        this.updateUI();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isImageLoaded()) {
            this.paintBackground(graphics);
            if (this.currentPage > 1 && this.currentArrowLeft != null) {
                graphics.drawImage(this.currentArrowLeft, this.getAbsoluteX(this.previousPagePoint.x), this.getAbsoluteY(this.previousPagePoint.y), this.getAbsoluteWidth(this.arrowLeftNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowLeftNormal.getHeight(null)), null);
            }
            if (this.currentPage + 1 < this.pageCount - 1 && this.currentArrowRight != null) {
                graphics.drawImage(this.currentArrowRight, this.getAbsoluteX(this.nextPagePoint.x), this.getAbsoluteY(this.nextPagePoint.y), this.getAbsoluteWidth(this.currentArrowRight.getWidth(null)), this.getAbsoluteHeight(this.currentArrowRight.getHeight(null)), null);
            }
            graphics.drawImage(this.bookContinousImage, this.getAbsoluteX(110), this.getAbsoluteY(80), this.getAbsoluteX(360), this.getAbsoluteY(480), 0, this.currentPage * 400, 250, (this.currentPage + 1) * 400, null);
            if (this.currentPage < this.pageCount - 1) {
                graphics.drawImage(this.bookContinousImage, this.getAbsoluteX(445), this.getAbsoluteY(80), this.getAbsoluteX(695), this.getAbsoluteY(480), 0, (this.currentPage + 1) * 400, 250, (this.currentPage + 2) * 400, null);
            }
        } else {
            this.paintBackground(graphics);
        }
    }

    private ParagraphImage createTextParagraphImage(String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        String string3 = "";
        Font font = new Font("Dialog", 0, 18);
        while (!string.equals("")) {
            char c = string.charAt(0);
            string = string.substring(1);
            if (c == '\n') {
                object2 = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
                if (((RectangularShape)object2).getWidth() < 250.0) {
                    string3 = string3 + string2;
                    arrayList.add(string3);
                    string2 = "";
                    string3 = "";
                    continue;
                }
                arrayList.add(string3);
                arrayList.add(string2.substring(1));
                string3 = "";
                string2 = "";
                continue;
            }
            if (Character.isWhitespace(c)) {
                object2 = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
                if (((RectangularShape)object2).getWidth() < 250.0) {
                    string3 = string3 + string2;
                    string2 = " ";
                    continue;
                }
                arrayList.add(string3);
                string3 = string2.substring(1) + " ";
                string2 = "";
                continue;
            }
            object2 = font.getStringBounds(string3 + string2 + c, new FontRenderContext(null, false, true));
            if (((RectangularShape)object2).getWidth() < 250.0) {
                string2 = string2 + c;
                continue;
            }
            if (string3 != "") {
                arrayList.add(string3);
            }
            string3 = "";
            object = font.getStringBounds(string2 + c, new FontRenderContext(null, false, true));
            if (((RectangularShape)object).getWidth() < 250.0) {
                string2 = string2 + c;
                continue;
            }
            arrayList.add(string2);
            string2 = "" + c;
        }
        Rectangle2D rectangle2D = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
        if (rectangle2D.getWidth() < 250.0) {
            string3 = string3 + string2;
        } else {
            arrayList.add(string3);
            string3 = string2.substring(1);
        }
        arrayList.add(string3);
        object2 = new BufferedImage(250, arrayList.size() * 25, 2);
        object = ((Image)object2).getGraphics();
        ((Graphics)object).setFont(font);
        ((Graphics)object).setColor(Color.DARK_GRAY);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            string3 = (String)arrayList.get(i);
            ((Graphics)object).drawString(string3, n, n2 + 25 - 9);
            n2 += 25;
        }
        return new ParagraphImage((Image)object2, true);
    }

    private ParagraphImage createTitleParagraphImage(String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        String string3 = "";
        Font font = new Font("Dialog", 0, 32);
        while (!string.equals("")) {
            char c = string.charAt(0);
            string = string.substring(1);
            if (c == '\n') {
                object2 = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
                if (((RectangularShape)object2).getWidth() < 250.0) {
                    string3 = string3 + string2;
                    arrayList.add(string3);
                    string2 = "";
                    string3 = "";
                    continue;
                }
                arrayList.add(string3);
                arrayList.add(string2.substring(1));
                string3 = "";
                string2 = "";
                continue;
            }
            if (Character.isWhitespace(c)) {
                object2 = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
                if (((RectangularShape)object2).getWidth() < 250.0) {
                    string3 = string3 + string2;
                    string2 = " ";
                    continue;
                }
                arrayList.add(string3);
                string3 = string2.substring(1) + " ";
                string2 = "";
                continue;
            }
            object2 = font.getStringBounds(string3 + string2 + c, new FontRenderContext(null, false, true));
            if (((RectangularShape)object2).getWidth() < 250.0) {
                string2 = string2 + c;
                continue;
            }
            if (string3 != "") {
                arrayList.add(string3);
            }
            string3 = "";
            object = font.getStringBounds(string2 + c, new FontRenderContext(null, false, true));
            if (((RectangularShape)object).getWidth() < 250.0) {
                string2 = string2 + c;
                continue;
            }
            arrayList.add(string2);
            string2 = "" + c;
        }
        Rectangle2D rectangle2D = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
        if (rectangle2D.getWidth() < 250.0) {
            string3 = string3 + string2;
        } else {
            arrayList.add(string3);
            string3 = string2.substring(1);
        }
        arrayList.add(string3);
        object2 = new BufferedImage(250, arrayList.size() * 50, 2);
        object = ((Image)object2).getGraphics();
        ((Graphics)object).setFont(font);
        ((Graphics)object).setColor(Color.DARK_GRAY);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            string3 = (String)arrayList.get(i);
            ((Graphics)object).drawString(string3, n, n2 + 50 - 15);
            n2 += 50;
        }
        return new ParagraphImage((Image)object2, true, true);
    }

    private ParagraphImage createBulletImageParagraph(String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        String string3 = "";
        Font font = new Font("Dialog", 0, 18);
        while (!string.equals("")) {
            char c = string.charAt(0);
            string = string.substring(1);
            if (c == '\n') {
                object2 = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
                if (((RectangularShape)object2).getWidth() < 225.0) {
                    string3 = string3 + string2;
                    arrayList.add(string3);
                    string2 = "";
                    string3 = "";
                    continue;
                }
                arrayList.add(string3);
                arrayList.add(string2.substring(1));
                string2 = "";
                string3 = "";
                continue;
            }
            if (Character.isWhitespace(c)) {
                object2 = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
                if (((RectangularShape)object2).getWidth() < 225.0) {
                    string3 = string3 + string2;
                    string2 = " ";
                    continue;
                }
                arrayList.add(string3);
                string3 = string2.substring(1) + " ";
                string2 = "";
                continue;
            }
            object2 = font.getStringBounds(string3 + string2 + c, new FontRenderContext(null, false, true));
            if (((RectangularShape)object2).getWidth() < 225.0) {
                string2 = string2 + c;
                continue;
            }
            if (string3 != "") {
                arrayList.add(string3);
            }
            string3 = "";
            object = font.getStringBounds(string2 + c, new FontRenderContext(null, false, true));
            if (((RectangularShape)object).getWidth() < 225.0) {
                string2 = string2 + c;
                continue;
            }
            arrayList.add(string2);
            string2 = "" + c;
        }
        Rectangle2D rectangle2D = font.getStringBounds(string3 + " " + string2, new FontRenderContext(null, false, true));
        if (rectangle2D.getWidth() < 225.0) {
            string3 = string3 + string2;
        } else {
            arrayList.add(string3);
            string3 = string2.substring(1);
        }
        arrayList.add(string3);
        object2 = new BufferedImage(250, arrayList.size() * 25, 2);
        object = ((Image)object2).getGraphics();
        ((Graphics)object).setFont(font);
        ((Graphics)object).setColor(Color.DARK_GRAY);
        int n = 25;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i == 0) {
                ((Graphics)object).fillOval(5, n2 + 5, n - 15, n - 15);
            }
            string3 = (String)arrayList.get(i);
            ((Graphics)object).drawString(string3, n, n2 + 25 - 9);
            n2 += 25;
        }
        return new ParagraphImage((Image)object2, true);
    }

    private ParagraphImage createImageParagraphImage(String string) {
        Image image = null;
        if (string != null && string != "") {
            image = AssetsController.getImage(string);
        }
        BufferedImage bufferedImage = null;
        if (image != null) {
            bufferedImage = new BufferedImage(250, (int)Math.ceil((double)image.getHeight(null) / 25.0) * 25, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            graphics.drawImage(image, 0, 0, null);
        }
        return new ParagraphImage(bufferedImage, false);
    }

    private class ParagraphImage {
        public Image image;
        public boolean canBeSplitted;
        public boolean isTitle;

        public ParagraphImage(Image image, boolean bl, boolean bl2) {
            this.isTitle = bl2;
            this.image = image;
            this.canBeSplitted = bl;
        }

        public ParagraphImage(Image image, boolean bl) {
            this(image, bl, false);
        }
    }

    private class ClickMouseListener
    extends MouseAdapter {
        private ClickMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (BookParagraphPreviewPanel.this.isInPreviousPage(n2, n = mouseEvent.getY())) {
                if (BookParagraphPreviewPanel.this.currentPage - 2 >= 0) {
                    BookParagraphPreviewPanel.this.currentPage -= 2;
                }
                BookParagraphPreviewPanel.this.repaint();
            } else if (BookParagraphPreviewPanel.this.isInNextPage(n2, n)) {
                if (BookParagraphPreviewPanel.this.currentPage + 2 < BookParagraphPreviewPanel.this.pageCount) {
                    BookParagraphPreviewPanel.this.currentPage += 2;
                }
                BookParagraphPreviewPanel.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            BookParagraphPreviewPanel.this.currentArrowLeft = BookParagraphPreviewPanel.this.isInPreviousPage(n2, n = mouseEvent.getY()) ? BookParagraphPreviewPanel.this.arrowLeftOver : BookParagraphPreviewPanel.this.arrowLeftNormal;
            BookParagraphPreviewPanel.this.currentArrowRight = BookParagraphPreviewPanel.this.isInNextPage(n2, n) ? BookParagraphPreviewPanel.this.arrowRightOver : BookParagraphPreviewPanel.this.arrowRightNormal;
            BookParagraphPreviewPanel.this.repaint();
        }
    }
}

