/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.bookpanels;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.BookEditorPane;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.book.PagesTable;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookEditorPaneEditor;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPreviewPanel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;

public class BookPagePreviewPanel
extends BookPreviewPanel {
    private static final long serialVersionUID = 1L;
    private boolean isValid;
    private BookEditorPane editorPane;
    private Image imagePage;
    protected Image currentArrowLeft;
    protected Image currentArrowRight;
    private BookPage currentBookPage;
    private int pageIndex;
    private List<BookPage> bookPageList;
    private BookPageMouseListener mouseListener;
    private boolean drawArrows = true;
    private PagesTable pagesTable;

    public BookPagePreviewPanel(BookDataControl bookDataControl, boolean bl) {
        super(bookDataControl);
        this.setOpaque(false);
        this.isValid = true;
        this.bookPageList = bookDataControl.getBookPagesList().getBookPages();
        super.loadImages(bookDataControl);
        this.mouseListener = new BookPageMouseListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.currentArrowLeft = this.arrowLeftNormal;
        this.currentArrowRight = this.arrowRightNormal;
    }

    public BookPagePreviewPanel(BookDataControl bookDataControl, boolean bl, PagesTable pagesTable) {
        this(bookDataControl, bl);
        this.pagesTable = pagesTable;
    }

    public BookPagePreviewPanel(BookDataControl bookDataControl, boolean bl, int n) {
        this(bookDataControl, bl);
        this.setCurrentBookPage(n);
    }

    public BookEditorPane getBookEditorPane() {
        return this.editorPane;
    }

    public boolean setCurrentBookPage(int n) {
        try {
            this.currentBookPage = this.bookPageList.get(n);
            this.pageIndex = n;
        }
        catch (Exception exception) {
            return false;
        }
        if (this.currentBookPage != null) {
            return this.setCurrentBookPage(this.currentBookPage);
        }
        return false;
    }

    public boolean setCurrentBookPage(BookPage bookPage) {
        return this.setCurrentBookPage(bookPage, false);
    }

    public boolean setCurrentBookPage(BookPage bookPage, boolean bl) {
        this.currentBookPage = bookPage;
        if (this.currentBookPage != null) {
            if (this.currentBookPage.getType() == 0) {
                this.isValid = this.createURLPage(this.currentBookPage);
                this.imagePage = null;
            } else if (this.currentBookPage.getType() == 1) {
                this.isValid = this.createResourcePage(this.currentBookPage, bl);
                this.imagePage = null;
            } else if (this.currentBookPage.getType() == 2) {
                this.isValid = this.createImagePage(this.currentBookPage);
            }
            if (this.editorPane != null) {
                this.repaint();
            }
            if (this.isValid && this.pagesTable != null) {
                this.pagesTable.changeSelection(this.pageIndex, 0, false, false);
            }
            return this.isValid;
        }
        return false;
    }

    public void setDrawArrows(boolean bl) {
        this.drawArrows = bl;
    }

    private boolean createImagePage(BookPage bookPage) {
        if (bookPage.getUri() != null && bookPage.getUri().length() > 0) {
            this.imagePage = AssetsController.getImage(bookPage.getUri());
        }
        this.isValid = this.imagePage != null;
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createResourcePage(BookPage bookPage, boolean bl) {
        this.editorPane = new BookEditorPaneEditor(this.currentBookPage);
        ((BookEditorPaneEditor)this.editorPane).setExport(bl);
        URL uRL = AssetsController.getResourceAsURLFromZip(bookPage.getUri());
        String string = uRL.getFile().substring(uRL.getFile().lastIndexOf(46) + 1, uRL.getFile().length()).toLowerCase();
        if (string.equals("html") || string.equals("htm") || string.equals("rtf")) {
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = null;
            try {
                int n;
                inputStream = uRL.openStream();
                while ((n = inputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            catch (IOException iOException) {
                this.isValid = false;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.isValid = false;
                    }
                }
            }
            if (string.equals("html") || string.equals("htm")) {
                this.editorPane.setContentType("text/html");
                this.editorPane.setText(stringBuffer.toString());
                try {
                    this.editorPane.setDocumentBase(new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile()));
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else {
                this.editorPane.setContentType("text/rtf");
                this.editorPane.setText(stringBuffer.toString());
            }
            this.isValid = true;
        }
        return this.isValid;
    }

    private boolean createURLPage(BookPage bookPage) {
        URL uRL = null;
        this.editorPane = new BookEditorPane();
        try {
            uRL = new URL(bookPage.getUri());
            uRL.openStream().close();
        }
        catch (Exception exception) {
            this.isValid = false;
        }
        try {
            if (this.isValid) {
                this.editorPane.setPage(uRL);
                this.editorPane.setEditable(false);
                this.isValid = this.editorPane.getEditorKit() instanceof HTMLEditorKit || this.editorPane.getEditorKit() instanceof RTFEditorKit;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isValid;
    }

    public BookPage getCurrentBookPage() {
        return this.currentBookPage;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.bookPageList.size() == 0) {
            this.currentBookPage = null;
        }
        if (this.currentBookPage != null && this.isImageLoaded()) {
            graphics.drawImage(this.image, this.getAbsoluteX(0), this.getAbsoluteY(0), this.width, this.height, null);
            if (this.imagePage != null) {
                graphics.drawImage(this.imagePage, this.getAbsoluteX(this.currentBookPage.getMargin()), this.getAbsoluteY(this.currentBookPage.getMarginTop()), this.getAbsoluteWidth(this.imagePage.getWidth(null)), this.getAbsoluteHeight(this.imagePage.getHeight(null)), null);
            } else if (this.editorPane != null) {
                int n = this.getAbsoluteX(this.currentBookPage.getMargin());
                int n2 = this.getAbsoluteY(this.currentBookPage.getMarginTop());
                int n3 = this.width - this.getAbsoluteWidth(this.currentBookPage.getMarginEnd());
                int n4 = this.height - this.getAbsoluteHeight(this.currentBookPage.getMarginBottom());
                this.editorPane.paint(graphics, n, n2, n3, n4);
            }
            if (this.drawArrows) {
                if (!this.isInFirstPage() && this.currentArrowLeft != null) {
                    graphics.drawImage(this.currentArrowLeft, this.getAbsoluteX(this.previousPagePoint.x), this.getAbsoluteY(this.previousPagePoint.y), this.getAbsoluteWidth(this.arrowLeftNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowLeftNormal.getHeight(null)), null);
                }
                if (!this.isInLastPage() && this.currentArrowRight != null) {
                    graphics.drawImage(this.currentArrowRight, this.getAbsoluteX(this.nextPagePoint.x), this.getAbsoluteY(this.nextPagePoint.y), this.getAbsoluteWidth(this.arrowRightNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowRightNormal.getHeight(null)), null);
                }
            }
        }
    }

    public void nextPage() {
        if (!this.isInLastPage()) {
            ++this.pageIndex;
            this.setCurrentBookPage(this.pageIndex);
        }
    }

    public void previousPage() {
        if (!this.isInFirstPage()) {
            --this.pageIndex;
            this.setCurrentBookPage(this.pageIndex);
        }
    }

    public boolean isInFirstPage() {
        return this.pageIndex == 0;
    }

    public boolean isInLastPage() {
        return this.pageIndex == this.bookPageList.size() - 1;
    }

    @Override
    protected boolean isInNextPage(int n, int n2) {
        return super.isInNextPage(n, n2);
    }

    @Override
    protected boolean isInPreviousPage(int n, int n2) {
        return super.isInPreviousPage(n, n2);
    }

    private class BookPageMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private BookPageMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.getSource() == BookPagePreviewPanel.this.editorPane) {
                n += BookPagePreviewPanel.this.currentBookPage.getMarginStart();
                n2 += BookPagePreviewPanel.this.currentBookPage.getMarginTop();
            }
            if (BookPagePreviewPanel.this.isInNextPage(n, n2)) {
                BookPagePreviewPanel.this.nextPage();
            } else if (BookPagePreviewPanel.this.isInPreviousPage(n, n2)) {
                BookPagePreviewPanel.this.previousPage();
            }
            BookPagePreviewPanel.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            BookPagePreviewPanel.this.currentArrowLeft = BookPagePreviewPanel.this.isInPreviousPage(n2, n = mouseEvent.getY()) ? BookPagePreviewPanel.this.arrowLeftOver : BookPagePreviewPanel.this.arrowLeftNormal;
            BookPagePreviewPanel.this.currentArrowRight = BookPagePreviewPanel.this.isInNextPage(n2, n) ? BookPagePreviewPanel.this.arrowRightOver : BookPagePreviewPanel.this.arrowRightNormal;
            BookPagePreviewPanel.this.repaint();
        }
    }
}

