/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.bookpanels;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.BookEditorPane;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class BookEditorPaneEditor
extends BookEditorPane {
    private static final long serialVersionUID = 1L;
    protected BookPage currentBookPage;
    protected boolean export = false;

    public void setExport(boolean bl) {
        this.export = bl;
    }

    public BookEditorPaneEditor(BookPage bookPage) {
        this.currentBookPage = bookPage;
    }

    private void exportImage(Image image) {
        String string = AssetsController.TempFileGenerator.generateTempFileOverwriteExisting(this.currentBookPage.getImageName(), "png");
        File file = new File(string);
        try {
            BufferedImage bufferedImage = new BufferedImage(800, 600, 2);
            bufferedImage.getGraphics().drawImage(image, this.currentBookPage.getMargin(), this.currentBookPage.getMarginTop(), null);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        AssetsController.addSingleAsset(2, string, false);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.export && n == 16 && this.currentBookPage.getType() == 1) {
            this.exportImage(image);
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public void paint(Graphics graphics) {
    }
}

