/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.bookpanels;

import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.book.ArrowsPositionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPreviewPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class BookArrowPositionPreviewPanel
extends BookPreviewPanel {
    private static final long serialVersionUID = 1L;
    private boolean selectedPrevious = false;
    private boolean selectedNext = false;
    private ArrowsPositionPanel aPanel;
    private MouseArrowsListener mouseListener = new MouseArrowsListener(this);

    public BookArrowPositionPreviewPanel(BookDataControl bookDataControl) {
        super(bookDataControl);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    public void setArrowsPositionPanel(ArrowsPositionPanel arrowsPositionPanel) {
        this.aPanel = arrowsPositionPanel;
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintArrows(graphics);
        graphics.setColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
        if (this.arrowLeftNormal != null) {
            graphics.drawRect(this.getAbsoluteX(this.previousPagePoint.x), this.getAbsoluteY(this.previousPagePoint.y), this.getAbsoluteWidth(this.arrowLeftNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowLeftNormal.getHeight(null)));
        }
        if (this.arrowRightNormal != null) {
            graphics.drawRect(this.getAbsoluteX(this.nextPagePoint.x), this.getAbsoluteY(this.nextPagePoint.y), this.getAbsoluteWidth(this.arrowRightNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowRightNormal.getHeight(null)));
        }
        graphics.setColor(new Color(0.0f, 1.0f, 0.0f, 0.5f));
        if (this.selectedPrevious) {
            graphics.fillRect(this.getAbsoluteX(this.previousPagePoint.x), this.getAbsoluteY(this.previousPagePoint.y), this.getAbsoluteWidth(this.arrowLeftNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowLeftNormal.getHeight(null)));
        } else if (this.selectedNext) {
            graphics.fillRect(this.getAbsoluteX(this.nextPagePoint.x), this.getAbsoluteY(this.nextPagePoint.y), this.getAbsoluteWidth(this.arrowRightNormal.getWidth(null)), this.getAbsoluteHeight(this.arrowRightNormal.getHeight(null)));
        }
    }

    public void setPreviousPagePosition(int n, int n2) {
        this.previousPagePoint.x = n < 0 ? 0 : (n > this.image.getWidth(null) - this.arrowLeftNormal.getWidth(null) ? this.image.getWidth(null) - this.arrowLeftNormal.getWidth(null) : n);
        this.previousPagePoint.y = n2 < 0 ? 0 : (n2 > this.image.getHeight(null) - this.arrowLeftNormal.getHeight(null) ? this.image.getHeight(null) - this.arrowLeftNormal.getHeight(null) : n2);
    }

    public void setNextPagePosition(int n, int n2) {
        this.nextPagePoint.x = n < 0 ? 0 : (n > this.image.getWidth(null) - this.arrowRightNormal.getWidth(null) ? this.image.getWidth(null) - this.arrowRightNormal.getWidth(null) : n);
        this.nextPagePoint.y = n2 < 0 ? 0 : (n2 > this.image.getHeight(null) - this.arrowRightNormal.getHeight(null) ? this.image.getHeight(null) - this.arrowRightNormal.getHeight(null) : n2);
    }

    private class MouseArrowsListener
    extends MouseAdapter {
        private BookArrowPositionPreviewPanel bookPreview;
        private Point oldNextPoint;
        private Point oldPreviousPoint;
        int marginX;
        int marginY;

        public MouseArrowsListener(BookArrowPositionPreviewPanel bookArrowPositionPreviewPanel2) {
            this.bookPreview = bookArrowPositionPreviewPanel2;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (BookArrowPositionPreviewPanel.this.isInPreviousPage(n2, n = mouseEvent.getY())) {
                BookArrowPositionPreviewPanel.this.selectedPrevious = true;
                BookArrowPositionPreviewPanel.this.selectedNext = false;
                this.marginX = BookArrowPositionPreviewPanel.this.getRelativeX(n2) - BookArrowPositionPreviewPanel.this.previousPagePoint.x;
                this.marginY = BookArrowPositionPreviewPanel.this.getRelativeY(n) - BookArrowPositionPreviewPanel.this.previousPagePoint.y;
            } else if (BookArrowPositionPreviewPanel.this.isInNextPage(n2, n)) {
                BookArrowPositionPreviewPanel.this.selectedNext = true;
                BookArrowPositionPreviewPanel.this.selectedPrevious = false;
                this.marginX = BookArrowPositionPreviewPanel.this.getRelativeX(n2) - BookArrowPositionPreviewPanel.this.nextPagePoint.x;
                this.marginY = BookArrowPositionPreviewPanel.this.getRelativeY(n) - BookArrowPositionPreviewPanel.this.nextPagePoint.y;
            } else {
                BookArrowPositionPreviewPanel.this.selectedPrevious = false;
                BookArrowPositionPreviewPanel.this.selectedNext = false;
            }
            if (BookArrowPositionPreviewPanel.this.selectedPrevious || BookArrowPositionPreviewPanel.this.selectedNext) {
                this.oldNextPoint = (Point)BookArrowPositionPreviewPanel.this.nextPagePoint.clone();
                this.oldPreviousPoint = (Point)BookArrowPositionPreviewPanel.this.previousPagePoint.clone();
                this.bookPreview.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (BookArrowPositionPreviewPanel.this.selectedPrevious) {
                this.bookPreview.setPreviousPagePosition(BookArrowPositionPreviewPanel.this.getRelativeX(mouseEvent.getX()) - this.marginX, BookArrowPositionPreviewPanel.this.getRelativeY(mouseEvent.getY()) - this.marginY);
            } else if (BookArrowPositionPreviewPanel.this.selectedNext) {
                this.bookPreview.setNextPagePosition(BookArrowPositionPreviewPanel.this.getRelativeX(mouseEvent.getX()) - this.marginX, BookArrowPositionPreviewPanel.this.getRelativeY(mouseEvent.getY()) - this.marginY);
            }
            this.bookPreview.repaint();
            BookArrowPositionPreviewPanel.this.aPanel.updateSpinners(false);
            BookArrowPositionPreviewPanel.this.aPanel.setAddTool(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BookArrowPositionPreviewPanel.this.selectedPrevious || BookArrowPositionPreviewPanel.this.selectedNext) {
                if (BookArrowPositionPreviewPanel.this.selectedPrevious) {
                    this.bookPreview.setPreviousPagePosition(BookArrowPositionPreviewPanel.this.previousPagePoint, this.oldPreviousPoint);
                }
                if (BookArrowPositionPreviewPanel.this.selectedNext) {
                    this.bookPreview.setNextPagePosition(BookArrowPositionPreviewPanel.this.nextPagePoint, this.oldNextPoint);
                }
                BookArrowPositionPreviewPanel.this.selectedPrevious = false;
                BookArrowPositionPreviewPanel.this.selectedNext = false;
                this.bookPreview.repaint();
                this.bookPreview.dispatchEvent(new ActionEvent(this.bookPreview, 1001, "mouseReleased"));
                BookArrowPositionPreviewPanel.this.aPanel.updateSpinners(false);
                BookArrowPositionPreviewPanel.this.aPanel.setAddTool(true);
            }
        }
    }
}

