/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.MissingResourceException;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VideoPanel
extends JPanel
implements ControllerListener {
    private static final long serialVersionUID = 3265909297116717581L;
    private boolean realized = false;
    private boolean stoped = false;
    private boolean error = false;
    private Player player;
    private boolean prefetched = false;

    public VideoPanel(String string) {
        this();
        this.loadVideo(string);
    }

    public VideoPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)new JLabel("Video not available"), gridBagConstraints);
    }

    public synchronized void blockingRealize() {
        this.player.realize();
        while (!this.realized) {
            try {
                this.wait();
                if (!this.error) continue;
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.VideoGeneralError"), TC.get((String)"Error.BadAudioFormat.Message"));
                break;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interrupted while waiting on realize...exiting.");
                System.exit(1);
            }
        }
    }

    public synchronized void blockingStop() {
        this.player.stop();
        while (!this.stoped) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interrupted while waiting on realize...exiting.");
                System.exit(1);
            }
        }
    }

    public synchronized void blockingPrefetch() {
        this.player.prefetch();
        while (!this.prefetched) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interrupted while waiting on realize...exiting.");
                System.exit(1);
            }
        }
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            this.realized = true;
            this.notify();
        } else if (!(controllerEvent instanceof EndOfMediaEvent)) {
            if (controllerEvent instanceof StopEvent) {
                this.stoped = true;
                this.notify();
            } else if (controllerEvent instanceof PrefetchCompleteEvent) {
                this.prefetched = true;
                this.notify();
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                this.error = true;
                this.notify();
            }
        }
    }

    public void loadVideo(String string) {
        try {
            this.prefetched = false;
            this.stoped = false;
            this.realized = false;
            if (this.player != null) {
                this.blockingStop();
            }
            this.removeAll();
            this.player = Manager.createPlayer((MediaLocator)AssetsController.getVideo(string));
            if (this.player != null) {
                this.player.addControllerListener((ControllerListener)this);
                this.blockingRealize();
                if (!this.error) {
                    this.blockingPrefetch();
                    this.setLayout(new BorderLayout());
                    Component component = this.player.getVisualComponent();
                    if (component != null) {
                        this.add(component, "Center");
                    } else {
                        Controller.getInstance().showErrorDialog(TC.get((String)"Error.NoVideoFormat"), TC.get((String)"Error.NoVideoFormat.Message"));
                    }
                    this.add(this.player.getControlPanelComponent(), "South");
                    this.updateUI();
                }
            } else {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.VideoGeneralError"), TC.get((String)"Error.BadAudioFormat.Message"));
            }
        }
        catch (NoPlayerException noPlayerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.NoVideoFormat"), TC.get((String)"Error.NoVideoFormat.Message"));
        }
        catch (MalformedURLException malformedURLException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.VideoGeneralError"), TC.get((String)"Error.VideoGeneralError.Message"));
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.VideoGeneralError"), TC.get((String)"Error.VideoGeneralError.Message"));
        }
        catch (MissingResourceException missingResourceException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.VideoGeneralError"), TC.get((String)"Error.BadAudioFormat.Message"));
        }
    }

    public void removeVideo() {
        if (this.player != null && !this.error) {
            this.blockingStop();
            this.removeAll();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            this.add((Component)new JLabel("Video not available"), gridBagConstraints);
            this.updateUI();
            this.player = null;
        }
    }

    public void stopVideo() {
        if (this.player != null) {
            this.blockingStop();
        }
    }

    public boolean isError() {
        return this.error;
    }
}

