/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.TrajectoryScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class TrajectoryEditionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ScenePreviewEditionPanel spep;
    protected TrajectoryScenePreviewEditionController tspec;
    private TrajectoryDataControl trajectoryDataControl;

    public TrajectoryEditionPanel(String string, TrajectoryDataControl trajectoryDataControl) {
        this.setLayout(new BorderLayout());
        this.trajectoryDataControl = trajectoryDataControl;
        this.spep = new ScenePreviewEditionPanel(false, string);
        this.tspec = new TrajectoryScenePreviewEditionController(this.spep, trajectoryDataControl);
        this.spep.changeController(this.tspec);
        for (NodeDataControl nodeDataControl : trajectoryDataControl.getNodes()) {
            this.spep.addNode(nodeDataControl);
        }
        this.spep.setMovableCategory(8, true);
        this.spep.setTrajectory((Trajectory)trajectoryDataControl.getContent());
        this.add((Component)this.createButtonPanel(), "North");
        this.add((Component)this.spep, "Center");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel.add(this.createToolButton("BarriersList.EditNodes", 0, "img/icons/nodeEdit.png", buttonGroup));
        jPanel.add(this.createToolButton("BarriersList.EditSides", 1, "img/icons/sideEdit.png", buttonGroup));
        jPanel.add(this.createToolButton("BarriersList.SelectInitialNode", 4, "img/icons/selectStartNode.png", buttonGroup));
        jPanel.add(this.createToolButton("BarriersList.DeleteTool", 2, "img/icons/deleteTool.png", buttonGroup));
        return jPanel;
    }

    private AbstractButton createToolButton(String string, final int n, String string2, ButtonGroup buttonGroup) {
        ImageIcon imageIcon = new ImageIcon(string2);
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        buttonGroup.add(jToggleButton);
        jToggleButton.setToolTipText(TC.get((String)string));
        jToggleButton.setFocusable(false);
        if (n == 0) {
            jToggleButton.setSelected(true);
        }
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrajectoryEditionPanel.this.tspec.setSelectedTool(n);
            }
        });
        return jToggleButton;
    }

    public ScenePreviewEditionPanel getScenePreviewEditionPanel() {
        return this.spep;
    }

    public void update() {
        this.spep.removeElements(8);
        for (NodeDataControl nodeDataControl : this.trajectoryDataControl.getNodes()) {
            this.spep.addNode(nodeDataControl);
        }
        this.spep.setTrajectory((Trajectory)this.trajectoryDataControl.getContent());
    }
}

