/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.ScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.InfluenceAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.PointDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.DataControlSelectionListener;
import es.eucm.eadventure.editor.gui.otherpanels.DrawPanel;
import es.eucm.eadventure.editor.gui.otherpanels.ElementReferenceSelectionListener;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementActiveArea;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementBarrier;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementExit;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementInfluenceArea;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementNode;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementPlayer;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementPoint;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementReference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScenePreviewEditionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int CATEGORY_NONE = 0;
    public static final int CATEGORY_OBJECT = 1;
    public static final int CATEGORY_CHARACTER = 2;
    public static final int CATEGORY_ATREZZO = 3;
    public static final int CATEGORY_BARRIER = 4;
    public static final int CATEGORY_ACTIVEAREA = 5;
    public static final int CATEGORY_PLAYER = 6;
    public static final int CATEGORY_EXIT = 7;
    public static final int CATEGORY_NODE = 8;
    public static final int CATEGORY_POINT = 9;
    public static final int CATEGORY_INFLUENCEAREA = 10;
    private static final int LIGHT_BORDER = 1;
    private static final int HARD_BORDER = 2;
    private static final int RESCALE_BORDER = 3;
    private static final int RESCALE_BORDER_ACTIVE = 4;
    private static final int RESIZE_BORDER = 5;
    private static final int RESIZE_BORDER_ACTIVE = 6;
    private HashMap<Integer, List<ImageElement>> elements;
    private HashMap<Integer, Boolean> displayCategory;
    private HashMap<Integer, Boolean> movableCategory;
    private Trajectory trajectory;
    private Rectangle rectangle;
    private Color rectangleColor = Color.RED;
    private boolean rescale;
    private boolean resize;
    private ImageElement firstElement;
    private ElementReferenceSelectionListener elementReferenceSelectionListener;
    private DataControlSelectionListener dataControlSelectionListener;
    private ScenePreviewEditionController spec;
    private ImageElement selectedElement;
    private ImageElementInfluenceArea influenceArea;
    private boolean fixedSelectedElement;
    private DrawPanel drawPanel;
    private JPanel checkBoxPanel;
    private boolean showCheckBoxes = true;
    private JPanel preciseEditionPanel;
    private JSpinner posXSpinner;
    private JSpinner posYSpinner;
    private JSpinner scaleSpinner;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;
    private boolean showTextEdition = false;
    private boolean resizeInfluenceArea;
    private boolean showInfluenceArea = false;

    public ScenePreviewEditionPanel(boolean bl) {
        this.elements = new HashMap();
        this.displayCategory = new HashMap();
        this.movableCategory = new HashMap();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(10);
        borderLayout.setVgap(10);
        this.setLayout(borderLayout);
        this.drawPanel = new DrawPanel(bl);
        this.add((Component)this.drawPanel, "Center");
        this.recreateCheckBoxPanel();
        this.recreateTextEditionPanel();
        this.spec = new NormalScenePreviewEditionController(this);
        this.changeController(this.spec);
    }

    private void recreateTextEditionPanel() {
        if (this.preciseEditionPanel != null) {
            this.remove(this.preciseEditionPanel);
        }
        if (this.showTextEdition && this.selectedElement != null) {
            this.preciseEditionPanel = this.createTextEditionPanel();
            this.add((Component)this.preciseEditionPanel, "North");
            this.updateUI();
        }
    }

    private void recreateCheckBoxPanel() {
        if (this.checkBoxPanel != null) {
            this.remove(this.checkBoxPanel);
        }
        if (this.showCheckBoxes) {
            this.checkBoxPanel = this.createCheckBoxPanel();
            this.add((Component)this.checkBoxPanel, "South");
            this.updateUI();
        }
    }

    public ScenePreviewEditionPanel(boolean bl, String string) {
        this(bl);
        this.loadBackground(string);
    }

    public void addElement(int n, ElementReferenceDataControl elementReferenceDataControl) {
        Integer n2 = new Integer(n);
        this.addCategory(n, true, true);
        List<ImageElement> list = this.elements.get(n2);
        list.add(new ImageElementReference(elementReferenceDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addPlayer(SceneDataControl sceneDataControl, Image image) {
        this.addPlayer(sceneDataControl, image, true);
    }

    public void addPlayer(SceneDataControl sceneDataControl, Image image, boolean bl) {
        Integer n = new Integer(6);
        this.addCategory(n, true, bl);
        List<ImageElement> list = this.elements.get(n);
        list.add(new ImageElementPlayer(image, sceneDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addBarrier(BarrierDataControl barrierDataControl) {
        Integer n = new Integer(4);
        this.addCategory(n, true, false);
        List<ImageElement> list = this.elements.get(n);
        list.add(new ImageElementBarrier(barrierDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addActiveArea(ActiveAreaDataControl activeAreaDataControl) {
        Integer n = new Integer(5);
        this.addCategory(n, true, true);
        List<ImageElement> list = this.elements.get(n);
        list.add(new ImageElementActiveArea(activeAreaDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addExit(ExitDataControl exitDataControl) {
        Integer n = new Integer(7);
        this.addCategory(n, true, true);
        List<ImageElement> list = this.elements.get(n);
        list.add(new ImageElementExit(exitDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addNode(NodeDataControl nodeDataControl) {
        Integer n = new Integer(8);
        this.addCategory(n, true, false);
        List<ImageElement> list = this.elements.get(n);
        list.add(new ImageElementNode(nodeDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addPoint(PointDataControl pointDataControl) {
        Integer n = new Integer(9);
        this.addCategory(n, true, true);
        List<ImageElement> list = this.elements.get(n);
        list.add(new ImageElementPoint(pointDataControl));
        this.recreateCheckBoxPanel();
    }

    public void addInfluenceArea(InfluenceAreaDataControl influenceAreaDataControl) {
        if (this.showInfluenceArea) {
            Integer n = new Integer(10);
            this.addCategory(n, true, true);
            List<ImageElement> list = this.elements.get(n);
            list.clear();
            ImageElement imageElement = null;
            for (Integer n2 : this.elements.keySet()) {
                for (ImageElement imageElement2 : this.elements.get(n2)) {
                    if (imageElement2.getDataControl() == null || imageElement2.getDataControl() != influenceAreaDataControl.getDataControl()) continue;
                    imageElement = imageElement2;
                }
            }
            if (imageElement == null) {
                imageElement = this.selectedElement;
            }
            this.influenceArea = new ImageElementInfluenceArea(influenceAreaDataControl, imageElement);
            list.add(this.influenceArea);
        }
    }

    public void addInfluenceArea(ImageElementInfluenceArea imageElementInfluenceArea) {
        Integer n = new Integer(10);
        this.addCategory(n, true, true);
        List<ImageElement> list = this.elements.get(n);
        list.clear();
        this.influenceArea = imageElementInfluenceArea;
        list.add(this.influenceArea);
    }

    private void addCategory(Integer n, boolean bl, boolean bl2) {
        if (!this.elements.containsKey(n)) {
            this.elements.put(n, new ArrayList());
        }
        if (!this.displayCategory.containsKey(n)) {
            this.displayCategory.put(n, new Boolean(bl));
        }
        if (!this.movableCategory.containsKey(n)) {
            this.movableCategory.put(n, new Boolean(bl2));
        }
    }

    public void setTrajectory(Trajectory trajectory) {
        this.trajectory = trajectory;
    }

    public void setIrregularRectangle(Rectangle rectangle, Color color) {
        this.rectangle = rectangle;
        this.rectangleColor = color;
    }

    public void removeElement(int n, ElementReferenceDataControl elementReferenceDataControl) {
        Integer n2 = new Integer(n);
        List<ImageElement> list = this.elements.get(n2);
        if (list != null) {
            int n3;
            for (n3 = 0; n3 < list.size() && !list.get(n3).getDataControl().equals(elementReferenceDataControl); ++n3) {
            }
            if (n3 >= 0 && n3 < list.size()) {
                if (this.selectedElement == list.get(n3)) {
                    this.selectedElement = null;
                    this.removeElements(10);
                    this.influenceArea = null;
                }
                list.remove(n3);
            }
        }
        this.repaint();
    }

    public void removeElements(int n) {
        Integer n2 = new Integer(n);
        List<ImageElement> list = this.elements.get(n2);
        if (list != null) {
            list.clear();
            this.repaint();
        }
    }

    public void setDisplayCategory(int n, boolean bl) {
        Integer n2 = new Integer(n);
        this.displayCategory.put(n2, new Boolean(bl));
        if (!this.elements.containsKey(n2)) {
            this.elements.put(n2, new ArrayList());
        }
        this.repaint();
    }

    public void setMovableCategory(int n, boolean bl) {
        Integer n2 = new Integer(n);
        this.movableCategory.put(n2, new Boolean(bl));
        if (!this.elements.containsKey(n2)) {
            this.elements.put(n2, new ArrayList());
        }
    }

    public void setMovableElement(ElementReferenceDataControl elementReferenceDataControl) {
        this.selectedElement = new ImageElementReference(elementReferenceDataControl);
        for (Integer n : this.movableCategory.keySet()) {
            this.movableCategory.put(n, new Boolean(false));
        }
        this.recreateTextEditionPanel();
    }

    public void setBackground(Image image) {
        this.drawPanel.setBackgroundImg(image);
        this.repaint();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintBackBuffer();
        super.paint(graphics);
        if (this.drawPanel != null) {
            this.drawPanel.repaint();
        }
    }

    private void paintBackBuffer() {
        Graphics graphics = this.drawPanel.getGraphics();
        this.drawPanel.paintBackground();
        if (this.influenceArea != null) {
            this.influenceArea.recreateImage();
        }
        ArrayList<ImageElement> arrayList = new ArrayList<ImageElement>();
        for (Integer comparable : this.displayCategory.keySet()) {
            if (!this.displayCategory.get(comparable).booleanValue()) continue;
            for (ImageElement imageElement : this.elements.get(comparable)) {
                arrayList.add(imageElement);
            }
        }
        Collections.sort(arrayList);
        for (ImageElement imageElement : arrayList) {
            if (!imageElement.isVisible()) continue;
            this.drawPanel.paintRelativeImage(imageElement.getImage(), imageElement.getX(), imageElement.getY(), imageElement.getScale(), 1.0f);
        }
        if (this.spec.getUnderMouse() != null) {
            this.paintBorders(graphics, this.spec.getUnderMouse(), 1);
        }
        if (this.selectedElement != null) {
            this.paintBorders(graphics, this.selectedElement, 2);
            if (this.selectedElement.canRescale()) {
                if (this.rescale) {
                    this.paintBorders(graphics, this.selectedElement, 4);
                } else {
                    this.paintBorders(graphics, this.selectedElement, 3);
                }
            }
            if (this.selectedElement.canResize()) {
                if (this.resize) {
                    this.paintBorders(graphics, this.selectedElement, 6);
                } else {
                    this.paintBorders(graphics, this.selectedElement, 5);
                }
            }
        }
        if (this.influenceArea != null) {
            if (this.resizeInfluenceArea) {
                this.paintBorders(graphics, this.influenceArea, 6);
            } else {
                this.paintBorders(graphics, this.influenceArea, 5);
            }
        }
        this.paintTrajectory(graphics);
        this.paintIrregularRectangle(graphics);
    }

    private void paintBorders(Graphics graphics, ImageElement imageElement, int n) {
        int n2 = (int)((float)imageElement.getX() - (float)imageElement.getImage().getWidth(null) * imageElement.getScale() / 2.0f);
        n2 = this.drawPanel.getRelativeX(n2);
        int n3 = (int)((float)imageElement.getY() - (float)imageElement.getImage().getHeight(null) * imageElement.getScale());
        n3 = this.drawPanel.getRelativeY(n3);
        int n4 = this.drawPanel.getRelativeWidth((int)((float)imageElement.getImage().getWidth(null) * imageElement.getScale()));
        int n5 = this.drawPanel.getRelativeHeight((int)((float)imageElement.getImage().getHeight(null) * imageElement.getScale()));
        if (n == 1) {
            Color color = graphics.getColor();
            graphics.setColor(Color.RED);
            graphics.drawRect(n2, n3, n4, n5);
            graphics.setColor(color);
            this.drawPanel.paintRelativeImage(imageElement.getImage(), imageElement.getX(), imageElement.getY(), imageElement.getScale(), 0.5f);
        } else if (n == 2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.RED);
            graphics.fillRect(n2 - 4, n3 - 4, n4 + 8, 4);
            graphics.fillRect(n2 - 4, n3 - 4, 4, n5 + 4);
            graphics.fillRect(n2 + n4, n3, 4, n5 + 4);
            graphics.fillRect(n2 - 4, n3 + n5, n4 + 4, 4);
            graphics.setColor(color);
            this.drawPanel.paintRelativeImage(imageElement.getImage(), imageElement.getX(), imageElement.getY(), imageElement.getScale(), 0.5f);
        } else if (n == 3) {
            Color color = graphics.getColor();
            graphics.setColor(Color.GREEN);
            graphics.drawRect(n2 + n4 - 8, n3 - 8, 16, 16);
            graphics.setColor(color);
        } else if (n == 4) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLUE);
            graphics.drawRect(n2 + n4 - 8, n3 - 8, 16, 16);
            graphics.drawRect(n2 + n4 - 7, n3 - 7, 14, 14);
            graphics.setColor(color);
        } else if (n == 5) {
            Color color = graphics.getColor();
            graphics.setColor(Color.GREEN);
            graphics.drawRect(n2 + n4 - 8, n3 + n5 - 8, 16, 16);
            graphics.setColor(color);
        } else if (n == 6) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLUE);
            graphics.drawRect(n2 + n4 - 8, n3 + n5 - 8, 16, 16);
            graphics.drawRect(n2 + n4 - 7, n3 + n5 - 7, 14, 14);
            graphics.setColor(color);
        }
    }

    public void loadBackground(String string) {
        if (string != null && string.length() > 0) {
            this.drawPanel.setBackgroundImg(AssetsController.getImage(string));
        } else {
            this.drawPanel.setBackgroundImg(null);
        }
        this.repaint();
    }

    private void paintTrajectory(Graphics graphics) {
        Integer n = new Integer(8);
        if (this.trajectory == null || this.displayCategory.get(n) == null || !this.displayCategory.get(n).booleanValue()) {
            return;
        }
        for (Trajectory.Side side : this.trajectory.getSides()) {
            Trajectory.Node node = this.trajectory.getNodeForId(side.getIDStart());
            Trajectory.Node node2 = this.trajectory.getNodeForId(side.getIDEnd());
            this.drawPanel.drawRelativeLineWithBorder(node.getX(), node.getY(), node2.getX(), node2.getY());
            int n2 = node.getX() + (node2.getX() - node.getX()) / 2;
            int n3 = node.getY() + (node2.getY() - node.getY()) / 2;
            this.drawPanel.drawRelativeString("" + (int)side.getLength(), n2, n3);
        }
        if (this.firstElement != null) {
            int n4 = (int)this.getMousePosition().getX();
            int n5 = (int)this.getMousePosition().getY();
            int n6 = this.drawPanel.getRealX(n4);
            int n7 = this.drawPanel.getRealY(n5);
            this.drawPanel.drawRelativeLine(this.firstElement.getX(), this.firstElement.getY() - 10, n6, n7);
        }
    }

    private void paintIrregularRectangle(Graphics graphics) {
        Integer n = new Integer(9);
        if (this.rectangle == null || this.rectangle.isRectangular() || this.displayCategory.get(n) == null || !this.displayCategory.get(n).booleanValue()) {
            return;
        }
        if (this.rectangle.getPoints().size() > 0) {
            int[] nArray = new int[this.rectangle.getPoints().size()];
            int[] nArray2 = new int[this.rectangle.getPoints().size()];
            for (int i = 0; i < this.rectangle.getPoints().size(); ++i) {
                nArray[i] = ((Point)this.rectangle.getPoints().get((int)i)).x;
                nArray2[i] = ((Point)this.rectangle.getPoints().get((int)i)).y;
            }
            this.drawPanel.fillRelativePoly(nArray, nArray2, this.rectangleColor, 0.4f);
        }
    }

    public void recreateElement(ElementReferenceDataControl elementReferenceDataControl) {
        for (Integer n : this.elements.keySet()) {
            for (ImageElement imageElement : this.elements.get(n)) {
                if (imageElement.getDataControl() == null || imageElement.getDataControl() != elementReferenceDataControl) continue;
                imageElement.recreateImage();
            }
        }
        if (this.selectedElement != null && this.selectedElement.getDataControl() != null && this.selectedElement.getDataControl() == elementReferenceDataControl) {
            this.selectedElement.recreateImage();
        }
    }

    public ImageElement getMovableElement(int n, int n2) {
        if (this.fixedSelectedElement) {
            double d = this.selectedElement.getScale();
            int n3 = (int)((double)this.selectedElement.getX() - (double)this.selectedElement.getImage().getWidth(null) * d / 2.0);
            int n4 = (int)((double)this.selectedElement.getY() - (double)this.selectedElement.getImage().getHeight(null) * d);
            int n5 = (int)((double)n3 + (double)this.selectedElement.getImage().getWidth(null) * d);
            int n6 = (int)((double)n4 + (double)this.selectedElement.getImage().getHeight(null) * d);
            if (n > n3 && n < n5 && n2 > n4 && n2 < n6 && !this.selectedElement.transparentPoint(n - n3, n2 - n4)) {
                return this.selectedElement;
            }
        }
        if (this.influenceArea != null && this.selectedElement != null && !this.isInside(this.selectedElement, n, n2, true) && this.isInside(this.influenceArea, n, n2, false)) {
            return this.influenceArea;
        }
        ImageElement imageElement = null;
        for (Integer n7 : this.movableCategory.keySet()) {
            if (!this.movableCategory.get(n7).booleanValue() || this.displayCategory.get(n7) == null || !this.displayCategory.get(n7).booleanValue()) continue;
            for (ImageElement imageElement2 : this.elements.get(n7)) {
                if (!this.isInside(imageElement2, n, n2, true)) continue;
                imageElement = imageElement2;
            }
        }
        return imageElement;
    }

    private boolean isInside(ImageElement imageElement, int n, int n2, boolean bl) {
        double d = imageElement.getScale();
        double d2 = imageElement.getWidth();
        double d3 = imageElement.getHeight();
        int n3 = (int)((double)imageElement.getX() - d2 * d / 2.0);
        int n4 = (int)((double)imageElement.getY() - d3 * d);
        int n5 = (int)((double)n3 + d2 * d);
        int n6 = (int)((double)n4 + d3 * d);
        return n > n3 && n < n5 && n2 > n4 && n2 < n6 && (!bl || !imageElement.transparentPoint(n - n3, n2 - n4));
    }

    public ImageElement getRescaleElement(int n, int n2) {
        if (this.selectedElement == null || !this.selectedElement.canRescale()) {
            return null;
        }
        int n3 = (int)((float)this.selectedElement.getX() + (float)this.selectedElement.getImage().getWidth(null) * this.selectedElement.getScale() / 2.0f);
        int n4 = (int)((float)this.selectedElement.getY() - (float)this.selectedElement.getImage().getHeight(null) * this.selectedElement.getScale());
        int n5 = this.drawPanel.getRealHeight(8);
        if (n > n3 - n5 && n < n3 + n5 && n2 > n4 - n5 && n2 < n4 + n5) {
            return this.selectedElement;
        }
        return null;
    }

    public ImageElement getResizeElement(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        ImageElement imageElement = this.selectedElement;
        if (!(imageElement != null && imageElement.canResize() || this.influenceArea != null)) {
            return null;
        }
        if (imageElement != null) {
            n6 = (int)((float)imageElement.getX() + (float)imageElement.getImage().getWidth(null) * imageElement.getScale() / 2.0f);
            n5 = (int)((float)imageElement.getY() - (float)imageElement.getImage().getHeight(null) * imageElement.getScale());
            n4 = (int)((float)imageElement.getImage().getHeight(null) * imageElement.getScale());
            n3 = this.drawPanel.getRealWidth(8);
            if (n > n6 - n3 && n < n6 + n3 && n2 > n5 + n4 - n3 && n2 < n5 + n4 + n3) {
                return imageElement;
            }
        }
        if (this.influenceArea != null && this.movableCategory.get(new Integer(10)).booleanValue()) {
            imageElement = this.influenceArea;
            n6 = (int)((float)imageElement.getX() + (float)imageElement.getImage().getWidth(null) * imageElement.getScale() / 2.0f);
            n5 = (int)((float)imageElement.getY() - (float)imageElement.getImage().getHeight(null) * imageElement.getScale());
            n4 = (int)((float)imageElement.getImage().getHeight(null) * imageElement.getScale());
            n3 = this.drawPanel.getRealWidth(8);
            if (n > n6 - n3 && n < n6 + n3 && n2 > n5 + n4 - n3 && n2 < n5 + n4 + n3) {
                return imageElement;
            }
        }
        return null;
    }

    private void resetInfluenceArea() {
        if (this.showInfluenceArea) {
            this.influenceArea = null;
            Integer n = new Integer(10);
            this.addCategory(n, true, true);
            List<ImageElement> list = this.elements.get(n);
            list.clear();
            if (this.selectedElement != null && this.selectedElement.getDataControl() instanceof ElementReferenceDataControl && ((ElementReferenceDataControl)this.selectedElement.getDataControl()).getInfluenceArea() != null) {
                this.addInfluenceArea(((ElementReferenceDataControl)this.selectedElement.getDataControl()).getInfluenceArea());
            }
            if (this.selectedElement != null && this.selectedElement.getDataControl() instanceof ActiveAreaDataControl && ((ActiveAreaDataControl)this.selectedElement.getDataControl()).getInfluenceArea() != null) {
                this.addInfluenceArea(((ActiveAreaDataControl)this.selectedElement.getDataControl()).getInfluenceArea());
            }
        }
    }

    public void setSelectedElement(ElementReferenceDataControl elementReferenceDataControl) {
        this.selectedElement = new ImageElementReference(elementReferenceDataControl);
        this.recreateTextEditionPanel();
        this.resetInfluenceArea();
    }

    public void setSelectedElement(DataControl dataControl, Image image, SceneDataControl sceneDataControl) {
        if (dataControl != null) {
            if (!(dataControl instanceof InfluenceAreaDataControl)) {
                this.selectedElement = new ImageElementReference((ElementReferenceDataControl)dataControl);
            }
        } else {
            this.selectedElement = new ImageElementPlayer(image, sceneDataControl);
        }
        this.recreateTextEditionPanel();
        this.resetInfluenceArea();
    }

    public void setSelectedElement(ImageElement imageElement) {
        if (imageElement != null && (imageElement instanceof ImageElementInfluenceArea || imageElement instanceof ImageElementPoint)) {
            return;
        }
        boolean bl = false;
        for (Integer n : this.elements.keySet()) {
            for (ImageElement imageElement2 : this.elements.get(n)) {
                imageElement2.recreateImage();
                if (imageElement2.getDataControl() == null || imageElement == null || imageElement2.getDataControl() != imageElement.getDataControl()) continue;
                bl = true;
                this.selectedElement = imageElement2;
            }
        }
        if (!bl) {
            this.selectedElement = imageElement;
        }
        if (this.elementReferenceSelectionListener != null) {
            if (this.selectedElement != null) {
                this.elementReferenceSelectionListener.elementReferenceSelected(this.selectedElement.getLayer());
            } else {
                this.elementReferenceSelectionListener.elementReferenceSelected(-1);
            }
        }
        this.recreateTextEditionPanel();
        this.resetInfluenceArea();
    }

    public void setSelectedElement(ActiveAreaDataControl activeAreaDataControl) {
        this.setSelectedElement(new ImageElementActiveArea(activeAreaDataControl));
    }

    public void setSelectedElement(ExitDataControl exitDataControl) {
        this.setSelectedElement(new ImageElementExit(exitDataControl));
    }

    public void setSelectedElement(BarrierDataControl barrierDataControl) {
        this.setSelectedElement(new ImageElementBarrier(barrierDataControl));
    }

    public void setElementReferenceSelectionListener(ElementReferenceSelectionListener elementReferenceSelectionListener) {
        this.elementReferenceSelectionListener = elementReferenceSelectionListener;
    }

    public void recreateElements(int n) {
        Integer n2 = new Integer(n);
        for (ImageElement imageElement : this.elements.get(n2)) {
            imageElement.recreateImage();
        }
    }

    public ImageElement getSelectedElement() {
        return this.selectedElement;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public void setRescale(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(7));
        } else if (!this.resize && !this.resizeInfluenceArea) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.rescale = bl;
    }

    public void changeController(ScenePreviewEditionController scenePreviewEditionController) {
        if (this.spec != null) {
            this.drawPanel.removeMouseListener(this.spec);
            this.drawPanel.removeMouseMotionListener(this.spec);
        }
        this.spec = scenePreviewEditionController;
        this.drawPanel.addMouseListener(scenePreviewEditionController);
        this.drawPanel.addMouseMotionListener(scenePreviewEditionController);
    }

    public void removeElement(int n, ImageElement imageElement) {
        Integer n2 = new Integer(n);
        List<ImageElement> list = this.elements.get(n2);
        list.remove(imageElement);
    }

    public void setFirstElement(ImageElement imageElement) {
        this.firstElement = imageElement;
    }

    public ImageElement getFirstElement() {
        return this.firstElement;
    }

    public boolean isResize() {
        return this.resize;
    }

    public boolean isResizeInflueceArea() {
        return this.resizeInfluenceArea;
    }

    public void setResize(boolean bl) {
        if (bl || this.resizeInfluenceArea) {
            this.setCursor(Cursor.getPredefinedCursor(5));
        } else if (!this.rescale) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.resize = bl;
    }

    public void setResizeInflueceArea(boolean bl) {
        if (this.resize || bl) {
            this.setCursor(Cursor.getPredefinedCursor(5));
        } else if (!this.rescale) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.resizeInfluenceArea = bl;
    }

    public JPanel createCheckBoxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"SPEP.ShowPanelTitle")));
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        for (Integer object : this.displayCategory.keySet()) {
            JCheckBox jCheckBox = null;
            if (this.elements.get(object).size() > 0) {
                jCheckBox = this.createCheckBox(object);
            }
            if (jCheckBox == null) continue;
            arrayList.add(jCheckBox);
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.setAutoscrolls(true);
        for (JCheckBox jCheckBox : arrayList) {
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            gridBagConstraints.gridx += gridBagConstraints.gridy;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridy %= 2;
        }
        return jPanel;
    }

    private JCheckBox createCheckBox(final Integer n) {
        String string = null;
        if (n == 5) {
            string = TC.get((String)"SPEP.ShowActiveAreas");
        } else if (n == 3) {
            string = TC.get((String)"SPEP.ShowAtrezzo");
        } else if (n == 4) {
            string = TC.get((String)"SPEP.ShowBarriers");
        } else if (n == 2) {
            string = TC.get((String)"SPEP.ShowCharacterReferences");
        } else if (n == 7) {
            string = TC.get((String)"SPEP.ShowExits");
        } else if (n == 0) {
            string = TC.get((String)"SPEP.ShowUncategorized");
        } else if (n == 1) {
            string = TC.get((String)"SPEP.ShowObjectReferences");
        } else if (n == 6) {
            string = TC.get((String)"SPEP.ShowPlayer");
        } else if (n == 8) {
            string = TC.get((String)"SPEP.ShowTrajectory");
        }
        if (string == null) {
            return null;
        }
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setSelected(this.displayCategory.get(n));
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ((JCheckBox)changeEvent.getSource()).isSelected();
                ScenePreviewEditionPanel.this.displayCategory.put(n, new Boolean(bl));
                ScenePreviewEditionPanel.this.repaint();
            }
        });
        return jCheckBox;
    }

    public void updateTextEditionPanel() {
        if (this.preciseEditionPanel != null && this.selectedElement != null) {
            if (this.posXSpinner != null) {
                this.posXSpinner.setValue(this.selectedElement.getX());
            }
            if (this.posYSpinner != null) {
                this.posYSpinner.setValue(this.selectedElement.getY());
            }
            if (this.scaleSpinner != null) {
                this.scaleSpinner.setValue(Float.valueOf(this.selectedElement.getScale()));
            }
            if (this.widthSpinner != null) {
                this.widthSpinner.setValue(this.selectedElement.getWidth());
            }
            if (this.heightSpinner != null) {
                this.heightSpinner.setValue(this.selectedElement.getHeight());
            }
        }
    }

    public JPanel createTextEditionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(TC.get((String)"SPEP.XCoordinate")), gridBagConstraints);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.selectedElement.getX(), -400, this.drawPanel.getBackgroundWidth() + 400, 5);
        this.posXSpinner = new JSpinner(spinnerNumberModel);
        this.posXSpinner.setPreferredSize(new Dimension(60, this.posXSpinner.getPreferredSize().height));
        this.posXSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ScenePreviewEditionPanel.this.selectedElement != null) {
                    int n = ScenePreviewEditionPanel.this.selectedElement.getY();
                    ScenePreviewEditionPanel.this.selectedElement.changePosition((Integer)ScenePreviewEditionPanel.this.posXSpinner.getValue(), n);
                    ScenePreviewEditionPanel.this.repaint();
                }
            }
        });
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.posXSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(TC.get((String)"SPEP.YCoordinate")), gridBagConstraints);
        spinnerNumberModel = new SpinnerNumberModel(this.selectedElement.getY(), -400, 1000, 5);
        this.posYSpinner = new JSpinner(spinnerNumberModel);
        this.posYSpinner.setPreferredSize(new Dimension(60, this.posYSpinner.getPreferredSize().height));
        this.posYSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ScenePreviewEditionPanel.this.selectedElement != null) {
                    int n = ScenePreviewEditionPanel.this.selectedElement.getX();
                    ScenePreviewEditionPanel.this.selectedElement.changePosition(n, (Integer)ScenePreviewEditionPanel.this.posYSpinner.getValue());
                    ScenePreviewEditionPanel.this.repaint();
                }
            }
        });
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.posYSpinner, gridBagConstraints);
        if (this.selectedElement.canRescale()) {
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            jPanel.add((Component)new JLabel(TC.get((String)"SPEP.Scale")), gridBagConstraints);
            spinnerNumberModel = new SpinnerNumberModel(new Float(this.selectedElement.getScale()), new Float(0.02f), new Float(15.0f), new Float(0.02f));
            this.scaleSpinner = new JSpinner(spinnerNumberModel);
            this.scaleSpinner.setPreferredSize(new Dimension(60, this.scaleSpinner.getPreferredSize().height));
            this.scaleSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (ScenePreviewEditionPanel.this.selectedElement != null) {
                        ScenePreviewEditionPanel.this.selectedElement.setScale(((Float)ScenePreviewEditionPanel.this.scaleSpinner.getValue()).floatValue());
                        ScenePreviewEditionPanel.this.repaint();
                    }
                }
            });
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ++gridBagConstraints.gridx;
            jPanel.add((Component)this.scaleSpinner, gridBagConstraints);
        } else {
            this.scaleSpinner = null;
        }
        if (this.selectedElement.canResize()) {
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            jPanel.add((Component)new JLabel(TC.get((String)"SPEP.Width")), gridBagConstraints);
            spinnerNumberModel = new SpinnerNumberModel(this.selectedElement.getWidth(), 1, 1000, 5);
            this.widthSpinner = new JSpinner(spinnerNumberModel);
            this.widthSpinner.setPreferredSize(new Dimension(60, this.widthSpinner.getPreferredSize().height));
            this.widthSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = ScenePreviewEditionPanel.this.selectedElement.getHeight();
                    ScenePreviewEditionPanel.this.selectedElement.changeSize((Integer)ScenePreviewEditionPanel.this.widthSpinner.getValue(), n);
                    ScenePreviewEditionPanel.this.selectedElement.recreateImage();
                    ScenePreviewEditionPanel.this.repaint();
                }
            });
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)this.widthSpinner, gridBagConstraints);
            --gridBagConstraints.gridx;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            jPanel.add((Component)new JLabel(TC.get((String)"SPEP.Height")), gridBagConstraints);
            spinnerNumberModel = new SpinnerNumberModel(this.selectedElement.getHeight(), 1, 800, 5);
            this.heightSpinner = new JSpinner(spinnerNumberModel);
            this.heightSpinner.setPreferredSize(new Dimension(60, this.heightSpinner.getPreferredSize().height));
            this.heightSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = ScenePreviewEditionPanel.this.selectedElement.getWidth();
                    ScenePreviewEditionPanel.this.selectedElement.changeSize(n, (Integer)ScenePreviewEditionPanel.this.heightSpinner.getValue());
                    ScenePreviewEditionPanel.this.selectedElement.recreateImage();
                    ScenePreviewEditionPanel.this.repaint();
                }
            });
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)this.heightSpinner, gridBagConstraints);
        } else {
            this.widthSpinner = null;
            this.heightSpinner = null;
        }
        return jPanel;
    }

    public void setFixedSelectedElement(boolean bl) {
        this.fixedSelectedElement = bl;
    }

    public boolean getFixedSelectedElement() {
        return this.fixedSelectedElement;
    }

    public ImageElement getInfluenceArea() {
        return this.influenceArea;
    }

    public void setShowCheckBoxes(boolean bl) {
        this.showCheckBoxes = bl;
        this.recreateCheckBoxPanel();
    }

    public void setShowTextEdition(boolean bl) {
        this.showTextEdition = bl;
    }

    public int getRealWidth(int n) {
        return this.drawPanel.getRealWidth(n);
    }

    public int getRealHeight(int n) {
        return this.drawPanel.getRealHeight(n);
    }

    public int getRealX(int n) {
        return this.drawPanel.getRealX(n);
    }

    public int getRealY(int n) {
        return this.drawPanel.getRealY(n);
    }

    public int getRelativeX(int n) {
        return this.drawPanel.getRelativeX(n);
    }

    public int getRelativeY(int n) {
        return this.drawPanel.getRelativeY(n);
    }

    public void setShowInfluenceArea(boolean bl) {
        this.showInfluenceArea = bl;
    }

    public void removeElement(DataControl dataControl) {
        ImageElement imageElement = null;
        for (Integer n : this.elements.keySet()) {
            for (ImageElement imageElement2 : this.elements.get(n)) {
                if (imageElement2.getDataControl() == null || imageElement2.getDataControl() != dataControl) continue;
                imageElement = imageElement2;
            }
            if (imageElement == null) continue;
            this.elements.get(n).remove(imageElement);
            if (this.selectedElement == imageElement) {
                this.selectedElement = null;
                this.removeElements(10);
                this.influenceArea = null;
            }
            imageElement = null;
        }
    }

    public void setDataControlSelectionListener(DataControlSelectionListener dataControlSelectionListener) {
        this.dataControlSelectionListener = dataControlSelectionListener;
    }

    public void notifySelectionListener() {
        if (this.dataControlSelectionListener != null) {
            if (this.selectedElement == null) {
                this.dataControlSelectionListener.dataControlSelected(null);
            } else {
                this.dataControlSelectionListener.dataControlSelected(this.selectedElement.getDataControl());
            }
        }
    }

    public void addComponent(Component component, int n, int n2) {
        this.drawPanel.addComponent(component, n, n2);
    }

    public void removeComponent(Component component) {
        this.drawPanel.removeComponent(component);
    }
}

