/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.SceneLinksConfigData;
import es.eucm.eadventure.editor.control.controllers.SceneLinksController;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ScenesListDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.EditDataControlCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.InfoHeaderRenderer;
import es.eucm.eadventure.editor.gui.otherpanels.DrawPanel;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.ActiveAreaElement;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.ExitElement;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.ItemReferenceElement;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.SceneElement;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class SceneLinksPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DrawPanel drawPanel;
    private ScenesListDataControl sldc;
    private List<SceneElement> sceneElements;
    private float drawingScale = 0.8f;
    private JTable checkBoxes;
    private DefaultTableModel dtm;
    public static int DEFAULT_SCALE = 5;

    public SceneLinksPanel(ScenesListDataControl scenesListDataControl) {
        Cloneable cloneable2;
        this.sldc = scenesListDataControl;
        this.setLayout(new GridBagLayout());
        this.drawPanel = new DrawPanel(true);
        BufferedImage bufferedImage = new BufferedImage(800, 600, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new JPanel().getBackground());
        graphics2D.fillRect(0, 0, 800, 600);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, 799, 599);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillRect(0, 0, 800, 600);
        JScrollPane jScrollPane = this.createCheckBoxTable();
        boolean bl = true;
        for (SceneDataControl object2 : this.sldc.getScenes()) {
            if (SceneLinksConfigData.isSceneConfig(object2.getId())) continue;
            bl = false;
        }
        this.sceneElements = new ArrayList<SceneElement>();
        int n = 0;
        for (Cloneable cloneable2 : this.sldc.getScenes()) {
            SceneElement sceneElement = new SceneElement((SceneDataControl)cloneable2, n);
            ++n;
            if (bl) {
                sceneElement.setVisible(SceneLinksConfigData.getSceneVisible(sceneElement.getId()));
                sceneElement.changePosition(SceneLinksConfigData.getSceneX(sceneElement.getId()), SceneLinksConfigData.getSceneY(sceneElement.getId()));
            } else {
                SceneLinksConfigData.setSceneVisible(sceneElement.getId(), sceneElement.isVisible());
                SceneLinksConfigData.setSceneX(sceneElement.getId(), sceneElement.getPosX());
                SceneLinksConfigData.setSceneY(sceneElement.getId(), sceneElement.getPosY());
            }
            this.sceneElements.add(sceneElement);
            this.dtm.addRow(new Object[]{new Boolean(sceneElement.isVisible()), sceneElement.getId(), sceneElement.getDataControl()});
        }
        SceneLinksController sceneLinksController = new SceneLinksController(this);
        this.drawPanel.addMouseListener(sceneLinksController);
        this.drawPanel.addMouseMotionListener(sceneLinksController);
        cloneable2 = new GridBagConstraints();
        ((GridBagConstraints)cloneable2).gridx = 0;
        ((GridBagConstraints)cloneable2).gridy = 1;
        ((GridBagConstraints)cloneable2).fill = 1;
        ((GridBagConstraints)cloneable2).weightx = 2.0;
        ((GridBagConstraints)cloneable2).weighty = 2.0;
        this.drawPanel.setBackgroundImg(bufferedImage);
        this.add((Component)this.drawPanel, cloneable2);
        ((GridBagConstraints)cloneable2).gridy = 0;
        ((GridBagConstraints)cloneable2).weightx = 1.0;
        ((GridBagConstraints)cloneable2).weighty = 0.1;
        ((GridBagConstraints)cloneable2).fill = 2;
        jScrollPane.setMinimumSize(new Dimension(0, 150));
        jScrollPane.setPreferredSize(new Dimension(100, 150));
        this.add((Component)jScrollPane, cloneable2);
    }

    private JScrollPane createCheckBoxTable() {
        Object[] objectArray = new String[]{TC.get((String)"SceneLinksPanel.Show"), TC.get((String)"SceneLinksPanel.SceneID"), TC.get((String)"GeneralText.Edit")};
        Object[][] objectArray2 = null;
        this.dtm = new DefaultTableModel(objectArray2, objectArray){
            private static final long serialVersionUID = 1946349590475022293L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n == SceneLinksPanel.this.checkBoxes.getSelectedRow() && n2 != 1;
            }
        };
        this.checkBoxes = new JTable(this.dtm);
        TableColumn tableColumn = this.checkBoxes.getColumnModel().getColumn(0);
        tableColumn.setHeaderRenderer(new InfoHeaderRenderer("scenes/Scenes_Show.html"));
        tableColumn.setCellEditor(this.checkBoxes.getDefaultEditor(Boolean.class));
        tableColumn.setCellRenderer(this.checkBoxes.getDefaultRenderer(Boolean.class));
        tableColumn.setMaxWidth(90);
        tableColumn.setMinWidth(90);
        this.checkBoxes.getColumnModel().getColumn(1).setHeaderRenderer(new InfoHeaderRenderer());
        tableColumn = this.checkBoxes.getColumnModel().getColumn(2);
        tableColumn.setHeaderRenderer(new InfoHeaderRenderer("scenes/Scenes_Edit.html"));
        tableColumn.setCellEditor(new EditDataControlCellRendererEditor());
        tableColumn.setCellRenderer(new EditDataControlCellRendererEditor());
        tableColumn.setMaxWidth(100);
        this.dtm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    if (n2 == 0) {
                        ((SceneElement)SceneLinksPanel.this.sceneElements.get(n)).setVisible((Boolean)SceneLinksPanel.this.dtm.getValueAt(n, n2));
                        SceneLinksPanel.this.repaint();
                    }
                }
            }
        });
        return new JScrollPane(this.checkBoxes, 22, 31);
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintGraph();
        super.paint(graphics);
    }

    private void paintGraph() {
        this.drawPanel.paintBackground();
        int n = this.sceneElements.size();
        for (SceneElement object2 : this.sceneElements) {
            if (object2.isVisible()) continue;
            --n;
        }
        this.drawingScale = (float)((double)0.3f * (1.0 - Math.log(n) / Math.log(100.0)));
        ArrayList arrayList = new ArrayList();
        for (SceneElement sceneElement : this.sceneElements) {
            SceneElement sceneElement2;
            BasicStroke basicStroke;
            int n2;
            int n3;
            if (!sceneElement.isVisible()) continue;
            this.drawPanel.paintRelativeImageTop(sceneElement.getImage(), sceneElement.getPosX(), sceneElement.getPosY(), this.drawingScale * (float)DEFAULT_SCALE);
            if (sceneElement.isShowName()) {
                this.drawPanel.drawRelativeString(sceneElement.getId(), sceneElement.getPosX(), sceneElement.getPosY());
            }
            for (ExitElement exitElement : sceneElement.getExitElements()) {
                n3 = (int)((float)sceneElement.getPosX() + (float)exitElement.getPosX() * this.drawingScale);
                n2 = (int)((float)sceneElement.getPosY() + (float)exitElement.getPosY() * this.drawingScale);
                basicStroke = new BasicStroke();
                String string = exitElement.getNextSceneId();
                SceneElement sceneElement3 = this.getSceneElementForId(string);
                if (sceneElement3 == null || !sceneElement3.isVisible()) continue;
                this.addLine(n3, n2, sceneElement3, sceneElement.getColor(), basicStroke, arrayList);
            }
            for (ActiveAreaElement activeAreaElement : sceneElement.getActiveAreaElements()) {
                n3 = (int)((float)sceneElement.getPosX() + (float)activeAreaElement.getPosX() * this.drawingScale);
                n2 = (int)((float)sceneElement.getPosY() + (float)activeAreaElement.getPosY() * this.drawingScale);
                basicStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
                for (String string : activeAreaElement.getSceneIds()) {
                    sceneElement2 = this.getSceneElementForId(string);
                    if (sceneElement2 == null || !sceneElement2.isVisible()) continue;
                    this.addLine(n3, n2, sceneElement2, sceneElement.getColor(), basicStroke, arrayList);
                }
            }
            for (ItemReferenceElement itemReferenceElement : sceneElement.getItemReferenceElements()) {
                n3 = (int)((float)sceneElement.getPosX() + (float)itemReferenceElement.getPosX() * this.drawingScale);
                n2 = (int)((float)sceneElement.getPosY() + (float)itemReferenceElement.getPosY() * this.drawingScale);
                basicStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
                for (String string : itemReferenceElement.getSceneIds()) {
                    sceneElement2 = this.getSceneElementForId(string);
                    if (sceneElement2 == null || !sceneElement2.isVisible()) continue;
                    this.addLine(n3, n2, sceneElement2, sceneElement.getColor(), basicStroke, arrayList);
                }
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Line line = (Line)iterator.next();
            this.drawPanel.drawRelativeLine(line.x1, line.y1, line.x2, line.y2, line.color, line.stroke);
            this.drawPanel.drawRelativeArrowTip(line.x1, line.y1, line.x2, line.y2, line.color);
        }
    }

    private void addLine(int n, int n2, SceneElement sceneElement, Color color, Stroke stroke, List<Line> list) {
        double d = (float)sceneElement.getWidth() * this.drawingScale / 2.0f;
        double d2 = (float)sceneElement.getHeight() * this.drawingScale / 2.0f;
        int n3 = (int)((double)sceneElement.getPosX() + d);
        int n4 = (int)((double)sceneElement.getPosY() + d2);
        int n5 = n3;
        int n6 = n4;
        if (d2 == 0.0 || n4 == n2 || n4 - n2 != 0 && Math.abs(d / d2) <= (double)Math.abs((n3 - n) / (n4 - n2))) {
            if (n <= n3) {
                n5 = (int)((double)n3 - d);
                n6 = (int)((double)n4 - d / (double)(n3 - n) * (double)(n4 - n2));
            } else if (n > n3) {
                n5 = (int)((double)n3 + d);
                n6 = (int)((double)n4 + d / (double)(n3 - n) * (double)(n4 - n2));
            }
        } else if (n2 <= n4) {
            n6 = (int)((double)n4 - d2);
            n5 = (int)((double)n3 - d2 / (double)(n4 - n2) * (double)(n3 - n));
        } else if (n2 > n4) {
            n6 = (int)((double)n4 + d2);
            n5 = (int)((double)n3 + d2 / (double)(n4 - n2) * (double)(n3 - n));
        }
        list.add(new Line(n, n2, n5, n6, color, stroke));
    }

    public SceneElement getSceneElementForId(String string) {
        for (SceneElement sceneElement : this.sceneElements) {
            if (!sceneElement.getId().equals(string)) continue;
            return sceneElement;
        }
        return null;
    }

    public SceneElement getSceneElement(int n, int n2) {
        int n3 = this.drawPanel.getRealX(n);
        int n4 = this.drawPanel.getRealY(n2);
        for (int i = this.sceneElements.size() - 1; i >= 0; --i) {
            SceneElement sceneElement = this.sceneElements.get(i);
            if (!sceneElement.isVisible() || sceneElement.getPosX() >= n3 || !((float)sceneElement.getPosX() + (float)sceneElement.getWidth() * this.drawingScale * (float)DEFAULT_SCALE > (float)n3) || sceneElement.getPosY() >= n4 || !((float)sceneElement.getPosY() + (float)sceneElement.getHeight() * this.drawingScale * (float)DEFAULT_SCALE > (float)n4)) continue;
            this.checkBoxes.changeSelection(i, 0, false, false);
            return sceneElement;
        }
        return null;
    }

    public int getRealWidth(int n) {
        return this.drawPanel.getRealWidth(n);
    }

    public int getRealHeight(int n) {
        return this.drawPanel.getRealHeight(n);
    }

    private class Line {
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public Color color;
        public Stroke stroke;

        public Line(int n, int n2, int n3, int n4, Color color, Stroke stroke) {
            this.x1 = n;
            this.x2 = n3;
            this.y1 = n2;
            this.y2 = n4;
            this.color = color;
            this.stroke = stroke;
        }
    }
}

