/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.IrregularAreaEditionController;
import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.PointDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.RectangleArea;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class IrregularAreaEditionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ScenePreviewEditionPanel spep;
    protected IrregularAreaEditionController iaec;
    protected JPanel buttonPanel;
    protected JButton turnIrregular;
    private boolean hasInfluenceArea;
    private Color color;

    public IrregularAreaEditionPanel(String string, RectangleArea rectangleArea, boolean bl, Color color) {
        this.setLayout(new BorderLayout());
        this.hasInfluenceArea = bl;
        this.spep = new ScenePreviewEditionPanel(false, string);
        this.color = color;
        this.buttonPanel = this.createButtonPanel();
        this.add((Component)this.spep, "Center");
        this.setRectangular(rectangleArea);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel.add(this.createToolButton("BarriersList.EditNodes", 0, "img/icons/nodeEdit.png", buttonGroup));
        jPanel.add(this.createToolButton("BarriersList.DeleteTool", 2, "img/icons/deleteTool.png", buttonGroup));
        JButton jButton = new JButton(TC.get((String)"SPEP.ConvertToRectangularArea"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IrregularAreaEditionPanel.this.iaec.getEditionRectangle().setRectangular(true);
                IrregularAreaEditionPanel.this.setRectangular(IrregularAreaEditionPanel.this.iaec.getEditionRectangle());
                IrregularAreaEditionPanel.this.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jButton, "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    private AbstractButton createToolButton(String string, final int n, String string2, ButtonGroup buttonGroup) {
        ImageIcon imageIcon = new ImageIcon(string2);
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        buttonGroup.add(jToggleButton);
        jToggleButton.setToolTipText(TC.get((String)string));
        jToggleButton.setFocusable(false);
        if (n == 0) {
            jToggleButton.setSelected(true);
        }
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IrregularAreaEditionPanel.this.iaec.setSelectedTool(n);
            }
        });
        return jToggleButton;
    }

    public ScenePreviewEditionPanel getScenePreviewEditionPanel() {
        return this.spep;
    }

    public void setRectangular(RectangleArea rectangleArea) {
        this.remove(this.buttonPanel);
        if (this.turnIrregular != null) {
            this.remove(this.turnIrregular);
        }
        if (rectangleArea == null || rectangleArea.isRectangular()) {
            this.spep.changeController(new NormalScenePreviewEditionController(this.spep));
            this.spep.setShowTextEdition(true);
            this.spep.setMovableCategory(5, rectangleArea instanceof ActiveAreaDataControl);
            this.spep.setMovableCategory(7, rectangleArea instanceof ExitDataControl);
            this.spep.setMovableCategory(9, false);
            this.spep.removeElements(9);
            this.spep.setIrregularRectangle(null, null);
            if (rectangleArea != null && rectangleArea instanceof ActiveAreaDataControl) {
                this.spep.setSelectedElement((ActiveAreaDataControl)rectangleArea);
                if (((ActiveAreaDataControl)rectangleArea).getInfluenceArea() != null) {
                    this.spep.addInfluenceArea(((ActiveAreaDataControl)rectangleArea).getInfluenceArea());
                }
            }
            if (rectangleArea != null && rectangleArea instanceof ExitDataControl) {
                this.spep.setSelectedElement((ExitDataControl)rectangleArea);
                if (((ExitDataControl)rectangleArea).getInfluenceArea() != null) {
                    this.spep.addInfluenceArea(((ExitDataControl)rectangleArea).getInfluenceArea());
                }
            }
            if (this.spep.getSelectedElement() != null && this.spep.getSelectedElement().getDataControl() != null && this.spep.getSelectedElement().getDataControl() instanceof RectangleArea) {
                this.turnIrregular = new JButton(TC.get((String)"SPEP.ConvertToIrregularArea"));
                this.turnIrregular.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((RectangleArea)((Object)IrregularAreaEditionPanel.this.spep.getSelectedElement().getDataControl())).setRectangular(false);
                        IrregularAreaEditionPanel.this.setRectangular((RectangleArea)((Object)IrregularAreaEditionPanel.this.spep.getSelectedElement().getDataControl()));
                        IrregularAreaEditionPanel.this.repaint();
                    }
                });
                this.add((Component)this.turnIrregular, "North");
            }
        } else {
            this.add((Component)this.buttonPanel, "North");
            this.iaec = new IrregularAreaEditionController(this.spep, rectangleArea, this.color, this.hasInfluenceArea);
            this.spep.changeController(this.iaec);
            this.spep.setShowTextEdition(false);
            this.spep.removeElements(9);
            for (Point point : rectangleArea.getPoints()) {
                this.spep.addPoint(new PointDataControl(point));
            }
            this.spep.setMovableCategory(9, true);
            this.spep.setMovableCategory(5, false);
            this.spep.setMovableCategory(7, false);
            this.spep.setSelectedElement((ImageElement)null);
            if (rectangleArea != null && rectangleArea instanceof ActiveAreaDataControl && ((ActiveAreaDataControl)rectangleArea).getInfluenceArea() != null) {
                this.spep.addInfluenceArea(((ActiveAreaDataControl)rectangleArea).getInfluenceArea());
            }
            if (rectangleArea != null && rectangleArea instanceof ExitDataControl && ((ExitDataControl)rectangleArea).getInfluenceArea() != null) {
                this.spep.addInfluenceArea(((ExitDataControl)rectangleArea).getInfluenceArea());
            }
        }
        this.updateUI();
    }
}

