/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.gui.BookEditorPane;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FormattedTextPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean isValid;
    private String uri;
    private BookEditorPane editorPane = new BookEditorPane();
    private JPanel errorPanel = new JPanel();

    public FormattedTextPanel() {
        this.errorPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.errorPanel.add((Component)new JLabel(TC.get((String)"FormattedTextAssets.NotAvailable")), gridBagConstraints);
        this.editorPane.setOpaque(false);
        this.editorPane.setEditable(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.errorPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String string) {
        this.isValid = true;
        this.uri = string;
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length()).toLowerCase();
        if (string2.equals("html") || string2.equals("htm") || string2.equals("rtf")) {
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = null;
            try {
                int n;
                inputStream = AssetsController.getInputStream(string);
                while ((n = inputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            catch (IOException iOException) {
                this.isValid = false;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.isValid = false;
                    }
                }
            }
            if (string2.equals("html") || string2.equals("htm")) {
                this.editorPane.setContentType("text/html");
                ProcessHTML processHTML = new ProcessHTML(stringBuffer.toString());
                String string3 = processHTML.start();
                this.editorPane.setText(string3.toString());
                File file = new File(string);
                try {
                    this.editorPane.setDocumentBase(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else {
                this.editorPane.setContentType("text/rtf");
                this.editorPane.setText(stringBuffer.toString());
            }
            this.isValid = true;
        }
        this.updateUI();
    }

    public void removeFile() {
        this.uri = null;
        this.removeAll();
        this.add((Component)this.errorPanel, "Center");
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.editorPane != null) {
            this.editorPane.paint(graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public class ProcessHTML {
        private String html;
        private int currentPos;
        private int state;
        private final int STATE_NONE = 0;
        private final int STATE_LT = 1;
        private final int STATE_SRC = 2;
        private final int STATE_EQ = 3;
        private final int STATE_RT = 4;
        private final int STATE_RTQ = 5;
        private String reference;

        public ProcessHTML(String string) {
            this.html = string;
            this.currentPos = 0;
            this.state = 0;
        }

        public String start() {
            this.state = 0;
            String string = "";
            this.reference = "";
            this.currentPos = 0;
            while (this.currentPos < this.html.length()) {
                char c = this.html.charAt(this.currentPos);
                string = string.length() < 3 ? string + c : string.substring(1, 3) + c;
                if (this.state == 0) {
                    if (c == '<') {
                        this.state = 1;
                    }
                } else if (this.state == 1) {
                    if (string.toLowerCase().equals("src")) {
                        this.state = 2;
                    } else if (c == '>') {
                        this.state = 0;
                    }
                } else if (this.state == 2) {
                    if (c == '=') {
                        this.state = 3;
                    } else if (c != ' ') {
                        this.state = 0;
                    }
                } else if (this.state == 3) {
                    if (c == '\"') {
                        this.state = 5;
                    } else if (c != ' ') {
                        this.reference = this.reference + c;
                        this.state = 4;
                    }
                } else if (this.state == 5) {
                    if (c != '>' && c != '\"') {
                        this.reference = this.reference + c;
                    } else {
                        this.state = 0;
                        this.replaceReference(this.currentPos - this.reference.length(), this.reference.length());
                    }
                } else if (this.state == 4) {
                    if (c != '>' && c != ' ') {
                        this.reference = this.reference + c;
                    } else {
                        this.state = 0;
                        this.replaceReference(this.currentPos - this.reference.length(), this.reference.length());
                    }
                }
                ++this.currentPos;
            }
            return this.html;
        }

        private void replaceReference(int n, int n2) {
            try {
                String[] stringArray;
                boolean bl = false;
                for (String string3 : stringArray = AssetsController.getAssetsList(7)) {
                    if (!string3.equals(FormattedTextPanel.this.uri)) continue;
                    bl = true;
                }
                if (bl) {
                    int n3 = Math.max(FormattedTextPanel.this.uri.lastIndexOf("/"), FormattedTextPanel.this.uri.lastIndexOf("\\"));
                    String string = FormattedTextPanel.this.uri.substring(0, n3) + "/" + this.reference;
                    String string2 = AssetsController.extractResource(string);
                    if (string2 != null) {
                        String string3;
                        string3 = this.html.substring(0, n);
                        String string4 = this.html.substring(n + n2, this.html.length());
                        File file = new File(string2);
                        this.html = string3 + file.toURI().toURL().toString() + string4;
                    }
                }
                this.reference = "";
            }
            catch (Exception exception) {
                ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)"UNKNOWERROR");
            }
        }
    }
}

