/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ScenePreviewEditionController;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrawPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage backBuffer;
    private static final int MARGIN = 0;
    private static final int MARGIN_X = 300;
    private static final int MARGIN_Y = 300;
    private int marginX;
    private int marginY;
    private double sizeRatio;
    private Image background;
    private int width;
    private int height;
    private double zoom = 1.0;
    private JScrollBar scrollX;
    private JScrollBar scrollY;
    private JPanel insidePanel;
    private JPanel componentPanel;
    private Component component;
    private ScenePreviewEditionController controller;

    public DrawPanel(boolean bl) {
        this.setLayout(new BorderLayout());
        this.insidePanel = this.createInsidePanel();
        this.componentPanel = new JPanel();
        this.componentPanel.setOpaque(false);
        this.componentPanel.setLayout(new ComponentPanelLayout());
        this.componentPanel.add((Component)this.insidePanel, "main");
        this.add((Component)this.componentPanel, "Center");
        this.addZoomElements(bl);
    }

    private void addZoomElements(boolean bl) {
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon("img/icons/zoomout.png");
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setContentAreaFilled(false);
        jButton.setToolTipText(TC.get((String)"DrawPanel.ZoomOut"));
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add(jButton);
        final JSlider jSlider = new JSlider(10, 30);
        jSlider.setValue(10);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (double)jSlider.getValue() / 10.0;
                DrawPanel.this.setZoom(d);
                DrawPanel.this.getParent().repaint();
            }
        });
        jSlider.setFocusable(false);
        jSlider.setToolTipText(TC.get((String)"DrawPanel.ZoomSlider"));
        jPanel.add(jSlider);
        ImageIcon imageIcon2 = new ImageIcon("img/icons/zoomin.png");
        JButton jButton2 = new JButton(imageIcon2);
        jButton2.setPreferredSize(new Dimension(20, 20));
        jButton2.setContentAreaFilled(false);
        jButton2.setToolTipText(TC.get((String)"DrawPanel.ZoomIn"));
        jButton2.setFocusable(false);
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jSlider.setValue(jSlider.getValue() + 3);
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jSlider.setValue(jSlider.getValue() - 3);
            }
        });
        this.scrollX = new JScrollBar(0, 0, 10, 0, 100);
        this.scrollY = new JScrollBar(1, 0, 10, 0, 100);
        this.scrollX.setValue(45);
        this.scrollY.setValue(45);
        this.scrollX.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                DrawPanel.this.getParent().repaint();
            }
        });
        this.scrollY.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                DrawPanel.this.getParent().repaint();
            }
        });
        if (bl) {
            this.add((Component)jPanel, "North");
        }
        this.add((Component)this.scrollX, "South");
        this.add((Component)this.scrollY, "East");
    }

    private JPanel createInsidePanel() {
        this.insidePanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void repaint() {
                super.repaint();
                if (this.getSize().width > 0 && this.getSize().height > 0) {
                    DrawPanel.this.calculateSize();
                    if (DrawPanel.this.backBuffer == null || DrawPanel.this.width != this.getSize().width || DrawPanel.this.height != this.getSize().height) {
                        DrawPanel.this.backBuffer = new BufferedImage(this.getSize().width, this.getSize().height, 6);
                        DrawPanel.this.width = this.getSize().width;
                        DrawPanel.this.height = this.getSize().height;
                    }
                }
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (DrawPanel.this.backBuffer != null) {
                    int n = (int)((double)DrawPanel.this.scrollX.getValue() / 90.0 * (1.0 - 1.0 / DrawPanel.this.zoom) * (double)DrawPanel.this.width);
                    int n2 = (int)((double)DrawPanel.this.scrollY.getValue() / 90.0 * (1.0 - 1.0 / DrawPanel.this.zoom) * (double)DrawPanel.this.height);
                    int n3 = (int)((double)DrawPanel.this.width / DrawPanel.this.zoom);
                    int n4 = (int)((double)DrawPanel.this.height / DrawPanel.this.zoom);
                    graphics.drawImage(DrawPanel.this.backBuffer, 0, 0, DrawPanel.this.width, DrawPanel.this.height, n, n2, n + n3, n2 + n4, null);
                }
            }
        };
        return this.insidePanel;
    }

    public void setZoom(double d) {
        this.zoom = d;
    }

    public void setBackgroundImg(Image image) {
        this.background = image;
        this.calculateSize();
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.insidePanel != null) {
            this.insidePanel.repaint();
        }
        if (this.componentPanel != null) {
            if (this.component != null) {
                this.componentPanel.updateUI();
            }
            this.componentPanel.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public Graphics getGraphics() {
        if (this.backBuffer == null) {
            int n;
            int n2 = this.insidePanel.getSize().width;
            if (n2 < 1) {
                n2 = 1;
            }
            if ((n = this.insidePanel.getSize().height) < 1) {
                n = 1;
            }
            this.backBuffer = new BufferedImage(n2, n, 6);
            this.height = n;
            this.width = n2;
        }
        return this.backBuffer.getGraphics();
    }

    public void paintBackground() {
        Object object;
        if (this.backBuffer != null) {
            object = (Graphics2D)this.backBuffer.getGraphics();
            ((Graphics)object).setColor(this.insidePanel.getBackground());
            ((Graphics)object).fillRect(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight());
        }
        if (this.background != null) {
            this.paintRelativeImage(this.background, this.background.getWidth(null) / 2, this.background.getHeight(null), 1.0, 1.0f);
        } else {
            object = new ImageIcon("img/icons/noImageFrame.png");
            Image image = object != null && ((ImageIcon)object).getImage() != null ? ((ImageIcon)object).getImage() : new BufferedImage(100, 120, 5);
            this.paintRelativeImage(image, image.getWidth(null) / 2, image.getHeight(null), 1.0, 1.0f);
        }
    }

    protected void paintRelativeImage(Image image, int n, int n2, double d, float f) {
        if (this.checkBackBuffer() && image != null) {
            int n3 = (int)((double)image.getWidth(null) * this.sizeRatio);
            int n4 = (int)((double)image.getHeight(null) * this.sizeRatio);
            int n5 = this.marginX + (int)((double)n * this.sizeRatio - (double)n3 * d / 2.0);
            int n6 = this.marginY + (int)((double)n2 * this.sizeRatio - (double)n4 * d);
            Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
            if (f != 1.0f) {
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.drawImage(image, n5, n6, (int)((double)n3 * d), (int)((double)n4 * d), null);
        }
    }

    public void paintRelativeImageTop(Image image, int n, int n2, double d) {
        if (this.checkBackBuffer() && image != null) {
            int n3 = (int)((double)image.getWidth(null) * this.sizeRatio);
            int n4 = (int)((double)image.getHeight(null) * this.sizeRatio);
            int n5 = this.marginX + (int)((double)n * this.sizeRatio);
            int n6 = this.marginY + (int)((double)n2 * this.sizeRatio);
            this.backBuffer.getGraphics().drawImage(image, n5, n6, (int)((double)n3 * d), (int)((double)n4 * d), null);
        }
    }

    protected void drawRelativeLine(int n, int n2, int n3, int n4) {
        if (this.checkBackBuffer()) {
            int n5 = this.marginX + (int)((double)n * this.sizeRatio);
            int n6 = this.marginY + (int)((double)n2 * this.sizeRatio);
            int n7 = this.marginX + (int)((double)n3 * this.sizeRatio);
            int n8 = this.marginY + (int)((double)n4 * this.sizeRatio);
            this.backBuffer.getGraphics().drawLine(n5, n6, n7, n8);
        }
    }

    protected void drawRelativeLineWithBorder(int n, int n2, int n3, int n4) {
        if (this.checkBackBuffer()) {
            int n5 = this.marginX + (int)((double)n * this.sizeRatio);
            int n6 = this.marginY + (int)((double)n2 * this.sizeRatio);
            int n7 = this.marginX + (int)((double)n3 * this.sizeRatio);
            int n8 = this.marginY + (int)((double)n4 * this.sizeRatio);
            Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n5, n6, n7, n8);
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawLine(n5, n6, n7, n8);
        }
    }

    private synchronized void calculateSize() {
        int n = 800;
        int n2 = 600;
        if (this.background != null) {
            n = this.background.getWidth(null);
            n2 = this.background.getHeight(null);
        }
        if (this.background != null && this.insidePanel.getWidth() > 0 && this.insidePanel.getHeight() > 0) {
            int n3;
            int n4;
            double d = (double)this.insidePanel.getWidth() / (double)this.insidePanel.getHeight();
            double d2 = (double)n / (double)n2;
            this.marginX = 0;
            this.marginY = 0;
            if (d <= d2) {
                int n5;
                n4 = n5 = this.insidePanel.getWidth() - 0;
                n3 = (int)((double)n5 / d2);
            } else {
                int n6 = this.insidePanel.getHeight() - 0;
                n4 = (int)((double)n6 * d2);
                n3 = n6;
            }
            this.marginX = (this.insidePanel.getWidth() - n4) / 2 - (int)(((double)this.scrollX.getValue() / 90.0 - 0.5) * 300.0);
            this.marginY = (this.insidePanel.getHeight() - n3) / 2 - (int)(((double)this.scrollY.getValue() / 90.0 - 0.5) * 300.0);
            this.sizeRatio = (double)n4 / (double)n;
        }
    }

    public int getRealX(int n) {
        int n2 = (int)(((double)this.marginX - (double)this.scrollX.getValue() / 90.0 * (1.0 - 1.0 / this.zoom) * (double)this.width) * this.zoom);
        return (int)((double)(n - n2) / this.sizeRatio / this.zoom);
    }

    public int getRelativeX(int n) {
        return this.marginX + (int)((double)n * this.sizeRatio);
    }

    public int getRealY(int n) {
        int n2 = (int)(((double)this.marginY - (double)this.scrollY.getValue() / 90.0 * (1.0 - 1.0 / this.zoom) * (double)this.height) * this.zoom);
        return (int)((double)(n - n2) / this.sizeRatio / this.zoom);
    }

    public int getRelativeY(int n) {
        return this.marginY + (int)((double)n * this.sizeRatio);
    }

    public int getRelativeWidth(int n) {
        return (int)((double)n * this.sizeRatio);
    }

    public int getRealWidth(int n) {
        return (int)((double)n / this.sizeRatio / this.zoom);
    }

    public int getRelativeHeight(int n) {
        return (int)((double)n * this.sizeRatio);
    }

    public int getRealHeight(int n) {
        return (int)((double)n / this.sizeRatio / this.zoom);
    }

    public void drawRelativeLine(int n, int n2, int n3, int n4, Color color) {
        if (this.checkBackBuffer()) {
            int n5 = this.marginX + (int)((double)n * this.sizeRatio);
            int n6 = this.marginY + (int)((double)n2 * this.sizeRatio);
            int n7 = this.marginX + (int)((double)n3 * this.sizeRatio);
            int n8 = this.marginY + (int)((double)n4 * this.sizeRatio);
            Graphics graphics = this.backBuffer.getGraphics();
            graphics.setColor(color);
            graphics.drawLine(n5, n6, n7, n8);
        }
    }

    public void drawRelativeLine(int n, int n2, int n3, int n4, Color color, Stroke stroke) {
        if (this.checkBackBuffer()) {
            int n5 = this.marginX + (int)((double)n * this.sizeRatio);
            int n6 = this.marginY + (int)((double)n2 * this.sizeRatio);
            int n7 = this.marginX + (int)((double)n3 * this.sizeRatio);
            int n8 = this.marginY + (int)((double)n4 * this.sizeRatio);
            Graphics graphics = this.backBuffer.getGraphics();
            graphics.setColor(color);
            ((Graphics2D)graphics).setStroke(stroke);
            graphics.drawLine(n5, n6, n7, n8);
        }
    }

    public void fillRelativeCircle(int n, int n2, Color color, int n3) {
        if (this.checkBackBuffer()) {
            int n4 = this.marginX + (int)((double)n * this.sizeRatio);
            int n5 = this.marginY + (int)((double)n2 * this.sizeRatio);
            Graphics graphics = this.backBuffer.getGraphics();
            graphics.setColor(color);
            graphics.fillOval(n4 - n3 / 2, n5 - n3 / 2, n3, n3);
        }
    }

    public void fillRelativePoly(int[] nArray, int[] nArray2, Color color, float f) {
        if (this.checkBackBuffer()) {
            int[] nArray3 = new int[nArray.length];
            int[] nArray4 = new int[nArray2.length];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = this.marginX + (int)((double)nArray[i] * this.sizeRatio);
                nArray4[i] = this.marginY + (int)((double)nArray2[i] * this.sizeRatio);
            }
            Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
            graphics2D.setColor(color);
            if (f != 1.0f) {
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.fillPolygon(nArray3, nArray4, nArray3.length);
        }
    }

    public void drawRelativeString(String string, int n, int n2) {
        if (this.checkBackBuffer()) {
            int n3 = this.marginX + (int)((double)n * this.sizeRatio);
            int n4 = this.marginY + (int)((double)n2 * this.sizeRatio);
            Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, n3 - 1, n4 - 1);
            graphics2D.drawString(string, n3 - 1, n4 + 1);
            graphics2D.drawString(string, n3 + 1, n4 - 1);
            graphics2D.drawString(string, n3 + 1, n4 + 1);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string, n3, n4);
        }
    }

    public void drawRelativeArrowTip(int n, int n2, int n3, int n4, Color color) {
        if (this.checkBackBuffer()) {
            Graphics graphics = this.backBuffer.getGraphics();
            graphics.setColor(color);
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            int n5 = this.marginX + (int)((double)n3 * this.sizeRatio);
            int n6 = this.marginY + (int)((double)n4 * this.sizeRatio);
            double d = n3 - n;
            double d2 = n4 - n2;
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 != 0.0) {
                nArray[0] = n5;
                nArray2[0] = n6;
                nArray[1] = (int)((double)n5 - 10.0 * (d /= d3) + 5.0 * (d2 /= d3));
                nArray2[1] = (int)((double)n6 - 5.0 * d - 10.0 * d2);
                nArray[2] = (int)((double)n5 - 10.0 * d - 5.0 * d2);
                nArray2[2] = (int)((double)n6 + 5.0 * d - 10.0 * d2);
                graphics.fillPolygon(nArray, nArray2, 3);
            }
        }
    }

    private boolean checkBackBuffer() {
        if (this.backBuffer == null && this.insidePanel.getSize().width > 0 && this.insidePanel.getSize().height > 0) {
            this.backBuffer = new BufferedImage(this.insidePanel.getSize().width, this.insidePanel.getSize().height, 6);
            this.width = this.insidePanel.getSize().width;
            this.height = this.insidePanel.getSize().height;
        }
        return this.backBuffer != null;
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.insidePanel.removeMouseListener(mouseListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.insidePanel.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.insidePanel.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.insidePanel.addMouseMotionListener(mouseMotionListener);
    }

    public int getBackgroundWidth() {
        int n = 800;
        if (this.background != null) {
            n = this.background.getWidth(null);
        }
        return n > 800 ? n : 800;
    }

    public void addComponent(Component component, int n, int n2) {
        if (this.component != null) {
            this.componentPanel.remove(this.component);
        }
        this.componentPanel.add(component, "" + n + ";" + n2);
        this.component = component;
        this.componentPanel.setComponentZOrder(component, 0);
        this.componentPanel.setComponentZOrder(this.insidePanel, 1);
        System.out.println("a\u0096adido boton!");
        this.componentPanel.updateUI();
        this.componentPanel.repaint();
    }

    public void removeComponent(Component component) {
        this.componentPanel.remove(component);
        this.component = null;
        this.componentPanel.setComponentZOrder(this.insidePanel, 0);
        this.componentPanel.updateUI();
        this.componentPanel.repaint();
    }

    private class ComponentPanelLayout
    implements LayoutManager2 {
        List<LayoutComponent> components = new ArrayList<LayoutComponent>();

        private ComponentPanelLayout() {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.components.add(new LayoutComponent(component, (String)object));
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            for (LayoutComponent layoutComponent : this.components) {
                if (!layoutComponent.main) continue;
                layoutComponent.comp.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            for (LayoutComponent layoutComponent : this.components) {
                if (layoutComponent.main) continue;
                layoutComponent.comp.setBounds(DrawPanel.this.getRelativeX(layoutComponent.x) - 30, DrawPanel.this.getRelativeY(layoutComponent.y) - 20, 60, 40);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(container.getSize().width, container.getSize().height);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            LayoutComponent layoutComponent = null;
            for (LayoutComponent layoutComponent2 : this.components) {
                if (layoutComponent2.comp != component) continue;
                layoutComponent = layoutComponent2;
            }
            if (layoutComponent != null) {
                this.components.remove(layoutComponent);
            }
        }

        private class LayoutComponent {
            public Component comp;
            boolean main;
            int x;
            int y;

            public LayoutComponent(Component component, String string) {
                this.comp = component;
                if (string.equals("main")) {
                    this.main = true;
                } else {
                    this.main = false;
                    this.x = Integer.parseInt(string.split(";")[0]);
                    this.y = Integer.parseInt(string.split(";")[1]);
                }
            }
        }
    }
}

