/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.editor.gui.audio.Sound;
import es.eucm.eadventure.editor.gui.audio.SoundMidi;
import es.eucm.eadventure.editor.gui.audio.SoundMp3;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class AudioPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton playButton;
    private JButton stopButton;
    private String audioPath = null;
    private Sound sound = null;

    public AudioPanel() {
        ImageIcon imageIcon = new ImageIcon("img/buttons/play.png");
        ImageIcon imageIcon2 = new ImageIcon("img/buttons/stop.png");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                AudioPanel.this.stopSound();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.stopButton = new JButton(imageIcon2);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioPanel.this.stopSound();
            }
        });
        this.stopButton.setPreferredSize(new Dimension(50, 50));
        this.stopButton.setEnabled(false);
        this.add((Component)this.stopButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.playButton = new JButton(imageIcon);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioPanel.this.playSound();
            }
        });
        this.playButton.setPreferredSize(new Dimension(50, 50));
        this.playButton.setEnabled(false);
        this.add((Component)this.playButton, gridBagConstraints);
    }

    public AudioPanel(String string) {
        this();
        this.loadAudio(string);
    }

    public void loadAudio(String string) {
        this.audioPath = string;
        this.playButton.setEnabled(true);
        this.stopButton.setEnabled(true);
        this.stopSound();
    }

    public void removeAudio() {
        this.audioPath = null;
        this.playButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.stopSound();
    }

    public synchronized void playSound() {
        this.stopSound();
        if (this.audioPath != null) {
            String string = this.audioPath.toLowerCase();
            if (string.endsWith("mp3")) {
                this.sound = new SoundMp3(this.audioPath);
            } else if (string.endsWith("mid") || string.endsWith("midi")) {
                this.sound = new SoundMidi(this.audioPath);
            }
            this.sound.startPlaying();
        }
    }

    public synchronized void stopSound() {
        if (this.sound != null) {
            this.sound.stopPlaying();
            this.sound = null;
        }
    }
}

