/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.gui.audio.Sound;
import es.eucm.eadventure.editor.gui.audio.SoundMidi;
import es.eucm.eadventure.editor.gui.audio.SoundMp3;
import es.eucm.eadventure.editor.gui.auxiliar.clock.Clock;
import es.eucm.eadventure.editor.gui.auxiliar.clock.ClockListener;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class AnimationPanel
extends JPanel
implements ClockListener {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = 20;
    private static final int TIME_PER_FRAME = 100;
    private static final int TIME_PER_SLIDE = 1200;
    private Clock clock;
    private int imageTime;
    private Image[] frames;
    private long accumulatedAnimationTime;
    private int currentFrameIndex;
    private Animation animation;
    private boolean useAudio;
    private int where;

    public AnimationPanel(boolean bl, int n) {
        this.useAudio = bl;
        this.where = n;
        this.addAncestorListener(new ClosingListener());
        this.addMouseListener(new AnimationPanelMouseListener());
        this.frames = null;
        this.clock = new Clock(this);
        this.clock.start();
        this.setLayout(new GridBagLayout());
        this.add(new JLabel(TC.get((String)"AnimationPanel.AnimationNotAvalaible")));
    }

    public AnimationPanel(boolean bl, String string) {
        this(bl, 1);
        this.loadAnimation(string);
    }

    public AnimationPanel(boolean bl, Animation animation) {
        this(bl, 1);
        this.animation = animation;
        animation.restart();
        this.removeAll();
        if (!this.isAnimationLoaded()) {
            this.add(new JLabel(TC.get((String)"AnimationPanel.AnimationNotAvalaible")));
            this.revalidate();
        }
        this.repaint();
    }

    public void loadAnimation(String string) {
        if (this.frames != null) {
            for (Image image : this.frames) {
                image.flush();
            }
        }
        this.animation = null;
        if (string.endsWith(".eaa")) {
            this.animation = Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, (ImageLoaderFactory)new EditorImageLoader());
            this.animation.setAbsolutePath(string);
        } else if (string != null) {
            this.frames = AssetsController.getAnimation(string);
            this.currentFrameIndex = 0;
            if (string.endsWith("png")) {
                this.imageTime = 100;
            } else if (string.endsWith("jpg")) {
                this.imageTime = 1200;
            }
        } else {
            this.frames = null;
        }
        this.removeAll();
        if (!this.isAnimationLoaded()) {
            this.add(new JLabel(TC.get((String)"AnimationPanel.AnimationNotAvalaible")));
            this.revalidate();
        }
        this.repaint();
    }

    public void removeAnimation() {
        if (this.frames != null) {
            for (Image image : this.frames) {
                image.flush();
            }
        }
        this.frames = null;
        this.removeAll();
        this.add(new JLabel(TC.get((String)"AnimationPanel.AnimationNotAvalaible")));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void update(long l) {
        if (this.animation != null) {
            if (!this.animation.isSlides() || !this.animation.finishedFirstTime(this.accumulatedAnimationTime)) {
                this.accumulatedAnimationTime += l;
                this.repaint();
            }
        } else if (this.isAnimationLoaded() && this.frames.length > 1) {
            this.accumulatedAnimationTime += l;
            while (this.accumulatedAnimationTime > (long)this.imageTime) {
                this.accumulatedAnimationTime -= (long)this.imageTime;
                ++this.currentFrameIndex;
            }
            this.currentFrameIndex %= this.frames.length;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isAnimationLoaded()) {
            int n;
            int n2;
            double d;
            double d2 = (double)(this.getWidth() - 40) / (double)(this.getHeight() - 40);
            if (this.animation != null) {
                Image image = this.animation.getImage(this.accumulatedAnimationTime, this.where);
                String string = this.animation.getNewSound();
                Sound sound = null;
                if (this.useAudio && string != null) {
                    String string2 = string.toLowerCase();
                    if (string2.endsWith("mp3")) {
                        sound = new SoundMp3(string);
                    } else if (string2.endsWith("mid") || string2.endsWith("midi")) {
                        sound = new SoundMidi(string);
                    }
                    if (sound != null) {
                        sound.startPlaying();
                    }
                }
                d = (double)image.getWidth(null) / (double)image.getHeight(null);
            } else {
                d = (double)this.frames[this.currentFrameIndex].getWidth(null) / (double)this.frames[this.currentFrameIndex].getHeight(null);
            }
            int n3 = -40;
            int n4 = -40;
            if (d2 <= d) {
                n3 += this.getWidth();
                n2 = 20;
                n = (this.getHeight() - (n4 += (int)((double)this.getWidth() / d))) / 2;
            } else {
                n4 += this.getHeight();
                n2 = (this.getWidth() - (n3 += (int)((double)this.getHeight() * d))) / 2;
                n = 20;
            }
            if (this.animation != null) {
                graphics.drawImage(this.animation.getImage(this.accumulatedAnimationTime, this.where), n2, n, n3, n4, null, null);
            } else {
                graphics.drawImage(this.frames[this.currentFrameIndex], n2, n, n3, n4, null, null);
            }
        }
    }

    private boolean isAnimationLoaded() {
        return this.frames != null && this.frames.length > 0 || this.animation != null;
    }

    public void setWhere(int n) {
        this.where = n;
    }

    private class AnimationPanelMouseListener
    implements MouseListener {
        private AnimationPanelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (AnimationPanel.this.animation != null) {
                AnimationPanel.this.accumulatedAnimationTime = AnimationPanel.this.animation.skipFrame(AnimationPanel.this.accumulatedAnimationTime);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class ClosingListener
    implements AncestorListener {
        private ClosingListener() {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            try {
                if (AnimationPanel.this.clock != null) {
                    AnimationPanel.this.clock.stopClock();
                    AnimationPanel.this.clock.join();
                    AnimationPanel.this.clock = null;
                }
            }
            catch (InterruptedException interruptedException) {
                ReportDialog.GenerateErrorReport((Exception)interruptedException, (boolean)true, (String)"UNKNOWERROR");
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }
}

