/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes.elementdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESContainer;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESGeneralId;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LOMlIdentifierDialog
extends JDialog {
    private JTextField catalog;
    private JTextField entry;
    private String catalogValue;
    private String entryValue;

    public LOMlIdentifierDialog(LOMESContainer lOMESContainer, int n, int n2) {
        super(Controller.getInstance().peekWindow(), lOMESContainer.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        Controller.getInstance().pushWindow(this);
        if (n == 0) {
            this.catalogValue = "Cat\u00e1logo unificado mec-red.es-ccaa de identificaci\u00f3n de ODE";
            this.entryValue = "es-ma_20090317_2_1300009";
            if (n2 == 1) {
                this.entryValue = this.entryValue + "-meta";
            }
        } else {
            this.catalogValue = ((LOMESGeneralId)lOMESContainer.get(n - 1)).getCatalog();
            this.entryValue = ((LOMESGeneralId)lOMESContainer.get(n - 1)).getEntry();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.catalog = new JTextField(this.catalogValue);
        this.catalog.getDocument().addDocumentListener(new TextFieldListener(this.catalog));
        jPanel.add((Component)this.catalog, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.GeneralId.CatalogName")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.entry = new JTextField(this.entryValue);
        this.entry.getDocument().addDocumentListener(new TextFieldListener(this.entry));
        jPanel2.add((Component)this.entry, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.GeneralId.EntryName")));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMlIdentifierDialog.this.dispose();
            }
        });
        jPanel3.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton("Info");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMlIdentifierDialog.this.showInfo();
            }
        });
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)jButton2, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        this.getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)jPanel4, gridBagConstraints);
        this.setSize(new Dimension(350, 200));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    public String getCatalog() {
        return this.catalogValue;
    }

    public String getEntry() {
        return this.entryValue;
    }

    private void showInfo() {
        JOptionPane.showMessageDialog(this, TC.get((String)"LOMES.Identifier.EntryInfo"), "Info", 1);
    }

    private class TextFieldListener
    implements DocumentListener {
        private JTextField textField;

        public TextFieldListener(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField == LOMlIdentifierDialog.this.catalog) {
                LOMlIdentifierDialog.this.catalogValue = this.textField.getText();
            } else if (this.textField == LOMlIdentifierDialog.this.entry) {
                LOMlIdentifierDialog.this.entryValue = this.textField.getText();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

