/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes.elementdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMClassificationTaxonPath;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESContainer;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMTaxon;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESCreateContainerPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMLangStringPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class LOMTaxonPathDialog
extends JDialog {
    private LOMLangStringPanel source;
    private LOMESCreateContainerPanel taxon;
    private LangString sourceValue;
    private LOMTaxon taxonValue;
    private LOMESContainer container;

    public LOMTaxonPathDialog(LOMESContainer lOMESContainer, int n) {
        super(Controller.getInstance().peekWindow(), lOMESContainer.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        Controller.getInstance().pushWindow(this);
        this.container = lOMESContainer;
        if (n == 0) {
            this.sourceValue = new LangString("Empty");
            this.taxonValue = new LOMTaxon();
        } else {
            this.sourceValue = ((LOMClassificationTaxonPath)lOMESContainer.get(n - 1)).getSource();
            this.taxonValue = ((LOMClassificationTaxonPath)lOMESContainer.get(n - 1)).getTaxon();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.source = new LOMLangStringPanel(this.sourceValue, TC.get((String)"LOMES.Classification.TaxonPathSorce"));
        this.taxon = new LOMESCreateContainerPanel(this.taxonValue, TC.get((String)"LOMES.Classification.TaxonPathTaxon"), 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMTaxonPathDialog.this.dispose();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.source, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.taxon, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add(jPanel2);
        this.setSize(new Dimension(270, 230));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    public LangString getSourceValue() {
        return this.sourceValue;
    }

    public LOMTaxon getTaxonValue() {
        return this.taxonValue;
    }
}

