/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes.elementdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMClassificationTaxon;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESContainer;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMLangStringPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LOMTaxonDialog
extends JDialog {
    private JTextField id;
    private LOMLangStringPanel entry;
    private String idValue;
    private LangString entryValue;

    public LOMTaxonDialog(LOMESContainer lOMESContainer, int n) {
        super(Controller.getInstance().peekWindow(), lOMESContainer.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        Controller.getInstance().pushWindow(this);
        if (n == 0) {
            this.idValue = "";
            this.entryValue = new LangString("");
        } else {
            this.idValue = ((LOMClassificationTaxon)lOMESContainer.get(n - 1)).getIdentifier();
            this.entryValue = ((LOMClassificationTaxon)lOMESContainer.get(n - 1)).getEntry();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.id = new JTextField(this.idValue);
        this.id.getDocument().addDocumentListener(new TextFieldListener());
        jPanel.add((Component)this.id, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Classification.TaxonId")));
        this.entry = new LOMLangStringPanel(this.entryValue, TC.get((String)"LOMES.Classification.TaxonEntry"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.entry, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMTaxonDialog.this.dispose();
            }
        });
        jPanel3.add((Component)jButton, gridBagConstraints);
        this.getContentPane().setLayout(new GridLayout(0, 2));
        this.getContentPane().add(jPanel2);
        this.getContentPane().add(jPanel3);
        this.setSize(new Dimension(250, 200));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    public String getIdValue() {
        return this.idValue;
    }

    public LangString getEntryValue() {
        return this.entryValue;
    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            LOMTaxonDialog.this.idValue = LOMTaxonDialog.this.id.getText();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

