/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes.elementdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LOMStringDialog
extends JDialog {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_AREA = 1;
    public static final int TYPE_FIELD = 2;
    private JTextField text;
    private String textValue;
    private JTextArea textArea;
    private int type;

    public LOMStringDialog(String string, int n) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"LOMES.Value"), Dialog.ModalityType.APPLICATION_MODAL);
        Controller.getInstance().pushWindow(this);
        this.type = n;
        this.textValue = string;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (n == 2) {
            this.text = new JTextField(this.textValue);
            this.text.getDocument().addDocumentListener(new TextFieldListener());
            jPanel.add((Component)this.text, gridBagConstraints);
            this.textArea = null;
            this.setSize(new Dimension(200, 150));
        } else if (n == 1) {
            this.textArea = new JTextArea(this.textValue, 4, 0);
            this.textArea.getDocument().addDocumentListener(new TextFieldListener());
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setEditable(true);
            gridBagConstraints.ipady = 100;
            jPanel.add((Component)new JScrollPane(this.textArea, 22, 31), gridBagConstraints);
            this.setSize(new Dimension(250, 200));
            this.text = null;
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMStringDialog.this.dispose();
            }
        });
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)jPanel2, gridBagConstraints);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    public String getTextValue() {
        return this.textValue;
    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (LOMStringDialog.this.type == 2) {
                LOMStringDialog.this.textValue = LOMStringDialog.this.text.getText();
            } else if (LOMStringDialog.this.type == 1) {
                LOMStringDialog.this.textValue = LOMStringDialog.this.textArea.getText();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

