/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes.elementdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.data.meta.Vocabulary;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESContainer;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMOrComposite;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMVocabularyPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LOMRequirementsDialog
extends JDialog {
    private LOMVocabularyPanel type;
    private LOMVocabularyPanel name;
    private JTextField minimumVersion;
    private JTextField maximumVersion;
    private Vocabulary typeValue;
    private Vocabulary nameValue;
    private String maxValue;
    private String minValue;
    private LOMESContainer container;

    public LOMRequirementsDialog(LOMESContainer lOMESContainer, int n) {
        super(Controller.getInstance().peekWindow(), lOMESContainer.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        Controller.getInstance().pushWindow(this);
        this.container = lOMESContainer;
        if (n == 0) {
            this.typeValue = new Vocabulary(Vocabulary.TE_TYPE_4_4_1_1);
            this.nameValue = new Vocabulary(Vocabulary.TE_NAME_4_4_1_2);
            this.maxValue = Controller.getInstance().getEditorMinVersion();
            this.minValue = Controller.getInstance().getEditorVersion();
        } else {
            this.typeValue = ((LOMOrComposite)lOMESContainer.get(n - 1)).getType();
            this.nameValue = ((LOMOrComposite)lOMESContainer.get(n - 1)).getName();
            this.maxValue = ((LOMOrComposite)lOMESContainer.get(n - 1)).getMaximumVersion();
            this.minValue = ((LOMOrComposite)lOMESContainer.get(n - 1)).getMinimumVersion();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.type = new LOMVocabularyPanel(LOMOrComposite.getTypeOptions(), this.typeValue.getValueIndex());
        jPanel.add((Component)this.type, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Technical.Type")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.name = new LOMVocabularyPanel(LOMOrComposite.getNameOptions(), this.nameValue.getValueIndex());
        jPanel2.add((Component)this.name, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Technical.Name")));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.maximumVersion = new JTextField(this.maxValue);
        this.maximumVersion.setEditable(false);
        jPanel3.add((Component)this.maximumVersion, gridBagConstraints);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOM.Technical.MaximumVersion")));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.minimumVersion = new JTextField(this.minValue);
        this.minimumVersion.setEditable(false);
        jPanel4.add((Component)this.minimumVersion, gridBagConstraints);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOM.Technical.MinimumVersion")));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMRequirementsDialog.this.typeValue.setValueIndex(LOMRequirementsDialog.this.type.getSelection());
                LOMRequirementsDialog.this.nameValue.setValueIndex(LOMRequirementsDialog.this.name.getSelection());
                LOMRequirementsDialog.this.dispose();
            }
        });
        jPanel5.add((Component)jButton, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel6.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel6.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel6.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel6.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel6.add((Component)jPanel5, gridBagConstraints);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add(jPanel6);
        this.setSize(new Dimension(250, 320));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public Vocabulary getTypeValue() {
        return this.typeValue;
    }

    public Vocabulary getNameValue() {
        return this.nameValue;
    }

    public String getMinValue() {
        return this.minValue;
    }
}

