/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes.elementdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.metadata.lomes.LOMESDateDataControl;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESLifeCycleDate;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LOMLifeCycleDateDialog
extends JDialog {
    private JTextField years;
    private JTextField months;
    private JTextField days;
    private JTextField hours;
    private JTextField minutes;
    private JTextField seconds;
    private JTextField milisec;
    private JTextField timeZone;
    private JTextField description;
    private String dateTimeValue;
    private String descriptionValue;
    private LOMESDateDataControl transformer;

    public LOMLifeCycleDateDialog(LOMESLifeCycleDate lOMESLifeCycleDate) {
        super(Controller.getInstance().peekWindow(), lOMESLifeCycleDate.getTitle(), Dialog.ModalityType.APPLICATION_MODAL);
        Controller.getInstance().pushWindow(this);
        this.transformer = new LOMESDateDataControl(lOMESLifeCycleDate);
        this.dateTimeValue = lOMESLifeCycleDate.getDateTime();
        this.descriptionValue = lOMESLifeCycleDate.getDescription().getValue(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        this.years = new JTextField(this.transformer.getYears());
        this.years.getDocument().addDocumentListener(new TextFieldListener(this.years));
        this.years.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Years")));
        jPanel.add((Component)this.years, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.months = new JTextField(this.transformer.getMonths());
        this.months.getDocument().addDocumentListener(new TextFieldListener(this.months));
        this.months.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Months")));
        jPanel.add((Component)this.months, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.days = new JTextField(this.transformer.getDays());
        this.days.getDocument().addDocumentListener(new TextFieldListener(this.days));
        this.days.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Days")));
        jPanel.add((Component)this.days, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.hours = new JTextField(this.transformer.getHours());
        this.hours.getDocument().addDocumentListener(new TextFieldListener(this.hours));
        this.hours.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Hours")));
        jPanel.add((Component)this.hours, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.minutes = new JTextField(this.transformer.getMinutes());
        this.minutes.getDocument().addDocumentListener(new TextFieldListener(this.minutes));
        this.minutes.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Minutes")));
        jPanel.add((Component)this.minutes, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.seconds = new JTextField(this.transformer.getSeconds());
        this.seconds.getDocument().addDocumentListener(new TextFieldListener(this.seconds));
        this.seconds.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Seconds")));
        jPanel.add((Component)this.seconds, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.milisec = new JTextField(this.transformer.getMilisec());
        this.milisec.getDocument().addDocumentListener(new TextFieldListener(this.milisec));
        this.milisec.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.Miliseconds")));
        jPanel.add((Component)this.milisec, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.timeZone = new JTextField(this.transformer.getTimeZone());
        this.timeZone.getDocument().addDocumentListener(new TextFieldListener(this.timeZone));
        this.timeZone.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.Date.TimeZone")));
        jPanel.add((Component)this.timeZone, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.GeneralId.DateName")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.description = new JTextField(lOMESLifeCycleDate.getDescription().getValue(0));
        this.description.getDocument().addDocumentListener(new TextFieldListener(this.description));
        jPanel2.add((Component)this.description, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"LOMES.GeneralId.DescriptionName")));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMLifeCycleDateDialog.this.dispose();
            }
        });
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton("Info");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMLifeCycleDateDialog.this.showInfo();
            }
        });
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)jButton2, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        this.getContentPane().add(jPanel4);
        this.setSize(new Dimension(250, 500));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    private void showInfo() {
        JOptionPane.showMessageDialog(this, TC.get((String)"LOMES.Date.Info"), "Info", 1);
    }

    public String getDateTimeValue() {
        this.dateTimeValue = this.transformer.toString();
        return this.dateTimeValue;
    }

    public String getDescriptionValue() {
        return this.descriptionValue;
    }

    private class TextFieldListener
    implements DocumentListener {
        private JTextField textField;

        public TextFieldListener(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField == LOMLifeCycleDateDialog.this.years) {
                LOMLifeCycleDateDialog.this.transformer.setYears(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.months) {
                LOMLifeCycleDateDialog.this.transformer.setMonths(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.days) {
                LOMLifeCycleDateDialog.this.transformer.setDays(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.hours) {
                LOMLifeCycleDateDialog.this.transformer.setHours(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.minutes) {
                LOMLifeCycleDateDialog.this.transformer.setMinutes(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.seconds) {
                LOMLifeCycleDateDialog.this.transformer.setSeconds(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.milisec) {
                LOMLifeCycleDateDialog.this.transformer.setMiliSeconds(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.timeZone) {
                LOMLifeCycleDateDialog.this.transformer.setTimeZone(this.textField.getText());
            } else if (this.textField == LOMLifeCycleDateDialog.this.description) {
                LOMLifeCycleDateDialog.this.descriptionValue = this.textField.getText();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

