/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomes;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.metadata.lomes.LOMESDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESEducationalPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESGeneralPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESLifeCycleAndTechnicalPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESMetaMetaDataPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESRightsAndClassificationPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LOMESDialog
extends JDialog {
    private LOMESDataControl dataControl;
    private JTabbedPane tabs;
    private JButton ok;
    private int currentTab;
    private static final String helpPath = "metadata/LOMES.html";

    public LOMESDialog(LOMESDataControl lOMESDataControl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"LOM.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.dataControl = lOMESDataControl;
        Controller.getInstance().pushWindow(this);
        JButton jButton = new JButton(new ImageIcon("img/icons/information.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog(LOMESDialog.helpPath);
            }
        });
        this.tabs = new JTabbedPane();
        this.tabs.insertTab(TC.get((String)"LOM.General.Tab"), null, new LOMESGeneralPanel(lOMESDataControl.getGeneral()), TC.get((String)"LOM.General.Tip"), 0);
        this.tabs.insertTab(TC.get((String)"LOM.LifeCycle.Tab") + " & " + TC.get((String)"LOM.Technical.Tab"), null, new LOMESLifeCycleAndTechnicalPanel(lOMESDataControl.getLifeCycle(), lOMESDataControl.getTechnical()), TC.get((String)"LOM.LifeCycle.Tip") + " & " + TC.get((String)"LOM.Technical.Tip"), 1);
        this.tabs.insertTab(TC.get((String)"IMS.Meta.Tab"), null, new LOMESMetaMetaDataPanel(lOMESDataControl.getMetametadata()), TC.get((String)"IMS.Meta.Tip"), 2);
        this.tabs.insertTab(TC.get((String)"LOM.Educational.Tab"), null, new LOMESEducationalPanel(lOMESDataControl.getEducational()), TC.get((String)"LOM.Educational.Tip"), 3);
        this.tabs.insertTab(TC.get((String)"IMS.Rights.Tab") + " & " + TC.get((String)"IMS.Classification.Tab"), null, new LOMESRightsAndClassificationPanel(lOMESDataControl.getRights(), lOMESDataControl.getClassification()), TC.get((String)"IMS.Rights.Tip") + " & " + TC.get((String)"IMS.Classification.Tip"), 4);
        this.tabs.add((Component)new JPanel(), 5);
        this.tabs.setTabComponentAt(5, jButton);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LOMESDialog.this.tabs.getSelectedIndex() == 5) {
                    LOMESDialog.this.tabs.setSelectedIndex(LOMESDialog.this.currentTab);
                } else {
                    LOMESDialog.this.currentTab = LOMESDialog.this.tabs.getSelectedIndex();
                }
            }
        });
        this.tabs.setSelectedIndex(1);
        this.currentTab = 1;
        this.ok = new JButton("OK");
        this.ok.setToolTipText("Close the window");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMESDialog.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.tabs, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)this.ok, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.setMinimumSize(new Dimension(490, 520));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    public void close() {
        this.dispose();
    }
}

