/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.lomdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import es.eucm.eadventure.editor.gui.metadatadialog.lomdialog.LOMEducationalPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomdialog.LOMGeneralPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.lomdialog.LOMLifeCycleAndTechnicalPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LOMDialog
extends JDialog {
    private LOMDataControl dataControl;
    private JTabbedPane tabs;
    private JButton ok;
    private int currentTab;
    private static final String helpPath = "metadata/LOM.html";

    public LOMDialog(LOMDataControl lOMDataControl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"LOM.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.dataControl = lOMDataControl;
        JButton jButton = new JButton(new ImageIcon("img/icons/information.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog(LOMDialog.helpPath);
            }
        });
        this.tabs = new JTabbedPane();
        this.tabs.insertTab(TC.get((String)"LOM.General.Tab"), null, new LOMGeneralPanel(lOMDataControl.getGeneral()), TC.get((String)"LOM.General.Tip"), 0);
        this.tabs.insertTab(TC.get((String)"LOM.LifeCycle.Tab") + " & " + TC.get((String)"LOM.Technical.Tab"), null, new LOMLifeCycleAndTechnicalPanel(lOMDataControl.getLifeCycle(), lOMDataControl.getTechnical()), TC.get((String)"LOM.LifeCycle.Tip") + " & " + TC.get((String)"LOM.Technical.Tip"), 1);
        this.tabs.insertTab(TC.get((String)"LOM.Educational.Tab"), null, new LOMEducationalPanel(lOMDataControl.getEducational()), TC.get((String)"LOM.Educational.Tip"), 2);
        this.tabs.add((Component)new JPanel(), 3);
        this.tabs.setTabComponentAt(3, jButton);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LOMDialog.this.tabs.getSelectedIndex() == 3) {
                    LOMDialog.this.tabs.setSelectedIndex(LOMDialog.this.currentTab);
                } else {
                    LOMDialog.this.currentTab = LOMDialog.this.tabs.getSelectedIndex();
                }
            }
        });
        this.tabs.setSelectedIndex(1);
        this.currentTab = 1;
        this.ok = new JButton("OK");
        this.ok.setToolTipText("Close the window");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOMDialog.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.tabs, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)this.ok, gridBagConstraints);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.setMinimumSize(new Dimension(450, 520));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public void close() {
        this.dispose();
    }
}

