/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.ims;

import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSTextDataControl;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IMSTextPanel
extends JPanel {
    public static final int TYPE_AREA = 0;
    public static final int TYPE_FIELD = 1;
    protected IMSTextDataControl dataControl;
    private JTextArea textArea;
    protected JTextField textField;

    public IMSTextPanel(IMSTextDataControl iMSTextDataControl, String string, int n) {
        this(iMSTextDataControl, string, n, true);
    }

    public IMSTextPanel(IMSTextDataControl iMSTextDataControl, String string, int n, boolean bl) {
        this.dataControl = iMSTextDataControl;
        this.setLayout(new GridLayout());
        if (n == 0) {
            this.textArea = new JTextArea(iMSTextDataControl.getText(), 4, 0);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.getDocument().addDocumentListener(new TextAreaChangesListener());
            this.textArea.setEditable(bl);
            this.add(new JScrollPane(this.textArea, 22, 31));
            this.textField = null;
        } else if (n == 1) {
            this.textField = new JTextField(iMSTextDataControl.getText());
            this.textField.addActionListener(new TextFieldChangesListener());
            this.textField.addFocusListener(new TextFieldChangesListener());
            this.textField.setEditable(bl);
            this.add(this.textField);
            this.textArea = null;
        }
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
    }

    private void valueChanged(Object object) {
        if (this.textField != null) {
            this.dataControl.setText(this.textField.getText());
        } else if (this.textArea != null) {
            this.dataControl.setText(this.textArea.getText());
        }
    }

    public void updateText() {
        if (this.textField != null) {
            this.textField.setText(this.dataControl.getText());
        } else if (this.textArea != null) {
            this.textArea.setText(this.dataControl.getText());
        }
        this.updateUI();
    }

    private class TextFieldChangesListener
    extends FocusAdapter
    implements ActionListener {
        private TextFieldChangesListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            IMSTextPanel.this.valueChanged(focusEvent.getSource());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IMSTextPanel.this.valueChanged(actionEvent.getSource());
        }
    }

    private class TextAreaChangesListener
    implements DocumentListener {
        private TextAreaChangesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            IMSTextPanel.this.dataControl.setText(IMSTextPanel.this.textArea.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            IMSTextPanel.this.dataControl.setText(IMSTextPanel.this.textArea.getText());
        }
    }
}

