/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.metadatadialog.ims;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import es.eucm.eadventure.editor.gui.metadatadialog.ims.IMSEducationalPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.ims.IMSGeneralPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.ims.IMSLifeCycleTechnicalAndMetaPanel;
import es.eucm.eadventure.editor.gui.metadatadialog.ims.IMSRightsAndClassificationPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IMSDialog
extends JDialog {
    private static final String helpPath = "metadata/IMSLOM.html";
    private IMSDataControl dataControl;
    private JTabbedPane tabs;
    private JButton ok;
    private int currentTab;

    public IMSDialog(IMSDataControl iMSDataControl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"LOM.Title"), Dialog.ModalityType.TOOLKIT_MODAL);
        this.dataControl = iMSDataControl;
        this.tabs = new JTabbedPane();
        JButton jButton = new JButton(new ImageIcon("img/icons/information.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog(IMSDialog.helpPath);
            }
        });
        this.tabs.insertTab(TC.get((String)"LOM.General.Tab"), null, new IMSGeneralPanel(iMSDataControl.getGeneral()), TC.get((String)"LOM.General.Tip"), 0);
        this.tabs.insertTab(TC.get((String)"LOM.LifeCycle.Tab") + " & " + TC.get((String)"LOM.Technical.Tab") + " & " + TC.get((String)"IMS.Meta.Tab"), null, new IMSLifeCycleTechnicalAndMetaPanel(iMSDataControl.getLifeCycle(), iMSDataControl.getTechnical(), iMSDataControl.getMetametadata()), TC.get((String)"LOM.LifeCycle.Tip") + " & " + TC.get((String)"LOM.Technical.Tip") + " & " + TC.get((String)"IMS.Meta.Tip"), 1);
        this.tabs.insertTab(TC.get((String)"LOM.Educational.Tab"), null, new IMSEducationalPanel(iMSDataControl.getEducational()), TC.get((String)"LOM.Educational.Tip"), 2);
        this.tabs.insertTab(TC.get((String)"IMS.Rights.Tab") + " & " + TC.get((String)"IMS.Classification.Tab"), null, new IMSRightsAndClassificationPanel(iMSDataControl.getRights(), iMSDataControl.getClassification()), TC.get((String)"IMS.Rights.Tip") + " & " + TC.get((String)"IMS.Classification.Tip"), 3);
        this.tabs.add((Component)new JPanel(), 4);
        this.tabs.setTabComponentAt(4, jButton);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (IMSDialog.this.tabs.getSelectedIndex() == 4) {
                    IMSDialog.this.tabs.setSelectedIndex(IMSDialog.this.currentTab);
                } else {
                    IMSDialog.this.currentTab = IMSDialog.this.tabs.getSelectedIndex();
                }
            }
        });
        this.tabs.setSelectedIndex(1);
        this.currentTab = 1;
        this.ok = new JButton("OK");
        this.ok.setToolTipText("Close the window");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMSDialog.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.tabs, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)this.ok, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.setMinimumSize(new Dimension(490, 450));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public void close() {
        this.dispose();
    }
}

