/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.timer;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.timer.TimersListDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.BooleanCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.timer.TimerTimeCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.timer.TimersListPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class TimersTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected TimersListDataControl dataControl;
    private TimersListPanel panel;

    public TimersTable(TimersListDataControl timersListDataControl, TimersListPanel timersListPanel) {
        this.dataControl = timersListDataControl;
        this.panel = timersListPanel;
        this.setModel(new BarriersTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.getColumnModel().getColumn(1).setCellEditor(new TimerTimeCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new TimerTimeCellRendererEditor());
        this.getColumnModel().getColumn(2).setCellEditor(new BooleanCellRendererEditor());
        this.getColumnModel().getColumn(2).setCellRenderer(new BooleanCellRendererEditor());
        this.setRowHeight(20);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TimersTable.this.setRowHeight(20);
                if (TimersTable.this.getSelectedRow() != -1) {
                    TimersTable.this.setRowHeight(TimersTable.this.getSelectedRow(), 30);
                }
            }
        });
        this.getSelectionModel().setSelectionMode(0);
        this.setSize(200, 150);
    }

    private class BarriersTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private BarriersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return TimersTable.this.dataControl.getTimers().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return TC.getElement((int)44) + ":#" + (n + 1);
            }
            if (n2 == 1) {
                return TimersTable.this.dataControl.getTimers().get(n);
            }
            if (n2 == 2) {
                return new Boolean(TimersTable.this.dataControl.getTimers().get(n).isShowTime());
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"TimersList.Timer");
            }
            if (n == 1) {
                return TC.get((String)"TimersList.Time");
            }
            if (n == 2) {
                return TC.get((String)"TimersList.Display");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                Boolean bl = (Boolean)object;
                TimersTable.this.dataControl.getTimers().get(n).setShowTime(bl);
                TimersTable.this.panel.updateInfoPanel(n);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return TimersTable.this.getSelectedRow() == n && n2 != 0;
        }
    }
}

