/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.timer;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.timer.TimerDataControl;
import es.eucm.eadventure.editor.control.controllers.timer.TimersListDataControl;
import es.eucm.eadventure.editor.control.tools.timer.AddTimerTool;
import es.eucm.eadventure.editor.control.tools.timer.DeleteTimerTool;
import es.eucm.eadventure.editor.control.tools.timer.DuplicateTimerTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.timer.TimerPanel;
import es.eucm.eadventure.editor.gui.elementpanels.timer.TimersTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class TimersListPanel
extends JPanel
implements DataControlsPanel,
Updateable {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_SPLIT_POSITION = 100;
    private TimersListDataControl dataControl;
    private JPanel timerInfoPanel;
    private JTable table;
    private JButton deleteButton;
    private JButton duplicateButton;

    public TimersListPanel(TimersListDataControl timersListDataControl) {
        this.dataControl = timersListDataControl;
        this.setLayout(new BorderLayout());
        this.timerInfoPanel = new JPanel();
        this.timerInfoPanel.setLayout(new BorderLayout());
        JPanel jPanel = this.createTablePanel(this.timerInfoPanel);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.timerInfoPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(100);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerSize(10);
        this.add((Component)jSplitPane, "Center");
    }

    private JPanel createTablePanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.table = new TimersTable(this.dataControl, this);
        TableScrollPane tableScrollPane = new TableScrollPane(this.table, 22, 31);
        tableScrollPane.setMinimumSize(new Dimension(0, 100));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TimersListPanel.this.table.getSelectedRow() >= 0) {
                    TimersListPanel.this.deleteButton.setEnabled(true);
                    TimersListPanel.this.duplicateButton.setEnabled(true);
                } else {
                    TimersListPanel.this.deleteButton.setEnabled(false);
                    TimersListPanel.this.duplicateButton.setEnabled(true);
                }
                TimersListPanel.this.updateInfoPanel(TimersListPanel.this.table.getSelectedRow());
                TimersListPanel.this.deleteButton.repaint();
            }
        });
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"TimersList.AddTimer"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimersListPanel.this.addTimer();
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"TimersList.DeleteTimer"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimersListPanel.this.deleteTimer();
            }
        });
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"TimersList.DuplicateTimer"));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimersListPanel.this.duplicateTimer();
            }
        });
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)this.duplicateButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel3.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)new JFiller(), gridBagConstraints);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)tableScrollPane, "Center");
        jPanel2.add((Component)jPanel3, "East");
        return jPanel2;
    }

    public void updateInfoPanel(int n) {
        this.timerInfoPanel.removeAll();
        if (n >= 0) {
            TimerDataControl timerDataControl = this.dataControl.getTimers().get(n);
            TimerPanel timerPanel = new TimerPanel(timerDataControl);
            this.timerInfoPanel.add(timerPanel);
        }
        this.timerInfoPanel.updateUI();
    }

    protected void addTimer() {
        Controller.getInstance().addTool(new AddTimerTool(this.dataControl));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getTimers().size() - 1, 0, false, false);
    }

    protected void duplicateTimer() {
        Controller.getInstance().addTool(new DuplicateTimerTool(this.dataControl, this.table.getSelectedRow()));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getTimers().size() - 1, 0, false, false);
    }

    protected void deleteTimer() {
        Controller.getInstance().addTool(new DeleteTimerTool(this.dataControl, this.table.getSelectedRow()));
        this.table.clearSelection();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getTimers().size(); ++i) {
                if (this.dataControl.getTimers().get(i) != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public boolean updateFields() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n2 > 0 && n2 == this.dataControl.getTimers().size() && n != -1 && n < this.table.getRowCount()) {
            this.table.changeSelection(n, 0, false, false);
            this.updateInfoPanel(this.table.getSelectedRow());
        }
        return true;
    }
}

