/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.timer;

import es.eucm.eadventure.editor.control.controllers.timer.TimerDataControl;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TimerTimeCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private TimerDataControl value;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (TimerDataControl)object;
        return this.createSpinner(jTable, bl);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (TimerDataControl)object;
        if (!bl) {
            return new JLabel("" + this.value.getTime() + " seg");
        }
        return this.createSpinner(jTable, bl);
    }

    private JPanel createSpinner(JTable jTable, boolean bl) {
        long l = this.value.getTime();
        long l2 = 1L;
        long l3 = 356400L;
        long l4 = 1L;
        JLabel jLabel = new JLabel("seg");
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(l, l2, l3, l4));
        jSpinner.addChangeListener(new TimeSpinnerListener());
        JPanel jPanel = new JPanel();
        jPanel.add(jSpinner);
        jPanel.add(jLabel);
        if (bl) {
            jPanel.setBackground(jTable.getSelectionBackground());
        }
        return jPanel;
    }

    private class TimeSpinnerListener
    implements ChangeListener {
        private TimeSpinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
            TimerTimeCellRendererEditor.this.value.setTime(spinnerNumberModel.getNumber().longValue());
        }
    }
}

