/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.timer;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.timer.TimerDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TimerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TimerDataControl timerDataControl;
    private JTextArea documentationTextArea;
    private JButton conditions2Button;
    private JTextField displayName;
    private JCheckBox countDown;
    private JCheckBox showWhenStopped;

    public TimerPanel(TimerDataControl timerDataControl) {
        this.timerDataControl = timerDataControl;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.documentationTextArea = new JTextArea(timerDataControl.getDocumentation(), 4, 0);
        this.documentationTextArea.setLineWrap(true);
        this.documentationTextArea.setWrapStyleWord(true);
        this.documentationTextArea.getDocument().addDocumentListener(new DocumentationTextAreaChangesListener());
        jPanel.add(new JScrollPane(this.documentationTextArea, 22, 31));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.Documentation")));
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.createTimePanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.createLoopControlPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        JButton jButton = new JButton(TC.get((String)"GeneralText.EditInitConditions"));
        jButton.addActionListener(new InitConditionsButtonListener());
        jPanel2.add(jButton);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.InitConditions")));
        this.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Timer.UsesEndCondition"));
        jCheckBox.setSelected(timerDataControl.isUsesEndCondition());
        jCheckBox.addChangeListener(new CheckBoxChangeListener(0));
        jPanel3.add(jCheckBox);
        this.conditions2Button = new JButton(TC.get((String)"GeneralText.EditEndConditions"));
        this.conditions2Button.addActionListener(new EndConditionsButtonListener());
        this.conditions2Button.setEnabled(timerDataControl.isUsesEndCondition());
        jPanel3.add(this.conditions2Button);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.EndConditions")));
        this.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout());
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.EditEffects"));
        jButton2.addActionListener(new EffectsButtonListener());
        jPanel5.add(jButton2);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.Effects")));
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout());
        JButton jButton3 = new JButton(TC.get((String)"GeneralText.EditPostEffects"));
        jButton3.addActionListener(new PostEffectsButtonListener());
        jPanel6.add(jButton3);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.PostEffects")));
        jPanel4.add(jPanel6);
        this.add((Component)jPanel4, gridBagConstraints);
    }

    private JPanel createTimePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(TC.get((String)"Timer.DisplayName"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.displayName = new JTextField(8);
        this.displayName.setText(this.timerDataControl.getDisplayName());
        this.displayName.setEnabled(this.timerDataControl.isShowTime());
        this.displayName.getDocument().addDocumentListener(new DisplayNameChangesListener());
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.displayName, gridBagConstraints);
        this.countDown = new JCheckBox(TC.get((String)"Timer.CountDown"));
        this.countDown.setSelected(this.timerDataControl.isCountDown());
        this.countDown.setEnabled(this.timerDataControl.isShowTime());
        this.countDown.addChangeListener(new CheckBoxChangeListener(4));
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.countDown, gridBagConstraints);
        this.showWhenStopped = new JCheckBox(TC.get((String)"Timer.ShowWhenStopped"));
        this.showWhenStopped.setSelected(this.timerDataControl.isShowWhenStopped());
        this.showWhenStopped.setEnabled(this.timerDataControl.isShowTime());
        this.showWhenStopped.addChangeListener(new CheckBoxChangeListener(5));
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.showWhenStopped, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.Time")));
        return jPanel;
    }

    private JPanel createLoopControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Timer.MultipleStarts"));
        jCheckBox.setSelected(this.timerDataControl.isMultipleStarts());
        jCheckBox.addChangeListener(new CheckBoxChangeListener(1));
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getBackground());
        Font font = jTextPane.getFont();
        font = font.deriveFont(10.0f);
        jTextPane.setFont(font);
        jTextPane.setText(TC.get((String)"Timer.MultipleStartsDesc"));
        jPanel.add((Component)jTextPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.1;
        JCheckBox jCheckBox2 = new JCheckBox(TC.get((String)"Timer.RunsInLoop"));
        jCheckBox2.setSelected(this.timerDataControl.isRunsInLoop());
        jCheckBox2.addChangeListener(new CheckBoxChangeListener(2));
        jPanel.add((Component)jCheckBox2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getBackground());
        jTextPane.setFont(font);
        jTextPane.setText(TC.get((String)"Timer.RunsInLoopDesc"));
        jPanel.add((Component)jTextPane, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Timer.LoopControl")));
        return jPanel;
    }

    private class CheckBoxChangeListener
    implements ChangeListener {
        public static final int USESENDCONDITION = 0;
        public static final int MULTIPLESTARTS = 1;
        public static final int RUNSINLOOP = 2;
        public static final int SHOW_TIME = 3;
        public static final int COUNTDOWN = 4;
        public static final int SHOWWHENSTOPPED = 5;
        private int type;

        public CheckBoxChangeListener(int n) {
            this.type = n;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = ((JCheckBox)changeEvent.getSource()).isSelected();
            if (this.type == 0) {
                TimerPanel.this.timerDataControl.setUsesEndCondition(bl);
                TimerPanel.this.conditions2Button.setEnabled(TimerPanel.this.timerDataControl.isUsesEndCondition());
            } else if (this.type == 1) {
                TimerPanel.this.timerDataControl.setMultipleStarts(bl);
            } else if (this.type == 2) {
                TimerPanel.this.timerDataControl.setRunsInLoop(bl);
            } else if (this.type == 3) {
                TimerPanel.this.timerDataControl.setShowTime(bl);
                if (TimerPanel.this.timerDataControl.isShowTime()) {
                    TimerPanel.this.displayName.setEnabled(true);
                    TimerPanel.this.countDown.setEnabled(true);
                    TimerPanel.this.showWhenStopped.setEnabled(true);
                } else {
                    TimerPanel.this.displayName.setEnabled(false);
                    TimerPanel.this.countDown.setEnabled(false);
                    TimerPanel.this.showWhenStopped.setEnabled(false);
                }
            } else if (this.type == 4) {
                TimerPanel.this.timerDataControl.setCountDown(bl);
            } else if (this.type == 5) {
                TimerPanel.this.timerDataControl.setShowWhenStopped(bl);
            }
        }
    }

    private class DisplayNameChangesListener
    implements DocumentListener {
        private DisplayNameChangesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TimerPanel.this.timerDataControl.setDisplayName(TimerPanel.this.displayName.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TimerPanel.this.timerDataControl.setDisplayName(TimerPanel.this.displayName.getText());
        }
    }

    private class DocumentationTextAreaChangesListener
    implements DocumentListener {
        private DocumentationTextAreaChangesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TimerPanel.this.timerDataControl.setDocumentation(TimerPanel.this.documentationTextArea.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TimerPanel.this.timerDataControl.setDocumentation(TimerPanel.this.documentationTextArea.getText());
        }
    }

    private class PostEffectsButtonListener
    implements ActionListener {
        private PostEffectsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EffectsDialog(TimerPanel.this.timerDataControl.getPostEffects());
        }
    }

    private class EffectsButtonListener
    implements ActionListener {
        private EffectsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EffectsDialog(TimerPanel.this.timerDataControl.getEffects());
        }
    }

    private class EndConditionsButtonListener
    implements ActionListener {
        private EndConditionsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(TimerPanel.this.timerDataControl.getEndConditions());
        }
    }

    private class InitConditionsButtonListener
    implements ActionListener {
        private InitConditionsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(TimerPanel.this.timerDataControl.getInitConditions());
        }
    }
}

