/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.scene.ChangeHasTrajectoryTool;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.TrajectoryEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TrajectoryPanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private ScenePreviewEditionPanel spep;
    private TrajectoryEditionPanel tep = null;
    private TrajectoryDataControl dataControl;
    private SceneDataControl sceneDataControl;
    private JRadioButton useTrajectoryRadioButton;
    private JRadioButton initialPositionRadioButton;
    private JPanel initialPositionPanel = null;
    private String scenePath;

    public TrajectoryPanel(TrajectoryDataControl trajectoryDataControl, SceneDataControl sceneDataControl) {
        this.dataControl = trajectoryDataControl;
        this.sceneDataControl = sceneDataControl;
        this.scenePath = Controller.getInstance().getSceneImagePath(sceneDataControl.getId());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2));
        this.useTrajectoryRadioButton = new JRadioButton(TC.get((String)"Scene.UseTrajectory"), sceneDataControl.getTrajectory().hasTrajectory());
        this.useTrajectoryRadioButton.addItemListener(new TrajectoryCheckBoxListener());
        jPanel.add(this.useTrajectoryRadioButton);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Scene.UseTrajectoryPanel")));
        this.initialPositionRadioButton = new JRadioButton(TC.get((String)"Scene.UseInitialPosition"), !sceneDataControl.getTrajectory().hasTrajectory());
        this.initialPositionRadioButton.addItemListener(new InitialPositionCheckBoxListener());
        jPanel.add(this.initialPositionRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useTrajectoryRadioButton);
        buttonGroup.add(this.initialPositionRadioButton);
        this.add((Component)jPanel, "North");
        this.changePanel();
    }

    private void changePanel() {
        if (this.useTrajectoryRadioButton.isSelected()) {
            if (this.tep != null) {
                this.remove(this.tep);
            }
            this.tep = new TrajectoryEditionPanel(this.scenePath, this.dataControl);
            this.spep = this.tep.getScenePreviewEditionPanel();
            this.fillSpep();
            this.add((Component)this.tep, "Center");
        } else {
            this.initialPositionPanel = new JPanel();
            this.initialPositionPanel.setLayout(new BorderLayout());
            this.spep = new ScenePreviewEditionPanel(false, this.scenePath);
            this.fillSpep();
            this.initialPositionPanel.add((Component)this.spep, "Center");
            this.spep.setShowTextEdition(true);
            if (this.initialPositionRadioButton.isSelected()) {
                Image image = AssetsController.getImage(Controller.getInstance().getPlayerImagePath());
                this.spep.addPlayer(this.sceneDataControl, image);
                this.spep.setSelectedElement(new ImageElementPlayer(image, this.sceneDataControl));
                this.spep.setFixedSelectedElement(true);
            }
            this.spep.repaint();
            this.add((Component)this.initialPositionPanel, "Center");
        }
    }

    private void fillSpep() {
        if (this.scenePath != null && this.spep != null) {
            for (ElementReferenceDataControl dataControl : this.sceneDataControl.getReferencesList().getItemReferences()) {
                this.spep.addElement(1, dataControl);
            }
            this.spep.setMovableCategory(1, false);
            for (ElementReferenceDataControl elementReferenceDataControl : this.sceneDataControl.getReferencesList().getNPCReferences()) {
                this.spep.addElement(2, elementReferenceDataControl);
            }
            this.spep.setMovableCategory(2, false);
            for (ElementReferenceDataControl elementReferenceDataControl : this.sceneDataControl.getReferencesList().getAtrezzoReferences()) {
                this.spep.addElement(3, elementReferenceDataControl);
            }
            this.spep.setMovableCategory(3, false);
            for (ExitDataControl exitDataControl : this.sceneDataControl.getExitsList().getExits()) {
                this.spep.addExit(exitDataControl);
            }
            this.spep.setMovableCategory(7, false);
            for (ActiveAreaDataControl activeAreaDataControl : this.sceneDataControl.getActiveAreasList().getActiveAreas()) {
                this.spep.addActiveArea(activeAreaDataControl);
            }
            this.spep.setMovableCategory(5, false);
            for (BarrierDataControl barrierDataControl : this.sceneDataControl.getBarriersList().getBarriers()) {
                this.spep.addBarrier(barrierDataControl);
            }
        }
    }

    private void updateContents() {
        this.dataControl = this.sceneDataControl.getTrajectory();
        if (this.initialPositionPanel != null) {
            this.remove(this.initialPositionPanel);
            this.initialPositionPanel = null;
        }
        if (this.tep != null) {
            this.remove(this.tep);
            this.tep = null;
        }
        this.changePanel();
        this.updateUI();
    }

    @Override
    public boolean updateFields() {
        this.changePanel();
        if (this.spep != null) {
            this.spep.updateUI();
            this.spep.repaint();
        }
        return true;
    }

    private class TrajectoryCheckBoxListener
    implements ItemListener {
        private TrajectoryCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Controller.getInstance().addTool(new ChangeHasTrajectoryTool(((JRadioButton)itemEvent.getSource()).isSelected(), TrajectoryPanel.this.sceneDataControl));
            TrajectoryPanel.this.updateContents();
        }
    }

    private class InitialPositionCheckBoxListener
    implements ItemListener {
        private InitialPositionCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            TrajectoryPanel.this.sceneDataControl.toggleDefaultInitialPosition();
            TrajectoryPanel.this.spep.setFixedSelectedElement(false);
            TrajectoryPanel.this.spep.setSelectedElement((ImageElement)null);
            TrajectoryPanel.this.spep.removeElements(6);
            Image image = AssetsController.getImage(Controller.getInstance().getPlayerImagePath());
            TrajectoryPanel.this.spep.addPlayer(TrajectoryPanel.this.sceneDataControl, image);
            TrajectoryPanel.this.spep.setSelectedElement(new ImageElementPlayer(image, TrajectoryPanel.this.sceneDataControl));
            TrajectoryPanel.this.spep.setFixedSelectedElement(true);
            TrajectoryPanel.this.spep.repaint();
        }
    }
}

