/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.ElementPanel;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ActiveAreasListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.scene.BarriersListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ExitsListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ReferencesListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.scene.SceneInfoPanel;
import es.eucm.eadventure.editor.gui.elementpanels.scene.SceneLooksPanel;
import es.eucm.eadventure.editor.gui.elementpanels.scene.TrajectoryPanel;
import javax.swing.JComponent;

public class ScenePanel
extends ElementPanel {
    private static final long serialVersionUID = 1L;

    public ScenePanel(SceneDataControl sceneDataControl) {
        this.addTab(new SceneLookPanelTab(sceneDataControl));
        this.addTab(new SceneDocPanelTab(sceneDataControl));
        this.addTab(new ItemsPanelTab(sceneDataControl));
        if (!Controller.getInstance().isPlayTransparent()) {
            this.addTab(new BarriersPanelTab(sceneDataControl));
        }
        this.addTab(new ActiveAreasPanelTab(sceneDataControl));
        this.addTab(new ExitsPanelTab(sceneDataControl));
        if (!Controller.getInstance().isPlayTransparent()) {
            this.addTab(new TrajectoryPanelTab(sceneDataControl));
        }
    }

    private class TrajectoryPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public TrajectoryPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"Trajectory.Title"), sceneDataControl.getTrajectory());
            this.setToolTipText(TC.get((String)"Trajectory.Title.ToolTip"));
            this.setHelpPath("scenes/Scene_Trajectory.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new TrajectoryPanel(this.sDataControl.getTrajectory(), this.sDataControl);
        }
    }

    private class ExitsPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public ExitsPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"ExitsList.Title"), sceneDataControl.getExitsList());
            this.setHelpPath("scenes/Scene_Exits.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ExitsListPanel(this.sDataControl.getExitsList());
        }
    }

    private class ActiveAreasPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public ActiveAreasPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"ActiveAreasList.Title"), sceneDataControl.getActiveAreasList());
            this.setToolTipText(TC.get((String)"ActiveAreasList.Information"));
            this.setHelpPath("scenes/Scene_ActiveAreas.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ActiveAreasListPanel(this.sDataControl.getActiveAreasList());
        }
    }

    private class BarriersPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public BarriersPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"BarriersList.Title"), sceneDataControl.getBarriersList());
            this.setHelpPath("scenes/Scene_Barriers.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new BarriersListPanel(this.sDataControl.getBarriersList());
        }
    }

    private class ItemsPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public ItemsPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"ItemReferencesList.Title"), sceneDataControl.getReferencesList());
            this.setHelpPath("scenes/Scene_References.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ReferencesListPanel(this.sDataControl.getReferencesList());
        }
    }

    private class SceneDocPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public SceneDocPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"Scene.DocPanelTitle"), sceneDataControl);
            this.setHelpPath("scenes/Scene_Documentation.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new SceneInfoPanel(this.sDataControl);
        }
    }

    private class SceneLookPanelTab
    extends PanelTab {
        private SceneDataControl sDataControl;

        public SceneLookPanelTab(SceneDataControl sceneDataControl) {
            super(TC.get((String)"Scene.LookPanelTitle"), sceneDataControl);
            this.setHelpPath("scenes/Scene_Appearence.html");
            this.sDataControl = sceneDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new SceneLooksPanel(this.sDataControl);
        }
    }
}

