/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.general.LooksPanel;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;

public class SceneLooksPanel
extends LooksPanel {
    private SceneDataControl sceneDataControl;
    private ScenePreviewEditionPanel scenePreviewEditionPanel;
    private static final long serialVersionUID = 1L;

    public SceneLooksPanel(SceneDataControl sceneDataControl) {
        super(sceneDataControl);
        this.lookPanel.setPreferredSize(new Dimension(0, 600));
    }

    @Override
    protected void createPreview() {
        this.sceneDataControl = (SceneDataControl)this.dataControl;
        String string = this.sceneDataControl.getPreviewBackground();
        this.scenePreviewEditionPanel = new ScenePreviewEditionPanel(false, string);
        this.scenePreviewEditionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Scene.Preview")));
        for (ElementReferenceDataControl dataControl : this.sceneDataControl.getReferencesList().getItemReferences()) {
            this.scenePreviewEditionPanel.addElement(1, dataControl);
        }
        for (ElementReferenceDataControl elementReferenceDataControl : this.sceneDataControl.getReferencesList().getNPCReferences()) {
            this.scenePreviewEditionPanel.addElement(2, elementReferenceDataControl);
        }
        for (ElementReferenceDataControl elementReferenceDataControl : this.sceneDataControl.getReferencesList().getAtrezzoReferences()) {
            this.scenePreviewEditionPanel.addElement(3, elementReferenceDataControl);
        }
        if (this.sceneDataControl.getTrajectory().hasTrajectory()) {
            this.scenePreviewEditionPanel.setTrajectory((Trajectory)this.sceneDataControl.getTrajectory().getContent());
            for (NodeDataControl nodeDataControl : this.sceneDataControl.getTrajectory().getNodes()) {
                this.scenePreviewEditionPanel.addNode(nodeDataControl);
            }
            this.scenePreviewEditionPanel.setShowInfluenceArea(true);
        } else if (!Controller.getInstance().isPlayTransparent()) {
            this.scenePreviewEditionPanel.addPlayer(this.sceneDataControl, AssetsController.getImage(Controller.getInstance().getPlayerImagePath()));
        }
        this.scenePreviewEditionPanel.setMovableCategory(1, false);
        this.scenePreviewEditionPanel.setMovableCategory(2, false);
        this.scenePreviewEditionPanel.setMovableCategory(3, false);
        this.scenePreviewEditionPanel.setMovableCategory(6, false);
        this.lookPanel.add((Component)this.scenePreviewEditionPanel, this.cLook);
    }

    public void addPlayer() {
        if (!Controller.getInstance().isPlayTransparent()) {
            this.scenePreviewEditionPanel.addPlayer(this.sceneDataControl, this.sceneDataControl.getReferencesList().getPlayerImage());
        }
        this.scenePreviewEditionPanel.repaint();
    }

    @Override
    public void updatePreview() {
        if (this.scenePreviewEditionPanel != null) {
            System.out.println(this.sceneDataControl.getPreviewBackground());
            this.scenePreviewEditionPanel.loadBackground(this.sceneDataControl.getPreviewBackground());
            System.out.println("BG UPDATED!!");
        }
        if (this.getParent() != null && this.getParent().getParent() != null) {
            this.getParent().getParent().repaint();
        }
    }

    @Override
    public void updateResources() {
        super.updateResources();
        if (this.getParent() != null && this.getParent().getParent() != null) {
            this.getParent().getParent().repaint();
        }
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }
}

