/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ElementContainer;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ReferencesListDataControl;
import es.eucm.eadventure.editor.control.tools.general.MovePlayerLayerInTableTool;
import es.eucm.eadventure.editor.control.tools.scene.AddReferenceTool;
import es.eucm.eadventure.editor.control.tools.scene.DeleteReferenceTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ElementReferencesTable;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.table.AbstractTableModel;

public class ReferencesListPanel
extends JPanel
implements DataControlsPanel,
Updateable {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_SPLIT_POSITION = 140;
    private JPanel tablePanel;
    private ElementReferencesTable table;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private ScenePreviewEditionPanel spep;
    private JSplitPane tableWithSplit;
    BasicSplitPaneDivider horizontalDivider;
    BasicSplitPaneDivider verticalDivider;
    private ReferencesListDataControl referencesListDataControl;
    private JCheckBox isAllowPlayerLayer;

    public ReferencesListPanel(ReferencesListDataControl referencesListDataControl) {
        this.referencesListDataControl = referencesListDataControl;
        String string = Controller.getInstance().getSceneImagePath(referencesListDataControl.getParentSceneId());
        this.spep = new ScenePreviewEditionPanel(true, string);
        this.spep.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"ItemReferencesList.PreviewTitle")));
        if (string != null) {
            for (ElementReferenceDataControl dataControl : referencesListDataControl.getItemReferences()) {
                this.spep.addElement(1, dataControl);
            }
            for (ElementReferenceDataControl elementReferenceDataControl : referencesListDataControl.getAtrezzoReferences()) {
                this.spep.addElement(3, elementReferenceDataControl);
            }
            for (ElementReferenceDataControl elementReferenceDataControl : referencesListDataControl.getNPCReferences()) {
                this.spep.addElement(2, elementReferenceDataControl);
            }
            if (referencesListDataControl.getSceneDataControl().getTrajectory().hasTrajectory()) {
                this.spep.setTrajectory((Trajectory)referencesListDataControl.getSceneDataControl().getTrajectory().getContent());
                for (NodeDataControl nodeDataControl : referencesListDataControl.getSceneDataControl().getTrajectory().getNodes()) {
                    this.spep.addNode(nodeDataControl);
                }
                this.spep.setShowInfluenceArea(true);
            } else if (!Controller.getInstance().isPlayTransparent()) {
                this.spep.addPlayer(referencesListDataControl.getSceneDataControl(), referencesListDataControl.getPlayerImage());
            }
        }
        this.createReferencesTablePanel();
        this.spep.setElementReferenceSelectionListener(this.table);
        this.spep.setShowTextEdition(true);
        if (referencesListDataControl.getSceneDataControl().getTrajectory().hasTrajectory()) {
            this.spep.setTrajectory((Trajectory)referencesListDataControl.getSceneDataControl().getTrajectory().getContent());
            for (NodeDataControl nodeDataControl : referencesListDataControl.getSceneDataControl().getTrajectory().getNodes()) {
                this.spep.addNode(nodeDataControl);
            }
            this.spep.setShowInfluenceArea(true);
        }
        this.tableWithSplit = new JSplitPane(0, this.tablePanel, this.spep);
        this.tableWithSplit.setOneTouchExpandable(true);
        this.tableWithSplit.setDividerLocation(140);
        this.tableWithSplit.setContinuousLayout(true);
        this.tableWithSplit.setResizeWeight(0.5);
        this.tableWithSplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tableWithSplit, "Center");
    }

    private void updateSelectedElementReference() {
        if (this.table.getSelectedRow() < 0 || this.table.getSelectedRow() >= this.referencesListDataControl.getAllReferencesDataControl().size()) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setBackground(this.getBackground());
            jTextPane.setText(TC.get((String)"ElementList.Empty"));
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            int n = this.table.getSelectedRow();
            ElementContainer elementContainer = this.referencesListDataControl.getAllReferencesDataControl().get(n);
            if (elementContainer.isPlayer() && !this.referencesListDataControl.getSceneDataControl().getTrajectory().hasTrajectory() || !elementContainer.isPlayer()) {
                this.referencesListDataControl.setLastElementContainer(elementContainer);
                this.spep.setSelectedElement(elementContainer.getErdc(), elementContainer.getImage(), this.referencesListDataControl.getSceneDataControl());
                if (elementContainer.isPlayer()) {
                    this.deleteButton.setEnabled(false);
                } else {
                    this.deleteButton.setEnabled(true);
                }
                this.moveUpButton.setEnabled(this.referencesListDataControl.getAllReferencesDataControl().size() > 1 && n > 0);
                this.moveDownButton.setEnabled(this.referencesListDataControl.getAllReferencesDataControl().size() > 1 && n < this.table.getRowCount() - 1);
            }
        }
        this.updateUI();
        this.spep.repaint();
    }

    private void createReferencesTablePanel() {
        this.tablePanel = new JPanel(new BorderLayout());
        this.isAllowPlayerLayer = new JCheckBox(TC.get((String)"Scene.AllowPlayer"), this.referencesListDataControl.getSceneDataControl().isAllowPlayer());
        this.isAllowPlayerLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.referencesListDataControl.getSceneDataControl().changeAllowPlayerLayer(((JCheckBox)actionEvent.getSource()).isSelected(), ReferencesListPanel.this.spep);
            }
        });
        if (!Controller.getInstance().isPlayTransparent()) {
            this.tablePanel.add((Component)this.isAllowPlayerLayer, "South");
        }
        this.table = new ElementReferencesTable(this.referencesListDataControl, this.spep);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), 16, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    for (MouseListener mouseListener : mouseEvent.getComponent().getMouseListeners()) {
                        mouseListener.mousePressed(mouseEvent2);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    JPopupMenu jPopupMenu = ReferencesListPanel.this.getCompletePopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.tablePanel.add((Component)new TableScrollPane(this.table, 22, 31), "Center");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ReferencesListPanel.this.updateSelectedElementReference();
            }
        });
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"ItemReferenceTable.AddParagraph"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = ReferencesListPanel.this.getAddChildPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"ItemReferenceTable.Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.delete();
            }
        });
        this.deleteButton.setEnabled(false);
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.moveUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.moveDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.moveUpButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.moveDownButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        --gridBagConstraints.gridy;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.tablePanel.add((Component)jPanel, "East");
    }

    private void delete() {
        Controller.getInstance().addTool(new DeleteReferenceTool(this.referencesListDataControl, this.table, this.spep));
    }

    private void moveUp() {
        Controller.getInstance().addTool(new MovePlayerLayerInTableTool(this.referencesListDataControl, this.table, true));
    }

    private void moveDown() {
        Controller.getInstance().addTool(new MovePlayerLayerInTableTool(this.referencesListDataControl, this.table, false));
    }

    public JPopupMenu getAddChildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.referencesListDataControl.getAddableElements().length > 0) {
            for (int n : this.referencesListDataControl.getAddableElements()) {
                JMenuItem jMenuItem = new JMenuItem(TC.get((String)("TreeNode.AddElement" + n)));
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new AddElementReferenceActionListener(n));
                jPopupMenu.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(TC.get((String)"TreeNode.AddElement"));
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public JPopupMenu getCompletePopupMenu() {
        JPopupMenu jPopupMenu = this.getAddChildPopupMenu();
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(TC.get((String)"TreeNode.DeleteElement"));
        jMenuItem.setEnabled(this.deleteButton.isEnabled());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.delete();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(TC.get((String)"TreeNode.MoveElementUp"));
        JMenuItem jMenuItem3 = new JMenuItem(TC.get((String)"TreeNode.MoveElementDown"));
        jMenuItem2.setEnabled(this.moveUpButton.isEnabled());
        jMenuItem3.setEnabled(this.moveDownButton.isEnabled());
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.moveUp();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesListPanel.this.moveDown();
            }
        });
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.referencesListDataControl.getAllReferencesDataControl().size(); ++i) {
                if (this.referencesListDataControl.getAllReferencesDataControl().get(i).getErdc() != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public boolean updateFields() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (this.isAllowPlayerLayer != null) {
            this.isAllowPlayerLayer.setSelected(this.referencesListDataControl.getSceneDataControl().isAllowPlayer());
        }
        if (n2 == this.table.getRowCount()) {
            if (n != -1) {
                this.table.changeSelection(n, 0, false, false);
                if (this.table.getEditorComponent() != null) {
                    this.table.editCellAt(n, this.table.getEditingColumn());
                }
            }
        } else {
            this.spep.setSelectedElement((ImageElement)null);
        }
        this.spep.repaint();
        return true;
    }

    private class AddElementReferenceActionListener
    implements ActionListener {
        int type;

        public AddElementReferenceActionListener(int n) {
            this.type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Controller.getInstance().addTool(new AddReferenceTool(ReferencesListPanel.this.referencesListDataControl, this.type, ReferencesListPanel.this.spep, ReferencesListPanel.this.table));
        }
    }
}

