/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ExitsListDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.AuxEditCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ExitLooksCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.InfoHeaderRenderer;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.NextSceneCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.TransitionCellRendererEditor;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ExitsTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected ExitsListDataControl dataControl;
    protected IrregularAreaEditionPanel iaep;
    protected ScenePreviewEditionPanel spep;

    public ExitsTable(ExitsListDataControl exitsListDataControl, IrregularAreaEditionPanel irregularAreaEditionPanel, JSplitPane jSplitPane) {
        this.spep = irregularAreaEditionPanel.getScenePreviewEditionPanel();
        this.iaep = irregularAreaEditionPanel;
        this.dataControl = exitsListDataControl;
        this.setModel(new ElementsTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.setColumnSelectionAllowed(false);
        Object[] objectArray = Controller.getInstance().getIdentifierSummary().getGeneralSceneIds();
        this.getColumnModel().getColumn(0).setCellRenderer(new NextSceneCellRendererEditor(objectArray));
        this.getColumnModel().getColumn(0).setCellEditor(new NextSceneCellRendererEditor(objectArray));
        this.getColumnModel().getColumn(0).setMinWidth(140);
        this.getColumnModel().getColumn(1).setCellRenderer(new TransitionCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellEditor(new TransitionCellRendererEditor());
        this.getColumnModel().getColumn(1).setMaxWidth(110);
        this.getColumnModel().getColumn(1).setMinWidth(110);
        this.getColumnModel().getColumn(2).setCellRenderer(new ExitLooksCellRendererEditor());
        this.getColumnModel().getColumn(2).setCellEditor(new ExitLooksCellRendererEditor());
        this.getColumnModel().getColumn(2).setMinWidth(160);
        String string = TC.get((String)"ExitsList.Edit");
        this.getColumnModel().getColumn(3).setCellRenderer(new AuxEditCellRendererEditor(jSplitPane, 150, string));
        this.getColumnModel().getColumn(3).setCellEditor(new AuxEditCellRendererEditor(jSplitPane, 150, string));
        this.getColumnModel().getColumn(3).setMaxWidth(130);
        this.getColumnModel().getColumn(3).setMinWidth(130);
        this.getColumnModel().getColumn(0).setHeaderRenderer(new InfoHeaderRenderer("scenes/Scene_NextScene.html"));
        this.getColumnModel().getColumn(1).setHeaderRenderer(new InfoHeaderRenderer("scenes/Scene_Transition.html"));
        this.getColumnModel().getColumn(2).setHeaderRenderer(new InfoHeaderRenderer("scenes/Scene_ExitAppearence.html"));
        this.getColumnModel().getColumn(3).setHeaderRenderer(new InfoHeaderRenderer());
        this.setRowHeight(25);
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExitsTable.this.setRowHeight(25);
                if (ExitsTable.this.getSelectedRow() != -1) {
                    ExitsTable.this.setRowHeight(ExitsTable.this.getSelectedRow(), 70);
                }
            }
        });
        this.setSize(200, 150);
    }

    private class ElementsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ElementsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ExitsTable.this.dataControl.getExits().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ExitsTable.this.dataControl.getExits().get(n);
            }
            if (n2 == 1) {
                return ExitsTable.this.dataControl.getExits().get(n);
            }
            if (n2 == 2) {
                return ExitsTable.this.dataControl.getExits().get(n).getExitLookDataControl();
            }
            if (n2 == 3) {
                return ExitsTable.this.dataControl.getExits().get(n).getConditions();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"ExitsList.NextScene");
            }
            if (n == 1) {
                return TC.get((String)"ExitsList.Transition");
            }
            if (n == 2) {
                return TC.get((String)"ExitsList.Appearance");
            }
            if (n == 3) {
                return TC.get((String)"ExitsList.ConditionsAndEffects");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return ExitsTable.this.getSelectedRow() == n;
        }
    }
}

