/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitsListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.tools.scene.AddExitTool;
import es.eucm.eadventure.editor.control.tools.scene.DeleteExitTool;
import es.eucm.eadventure.editor.control.tools.scene.DuplicateExitTool;
import es.eucm.eadventure.editor.control.tools.scene.MoveExitTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import es.eucm.eadventure.editor.gui.elementpanels.DataControlSelectionListener;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ExitsTable;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ExitsListPanel
extends JPanel
implements DataControlsPanel,
DataControlSelectionListener,
Updateable {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_SPLIT_POSITION = 140;
    public static final int VERTICAL_SPLIT_POSITION = 150;
    private ExitsListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private ExitsTable table;
    private JPanel auxPanel;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton duplicateButton;
    private JSplitPane previewAuxSplit;

    public ExitsListPanel(ExitsListDataControl exitsListDataControl) {
        this.dataControl = exitsListDataControl;
        String string = Controller.getInstance().getSceneImagePath(exitsListDataControl.getParentSceneId());
        this.iaep = new IrregularAreaEditionPanel(string, null, this.dataControl.getSceneDataControl().getTrajectory().hasTrajectory(), Color.RED);
        ScenePreviewEditionPanel scenePreviewEditionPanel = this.iaep.getScenePreviewEditionPanel();
        if (this.dataControl.getSceneDataControl().getTrajectory().hasTrajectory()) {
            scenePreviewEditionPanel.setTrajectory((Trajectory)this.dataControl.getSceneDataControl().getTrajectory().getContent());
            for (NodeDataControl object2 : this.dataControl.getSceneDataControl().getTrajectory().getNodes()) {
                scenePreviewEditionPanel.addNode(object2);
            }
            scenePreviewEditionPanel.setShowInfluenceArea(true);
        }
        this.setLayout(new BorderLayout());
        this.auxPanel = new JPanel();
        this.auxPanel.setMaximumSize(new Dimension(150, Integer.MAX_VALUE));
        this.auxPanel.setMinimumSize(new Dimension(150, 0));
        this.previewAuxSplit = new JSplitPane(1, this.iaep, this.auxPanel);
        this.previewAuxSplit.setDividerSize(10);
        this.previewAuxSplit.setContinuousLayout(true);
        this.previewAuxSplit.setOneTouchExpandable(true);
        this.previewAuxSplit.setResizeWeight(1.0);
        this.previewAuxSplit.setDividerLocation(Integer.MAX_VALUE);
        JPanel jPanel = this.createTablePanel(this.iaep, this.previewAuxSplit);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.previewAuxSplit);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(140);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerSize(10);
        this.add((Component)jSplitPane, "Center");
        this.addElementsToPreview(scenePreviewEditionPanel, string);
    }

    private JPanel createTablePanel(IrregularAreaEditionPanel irregularAreaEditionPanel, JSplitPane jSplitPane) {
        JPanel jPanel = new JPanel();
        this.table = new ExitsTable(this.dataControl, this.iaep, this.previewAuxSplit);
        TableScrollPane tableScrollPane = new TableScrollPane(this.table, 22, 31);
        tableScrollPane.setMinimumSize(new Dimension(0, 140));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ExitsListPanel.this.table.getSelectedRow() >= 0) {
                    ExitsListPanel.this.deleteButton.setEnabled(true);
                    ExitsListPanel.this.duplicateButton.setEnabled(true);
                    ExitsListPanel.this.moveUpButton.setEnabled(ExitsListPanel.this.dataControl.getExits().size() > 1 && ExitsListPanel.this.table.getSelectedRow() > 0);
                    ExitsListPanel.this.moveDownButton.setEnabled(ExitsListPanel.this.dataControl.getExits().size() > 1 && ExitsListPanel.this.table.getSelectedRow() < ExitsListPanel.this.table.getRowCount() - 1);
                    ExitsListPanel.this.iaep.setRectangular(ExitsListPanel.this.dataControl.getExits().get(ExitsListPanel.this.table.getSelectedRow()));
                    ExitsListPanel.this.iaep.repaint();
                } else {
                    ExitsListPanel.this.deleteButton.setEnabled(false);
                    ExitsListPanel.this.duplicateButton.setEnabled(false);
                    ExitsListPanel.this.moveUpButton.setEnabled(false);
                    ExitsListPanel.this.moveDownButton.setEnabled(false);
                }
                ExitsListPanel.this.updateAuxPanel();
                ExitsListPanel.this.deleteButton.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setFocusable(false);
        jButton.setToolTipText(TC.get((String)"ExitsList.AddExit"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitsListPanel.this.addExit();
            }
        });
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"ExitsList.DuplicateExit"));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.setFocusable(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitsListPanel.this.duplicateExit();
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"ExitsList.DeleteExit"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitsListPanel.this.deleteExit();
            }
        });
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"ExitList.MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitsListPanel.this.moveUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"ExitList.MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitsListPanel.this.moveDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.duplicateButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.moveUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 2.0;
        jPanel2.add((Component)new JFiller(), gridBagConstraints);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)tableScrollPane, "Center");
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private void addElementsToPreview(ScenePreviewEditionPanel scenePreviewEditionPanel, String string) {
        if (string != null) {
            for (ElementReferenceDataControl dataControl : this.dataControl.getParentSceneItemReferences()) {
                scenePreviewEditionPanel.addElement(1, dataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(1, false);
            for (ElementReferenceDataControl elementReferenceDataControl : this.dataControl.getParentSceneNPCReferences()) {
                scenePreviewEditionPanel.addElement(2, elementReferenceDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(2, false);
            for (ElementReferenceDataControl elementReferenceDataControl : this.dataControl.getParentSceneAtrezzoReferences()) {
                scenePreviewEditionPanel.addElement(3, elementReferenceDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(3, false);
            for (BarrierDataControl barrierDataControl : this.dataControl.getParentSceneBarriers()) {
                scenePreviewEditionPanel.addBarrier(barrierDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(4, false);
            for (ActiveAreaDataControl activeAreaDataControl : this.dataControl.getParentSceneActiveAreas()) {
                scenePreviewEditionPanel.addActiveArea(activeAreaDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(5, false);
            for (ExitDataControl exitDataControl : this.dataControl.getExits()) {
                scenePreviewEditionPanel.addExit(exitDataControl);
            }
            scenePreviewEditionPanel.changeController(new NormalScenePreviewEditionController(scenePreviewEditionPanel));
            scenePreviewEditionPanel.setDataControlSelectionListener(this);
            scenePreviewEditionPanel.setMovableCategory(7, true);
        }
    }

    protected void addExit() {
        Controller.getInstance().addTool(new AddExitTool(this.dataControl, this.iaep));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getExits().size() - 1, this.dataControl.getExits().size() - 1, false, false);
    }

    protected void duplicateExit() {
        Controller.getInstance().addTool(new DuplicateExitTool(this.dataControl, this.iaep, this.table.getSelectedRow()));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getExits().size() - 1, this.dataControl.getExits().size() - 1, false, false);
    }

    protected void deleteExit() {
        Controller.getInstance().addTool(new DeleteExitTool(this.dataControl, this.table, this.iaep));
    }

    private void moveUp() {
        Controller.getInstance().addTool(new MoveExitTool(this.dataControl, this.table, true));
    }

    private void moveDown() {
        Controller.getInstance().addTool(new MoveExitTool(this.dataControl, this.table, false));
    }

    protected void updateAuxPanel() {
        if (this.auxPanel == null) {
            return;
        }
        this.auxPanel.removeAll();
        if (this.table.getSelectedRow() == -1) {
            this.previewAuxSplit.setDividerLocation(Integer.MAX_VALUE);
            return;
        }
        this.auxPanel.setLayout(new GridBagLayout());
        final ExitDataControl exitDataControl = this.dataControl.getExits().get(this.table.getSelectedRow());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JButton jButton = new JButton(TC.get((String)"Exit.EditConditions"));
        jButton.addActionListener(new EditConditionsListener(exitDataControl));
        this.auxPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.auxPanel.add((Component)new JLabel(TC.get((String)"Exit.ConditionsActive")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        JButton jButton2 = new JButton(TC.get((String)"Exit.EditEffects"));
        jButton2.addActionListener(new EditEffectsListener(exitDataControl.getEffects()));
        this.auxPanel.add((Component)jButton2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JButton jButton3 = new JButton(TC.get((String)"Exit.EditPostEffects"));
        jButton3.addActionListener(new EditEffectsListener(exitDataControl.getPostEffects()));
        this.auxPanel.add((Component)jButton3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.auxPanel.add((Component)new JLabel(TC.get((String)"Exit.ConditionsInactive")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        final JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Exit.ActiveWhenConditionsArent"));
        jCheckBox.setToolTipText(TC.get((String)"Exit.ActiveWhenConditionsArent.ToolTip"));
        jCheckBox.setSelected(exitDataControl.isHasNotEffects());
        this.auxPanel.add((Component)jCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        final JButton jButton4 = new JButton(TC.get((String)"Exit.EditNotEffects"));
        jButton4.setEnabled(exitDataControl.isHasNotEffects());
        jButton4.addActionListener(new EditEffectsListener(exitDataControl.getNotEffects()));
        this.auxPanel.add((Component)jButton4, gridBagConstraints);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                exitDataControl.setHasNotEffects(jCheckBox.isSelected());
                jButton4.setEnabled(jCheckBox.isSelected());
            }
        });
        this.previewAuxSplit.setDividerLocation(Integer.MAX_VALUE);
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getExits().size(); ++i) {
                if (this.dataControl.getExits().get(i) != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public void dataControlSelected(DataControl dataControl) {
        if (dataControl != null) {
            for (int i = 0; i < this.dataControl.getExits().size(); ++i) {
                if (this.dataControl.getExits().get(i) != dataControl) continue;
                this.table.changeSelection(i, i, false, false);
            }
        } else {
            this.table.clearSelection();
        }
    }

    @Override
    public boolean updateFields() {
        final int n = this.previewAuxSplit.getDividerLocation();
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getRowCount();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n3 > 0 && n3 == this.dataControl.getExits().size() && n2 != -1 && n2 < this.table.getRowCount()) {
            this.table.changeSelection(n2, 0, false, false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExitsListPanel.this.previewAuxSplit.setDividerLocation(n);
                }
            });
        }
        this.iaep.repaint();
        return true;
    }

    private class EditConditionsListener
    implements ActionListener {
        private ExitDataControl exit;

        public EditConditionsListener(ExitDataControl exitDataControl) {
            this.exit = exitDataControl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(this.exit.getConditions());
        }
    }

    private class EditEffectsListener
    implements ActionListener {
        private EffectsController effects;

        public EditEffectsListener(EffectsController effectsController) {
            this.effects = effectsController;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EffectsDialog(this.effects);
        }
    }
}

