/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.scene.ElementContainer;
import es.eucm.eadventure.editor.control.controllers.scene.ReferencesListDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.book.IconTextPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ConditionsCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.InfoHeaderRenderer;
import es.eucm.eadventure.editor.gui.otherpanels.ElementReferenceSelectionListener;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ElementReferencesTable
extends JTable
implements ElementReferenceSelectionListener {
    private static final long serialVersionUID = 1L;
    private ReferencesListDataControl dataControl;
    private ScenePreviewEditionPanel spep;

    public ElementReferencesTable(ReferencesListDataControl referencesListDataControl, ScenePreviewEditionPanel scenePreviewEditionPanel) {
        this.spep = scenePreviewEditionPanel;
        this.setModel(new ElementsTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.getColumnModel().getColumn(0).setHeaderRenderer(new InfoHeaderRenderer());
        this.getColumnModel().getColumn(1).setHeaderRenderer(new InfoHeaderRenderer());
        this.getColumnModel().getColumn(2).setHeaderRenderer(new InfoHeaderRenderer());
        this.getColumnModel().getColumn(3).setHeaderRenderer(new InfoHeaderRenderer("general/Conditions.html"));
        this.setDragEnabled(false);
        this.getColumnModel().getColumn(0).setMaxWidth(55);
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setMaxWidth(30);
        tableColumn.setCellEditor(this.getDefaultEditor(Boolean.class));
        tableColumn.setCellRenderer(this.getDefaultRenderer(Boolean.class));
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    List<ElementContainer> list = ElementReferencesTable.this.dataControl.getAllReferencesDataControl();
                    if (n2 == 1) {
                        list.get(n).setVisible((Boolean)ElementReferencesTable.this.getModel().getValueAt(n, n2));
                        ElementReferencesTable.this.spep.repaint();
                    }
                }
            }
        });
        this.getColumnModel().getColumn(2).setCellRenderer(new ElementsReferencesTableCellRenderer());
        this.getColumnModel().getColumn(3).setCellRenderer(new ConditionsCellRendererEditor());
        this.getColumnModel().getColumn(3).setCellEditor(new ConditionsCellRendererEditor());
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(18);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ElementReferencesTable.this.setRowHeight(18);
                if (ElementReferencesTable.this.getSelectedRow() != -1) {
                    ElementReferencesTable.this.setRowHeight(ElementReferencesTable.this.getSelectedRow(), 24);
                }
            }
        });
        this.dataControl = referencesListDataControl;
        this.setSize(200, 150);
    }

    @Override
    public void elementReferenceSelected(int n) {
        if (n != -1) {
            this.changeSelection(n, 1, false, false);
        } else {
            this.clearSelection();
        }
    }

    private class ElementsReferencesTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ElementsReferencesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof ElementContainer) {
                if (((ElementContainer)object).isPlayer()) {
                    String string = "player";
                    return new IconTextPanel("img/icons/npc.png", string, bl);
                }
                String string = ((ElementContainer)object).getErdc().getElementId();
                if (((ElementContainer)object).getErdc().getType() == 6) {
                    return new IconTextPanel("img/icons/item.png", string, bl);
                }
                if (((ElementContainer)object).getErdc().getType() == 60) {
                    return new IconTextPanel("img/icons/Atrezzo-1.png", string, bl);
                }
                if (((ElementContainer)object).getErdc().getType() == 8) {
                    return new IconTextPanel("img/icons/npc.png", string, bl);
                }
                return null;
            }
            if (object != null) {
                return new JLabel(object.toString());
            }
            return new JLabel();
        }
    }

    private class ElementsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ElementsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ElementReferencesTable.this.dataControl.getAllReferencesDataControl().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return Integer.toString(n);
            }
            List<ElementContainer> list = ElementReferencesTable.this.dataControl.getAllReferencesDataControl();
            if (n2 == 1) {
                return new Boolean(list.get(n).isVisible());
            }
            if (n2 == 2) {
                return list.get(n);
            }
            if (n2 == 3 && !list.get(n).isPlayer()) {
                return list.get(n).getErdc().getConditions();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"ElementList.Layer");
            }
            if (n == 2) {
                return TC.get((String)"ElementList.Title");
            }
            if (n == 3) {
                return TC.get((String)"ElementList.Conditions");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                Boolean bl = (Boolean)object;
                List<ElementContainer> list = ElementReferencesTable.this.dataControl.getAllReferencesDataControl();
                list.get(n).setVisible(bl);
                ElementReferencesTable.this.spep.repaint();
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n == ElementReferencesTable.this.getSelectedRow() && (n2 == 1 || n2 == 3);
        }
    }
}

