/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarriersListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.tools.scene.AddBarrierTool;
import es.eucm.eadventure.editor.control.tools.scene.DeleteBarrierTool;
import es.eucm.eadventure.editor.control.tools.scene.DuplicateBarrierTool;
import es.eucm.eadventure.editor.control.tools.scene.MoveBarrierTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.DataControlSelectionListener;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.scene.BarriersTable;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class BarriersListPanel
extends JPanel
implements Updateable,
DataControlsPanel,
DataControlSelectionListener {
    private static final long serialVersionUID = 1L;
    private ScenePreviewEditionPanel spep;
    private BarriersListDataControl dataControl;
    private JTable table;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private static final int HORIZONTAL_SPLIT_POSITION = 140;

    public BarriersListPanel(BarriersListDataControl barriersListDataControl) {
        this.dataControl = barriersListDataControl;
        String string = Controller.getInstance().getSceneImagePath(barriersListDataControl.getParentSceneId());
        this.spep = new ScenePreviewEditionPanel(false, string);
        this.setRectangular();
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createTablePanel();
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.spep);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(140);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerSize(10);
        this.add((Component)jSplitPane, "Center");
        this.spep.setDataControlSelectionListener(this);
        this.addElementsToPreview(string);
    }

    public void setRectangular() {
        this.spep.changeController(new NormalScenePreviewEditionController(this.spep));
        this.spep.setShowTextEdition(true);
        this.spep.setMovableCategory(9, false);
        this.spep.removeElements(9);
        this.updateUI();
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel();
        this.table = new BarriersTable(this.dataControl);
        TableScrollPane tableScrollPane = new TableScrollPane(this.table, 22, 31);
        tableScrollPane.setMinimumSize(new Dimension(0, 140));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (BarriersListPanel.this.table.getSelectedRow() >= 0 && BarriersListPanel.this.table.getSelectedRow() < BarriersListPanel.this.dataControl.getBarriers().size()) {
                    BarriersListPanel.this.deleteButton.setEnabled(true);
                    BarriersListPanel.this.duplicateButton.setEnabled(true);
                    BarriersListPanel.this.moveUpButton.setEnabled(BarriersListPanel.this.dataControl.getBarriers().size() > 1 && BarriersListPanel.this.table.getSelectedRow() > 0);
                    BarriersListPanel.this.moveDownButton.setEnabled(BarriersListPanel.this.dataControl.getBarriers().size() > 1 && BarriersListPanel.this.table.getSelectedRow() < BarriersListPanel.this.table.getRowCount() - 1);
                    BarriersListPanel.this.spep.setSelectedElement(BarriersListPanel.this.dataControl.getBarriers().get(BarriersListPanel.this.table.getSelectedRow()));
                    BarriersListPanel.this.spep.repaint();
                } else {
                    BarriersListPanel.this.deleteButton.setEnabled(false);
                    BarriersListPanel.this.duplicateButton.setEnabled(false);
                    BarriersListPanel.this.moveUpButton.setEnabled(false);
                    BarriersListPanel.this.moveDownButton.setEnabled(false);
                }
                BarriersListPanel.this.deleteButton.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"BarriersList.AddBarrier"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarriersListPanel.this.addBarrier();
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"BarriersList.DeleteBarrier"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarriersListPanel.this.deleteBarrier();
            }
        });
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"BarriersList.DuplicateBarrier"));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarriersListPanel.this.duplicateBarrier();
            }
        });
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"BarrierList.MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarriersListPanel.this.moveUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"BarrierList.MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarriersListPanel.this.moveDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.duplicateButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.moveUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 2.0;
        jPanel2.add((Component)new JFiller(), gridBagConstraints);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)tableScrollPane, "Center");
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private void addElementsToPreview(String string) {
        this.spep.setMovableCategory(4, true);
        if (string != null) {
            for (ElementReferenceDataControl dataControl : this.dataControl.getParentSceneItemReferences()) {
                this.spep.addElement(1, dataControl);
            }
            this.spep.setMovableCategory(1, false);
            for (ElementReferenceDataControl elementReferenceDataControl : this.dataControl.getParentSceneNPCReferences()) {
                this.spep.addElement(2, elementReferenceDataControl);
            }
            this.spep.setMovableCategory(2, false);
            for (ElementReferenceDataControl elementReferenceDataControl : this.dataControl.getParentSceneAtrezzoReferences()) {
                this.spep.addElement(3, elementReferenceDataControl);
            }
            this.spep.setMovableCategory(3, false);
            for (ExitDataControl exitDataControl : this.dataControl.getParentSceneExits()) {
                this.spep.addExit(exitDataControl);
            }
            this.spep.setMovableCategory(7, false);
            for (ActiveAreaDataControl activeAreaDataControl : this.dataControl.getParentSceneActiveAreas()) {
                this.spep.addActiveArea(activeAreaDataControl);
            }
            this.spep.setMovableCategory(5, false);
            for (BarrierDataControl barrierDataControl : this.dataControl.getBarriers()) {
                this.spep.addBarrier(barrierDataControl);
            }
            if (this.dataControl.getParentSceneTrajectory().hasTrajectory()) {
                this.spep.setTrajectory((Trajectory)this.dataControl.getParentSceneTrajectory().getContent());
                for (NodeDataControl nodeDataControl : this.dataControl.getParentSceneTrajectory().getNodes()) {
                    this.spep.addNode(nodeDataControl);
                }
            }
        }
    }

    protected void addBarrier() {
        String string = this.dataControl.getDefaultId();
        Controller.getInstance().addTool(new AddBarrierTool(this.dataControl, string, this.spep));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getBarriers().size() - 1, this.dataControl.getBarriers().size() - 1, false, false);
    }

    protected void duplicateBarrier() {
        Controller.getInstance().addTool(new DuplicateBarrierTool(this.dataControl, this.spep, this.table));
    }

    protected void deleteBarrier() {
        Controller.getInstance().addTool(new DeleteBarrierTool(this.dataControl, this.table, this.spep));
    }

    private void moveUp() {
        Controller.getInstance().addTool(new MoveBarrierTool(this.dataControl, this.table, true));
    }

    private void moveDown() {
        Controller.getInstance().addTool(new MoveBarrierTool(this.dataControl, this.table, false));
    }

    @Override
    public boolean updateFields() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n2 != 0 && n2 == this.table.getRowCount()) {
            if (n != -1) {
                this.table.changeSelection(n, 0, false, false);
            }
        } else {
            this.spep.setSelectedElement((ImageElement)null);
        }
        this.spep.repaint();
        return true;
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getBarriers().size(); ++i) {
                if (this.dataControl.getBarriers().get(i) != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public void dataControlSelected(DataControl dataControl) {
        if (dataControl != null) {
            for (int i = 0; i < this.dataControl.getBarriers().size(); ++i) {
                if (this.dataControl.getBarriers().get(i) != dataControl) continue;
                this.table.changeSelection(i, i, false, false);
            }
        } else {
            this.table.clearSelection();
        }
    }
}

