/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.tools.listeners.DocumentationChangeListener;
import es.eucm.eadventure.editor.control.tools.listeners.NameChangeListener;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BarrierPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BarrierDataControl barrierDataControl;
    private JTextArea documentationTextArea;
    private ScenePreviewEditionPanel spep;
    private JTabbedPane tabPanel;
    private JPanel docPanel;
    private JTextField nameTextField;

    public BarrierPanel(BarrierDataControl barrierDataControl) {
        this.barrierDataControl = barrierDataControl;
        this.tabPanel = new JTabbedPane();
        this.docPanel = new JPanel();
        this.docPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new BorderLayout());
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.documentationTextArea = new JTextArea(barrierDataControl.getDocumentation(), 4, 0);
        this.documentationTextArea.setLineWrap(true);
        this.documentationTextArea.setWrapStyleWord(true);
        this.documentationTextArea.getDocument().addDocumentListener(new DocumentationChangeListener(this.documentationTextArea, (Documented)barrierDataControl.getContent()));
        jPanel.add(new JScrollPane(this.documentationTextArea, 22, 31));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Barrier.Documentation")));
        this.docPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.nameTextField = new JTextField(this.barrierDataControl.getName());
        this.nameTextField.getDocument().addDocumentListener(new NameChangeListener(this.nameTextField, (Named)barrierDataControl.getContent()));
        jPanel2.add(this.nameTextField);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Barrier.Name")));
        this.docPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.docPanel.add((Component)new JFiller(), gridBagConstraints);
        this.tabPanel.insertTab(TC.get((String)"Barrier.MainPanelTitle"), null, this.createMainPanel(), TC.get((String)"Barrier.MainPanelTip"), 0);
        this.tabPanel.insertTab(TC.get((String)"Barrier.DocPanelTitle"), null, this.docPanel, TC.get((String)"Barrier.DocPanelTip"), 1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        String string = Controller.getInstance().getSceneImagePath(this.barrierDataControl.getParentSceneId());
        this.spep = new ScenePreviewEditionPanel(false, string);
        this.spep.setShowTextEdition(true);
        this.spep.setSelectedElement(this.barrierDataControl);
        this.spep.setFixedSelectedElement(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        JButton jButton = new JButton(TC.get((String)"GeneralText.EditConditions"));
        jButton.addActionListener(new ConditionsButtonListener());
        jPanel2.add(jButton);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Barrier.Conditions")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.spep, gridBagConstraints);
        return jPanel;
    }

    private class ConditionsButtonListener
    implements ActionListener {
        private ConditionsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(BarrierPanel.this.barrierDataControl.getConditions());
        }
    }
}

