/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreasListDataControl;
import es.eucm.eadventure.editor.control.tools.scene.RenameActiveAreaTool;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.AuxEditCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ConditionsCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.DocumentationCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.InfoHeaderRenderer;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.StringCellRendererEditor;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ActiveAreasTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected ActiveAreasListDataControl dataControl;
    protected IrregularAreaEditionPanel iaep;
    protected ScenePreviewEditionPanel spep;

    public ActiveAreasTable(ActiveAreasListDataControl activeAreasListDataControl, IrregularAreaEditionPanel irregularAreaEditionPanel, JSplitPane jSplitPane) {
        this.spep = irregularAreaEditionPanel.getScenePreviewEditionPanel();
        this.iaep = irregularAreaEditionPanel;
        this.dataControl = activeAreasListDataControl;
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setModel(new ElementsTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ActiveAreasTable.this.getSelectedRow() >= 0) {
                    ActiveAreasTable.this.iaep.setRectangular(ActiveAreasTable.this.dataControl.getActiveAreas().get(ActiveAreasTable.this.getSelectedRow()));
                    ActiveAreasTable.this.iaep.repaint();
                }
            }
        });
        this.getColumnModel().getColumn(0).setHeaderRenderer(new InfoHeaderRenderer());
        this.getColumnModel().getColumn(1).setHeaderRenderer(new InfoHeaderRenderer("general/Conditions.html"));
        this.getColumnModel().getColumn(2).setHeaderRenderer(new InfoHeaderRenderer("scenes/Scene_ActiveAreaActions.html"));
        this.getColumnModel().getColumn(3).setHeaderRenderer(new InfoHeaderRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new StringCellRendererEditor());
        this.getColumnModel().getColumn(0).setCellRenderer(new StringCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new ConditionsCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellEditor(new ConditionsCellRendererEditor());
        this.getColumnModel().getColumn(1).setMaxWidth(120);
        this.getColumnModel().getColumn(1).setMinWidth(120);
        String string = TC.get((String)"ActiveAreasList.EditActions");
        this.getColumnModel().getColumn(2).setCellRenderer(new AuxEditCellRendererEditor(jSplitPane, 150, string));
        this.getColumnModel().getColumn(2).setCellEditor(new AuxEditCellRendererEditor(jSplitPane, 150, string));
        this.getColumnModel().getColumn(2).setMaxWidth(105);
        this.getColumnModel().getColumn(2).setMinWidth(105);
        this.getColumnModel().getColumn(3).setCellRenderer(new DocumentationCellRendererEditor());
        this.getColumnModel().getColumn(3).setCellEditor(new DocumentationCellRendererEditor());
        this.getColumnModel().getColumn(3).setMaxWidth(140);
        this.getColumnModel().getColumn(3).setMinWidth(140);
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(22);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ActiveAreasTable.this.setRowHeight(22);
                if (ActiveAreasTable.this.getSelectedRow() != -1) {
                    ActiveAreasTable.this.setRowHeight(ActiveAreasTable.this.getSelectedRow(), 26);
                }
            }
        });
        this.setSize(200, 150);
    }

    private class ElementsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ElementsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ActiveAreasTable.this.dataControl.getActiveAreas().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ActiveAreasTable.this.dataControl.getActiveAreas().get(n).getId();
            }
            if (n2 == 1) {
                return ActiveAreasTable.this.dataControl.getActiveAreas().get(n).getConditions();
            }
            if (n2 == 3) {
                return ActiveAreasTable.this.dataControl.getActiveAreas().get(n);
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"ActiveAreasList.Id");
            }
            if (n == 1) {
                return TC.get((String)"ActiveAreasList.Conditions");
            }
            if (n == 2) {
                return TC.get((String)"ActiveAreasList.Actions");
            }
            if (n == 3) {
                return TC.get((String)"ActiveAreasList.Documentation");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && ActiveAreasTable.this.dataControl.getActiveAreas().size() > n) {
                Controller.getInstance().addTool(new RenameActiveAreaTool(ActiveAreasTable.this.dataControl.getActiveAreas().get(n), (String)object));
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return ActiveAreasTable.this.getSelectedRow() == n;
        }
    }
}

