/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreasListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.tools.scene.AddActiveAreaTool;
import es.eucm.eadventure.editor.control.tools.scene.DeleteActiveAreaTool;
import es.eucm.eadventure.editor.control.tools.scene.DuplicateActiveAreaTool;
import es.eucm.eadventure.editor.control.tools.scene.MoveActiveAreaTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.DataControlSelectionListener;
import es.eucm.eadventure.editor.gui.elementpanels.general.SmallActionsListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ActiveAreasTable;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ActiveAreasListPanel
extends JPanel
implements DataControlsPanel,
DataControlSelectionListener,
Updateable {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_SPLIT_POSITION = 140;
    public static final int VERTICAL_SPLIT_POSITION = 150;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private ActiveAreasTable table;
    private ActiveAreasListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private JSplitPane previewAuxSplit;
    private JPanel auxPanel;
    private SmallActionsListPanel smallActions = null;

    public ActiveAreasListPanel(ActiveAreasListDataControl activeAreasListDataControl) {
        this.dataControl = activeAreasListDataControl;
        String string = Controller.getInstance().getSceneImagePath(activeAreasListDataControl.getParentSceneId());
        this.iaep = new IrregularAreaEditionPanel(string, null, activeAreasListDataControl.getSceneDataControl().getTrajectory().hasTrajectory(), Color.GREEN);
        ScenePreviewEditionPanel scenePreviewEditionPanel = this.iaep.getScenePreviewEditionPanel();
        if (activeAreasListDataControl.getSceneDataControl().getTrajectory().hasTrajectory()) {
            scenePreviewEditionPanel.setTrajectory((Trajectory)activeAreasListDataControl.getSceneDataControl().getTrajectory().getContent());
            for (NodeDataControl object2 : activeAreasListDataControl.getSceneDataControl().getTrajectory().getNodes()) {
                scenePreviewEditionPanel.addNode(object2);
            }
            scenePreviewEditionPanel.setShowInfluenceArea(true);
        }
        this.setLayout(new BorderLayout());
        this.auxPanel = new JPanel();
        this.auxPanel.setMaximumSize(new Dimension(150, Integer.MAX_VALUE));
        this.auxPanel.setMinimumSize(new Dimension(150, 0));
        this.previewAuxSplit = new JSplitPane(1, this.iaep, this.auxPanel);
        this.previewAuxSplit.setDividerSize(10);
        this.previewAuxSplit.setContinuousLayout(true);
        this.previewAuxSplit.setOneTouchExpandable(true);
        this.previewAuxSplit.setResizeWeight(1.0);
        this.previewAuxSplit.setDividerLocation(Integer.MAX_VALUE);
        JPanel jPanel = this.createTablePanel(this.iaep);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.previewAuxSplit);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(140);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerSize(10);
        this.add((Component)jSplitPane, "Center");
        this.addElementsToPreview(scenePreviewEditionPanel, string, activeAreasListDataControl);
    }

    private JPanel createTablePanel(IrregularAreaEditionPanel irregularAreaEditionPanel) {
        JPanel jPanel = new JPanel();
        this.table = new ActiveAreasTable(this.dataControl, irregularAreaEditionPanel, this.previewAuxSplit);
        TableScrollPane tableScrollPane = new TableScrollPane(this.table, 22, 31);
        tableScrollPane.setMinimumSize(new Dimension(0, 140));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ActiveAreasListPanel.this.table.getSelectedRow() >= 0) {
                    ActiveAreasListPanel.this.deleteButton.setEnabled(true);
                    ActiveAreasListPanel.this.duplicateButton.setEnabled(true);
                    ActiveAreasListPanel.this.moveUpButton.setEnabled(ActiveAreasListPanel.this.dataControl.getActiveAreas().size() > 1 && ActiveAreasListPanel.this.table.getSelectedRow() > 0);
                    ActiveAreasListPanel.this.moveDownButton.setEnabled(ActiveAreasListPanel.this.dataControl.getActiveAreas().size() > 1 && ActiveAreasListPanel.this.table.getSelectedRow() < ActiveAreasListPanel.this.table.getRowCount() - 1);
                } else {
                    ActiveAreasListPanel.this.deleteButton.setEnabled(false);
                    ActiveAreasListPanel.this.duplicateButton.setEnabled(false);
                    ActiveAreasListPanel.this.moveUpButton.setEnabled(false);
                    ActiveAreasListPanel.this.moveDownButton.setEnabled(false);
                }
                ActiveAreasListPanel.this.updateAuxPanel();
                ActiveAreasListPanel.this.deleteButton.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setFocusable(false);
        jButton.setToolTipText(TC.get((String)"ActiveAreasList.AddActiveArea"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActiveAreasListPanel.this.addActiveArea();
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"ActiveAreasList.DeleteActiveArea"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActiveAreasListPanel.this.deleteActiveArea();
            }
        });
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"ActiveAreasList.DuplicateActiveArea"));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.setFocusable(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActiveAreasListPanel.this.duplicateActiveArea();
            }
        });
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"ActiveAreasList.MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActiveAreasListPanel.this.moveUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"ActiveAreasList.MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActiveAreasListPanel.this.moveDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.duplicateButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.moveUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 2.0;
        jPanel2.add((Component)new JFiller(), gridBagConstraints);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)tableScrollPane, "Center");
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    protected void addActiveArea() {
        String string;
        String string2 = string = this.dataControl.getDefaultId(this.dataControl.getAddableElements()[0]);
        int n = 0;
        while (!Controller.getInstance().isElementIdValid(string2, false)) {
            string2 = string + ++n;
        }
        Controller.getInstance().addTool(new AddActiveAreaTool(this.dataControl, string2, this.iaep));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getActiveAreas().size() - 1, this.dataControl.getActiveAreas().size() - 1, false, false);
        this.table.editCellAt(this.dataControl.getActiveAreas().size() - 1, 0);
        if (this.table.isEditing()) {
            this.table.getEditorComponent().requestFocusInWindow();
        }
    }

    protected void duplicateActiveArea() {
        Controller.getInstance().addTool(new DuplicateActiveAreaTool(this.dataControl, this.iaep, this.table));
    }

    protected void deleteActiveArea() {
        Controller.getInstance().addTool(new DeleteActiveAreaTool(this.dataControl, this.iaep, this.table));
    }

    private void moveUp() {
        Controller.getInstance().addTool(new MoveActiveAreaTool(this.dataControl, this.table, true));
    }

    private void moveDown() {
        Controller.getInstance().addTool(new MoveActiveAreaTool(this.dataControl, this.table, false));
    }

    private void addElementsToPreview(ScenePreviewEditionPanel scenePreviewEditionPanel, String string, ActiveAreasListDataControl activeAreasListDataControl) {
        if (string != null) {
            for (ElementReferenceDataControl dataControl : activeAreasListDataControl.getParentSceneItemReferences()) {
                scenePreviewEditionPanel.addElement(1, dataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(1, false);
            for (ElementReferenceDataControl elementReferenceDataControl : activeAreasListDataControl.getParentSceneNPCReferences()) {
                scenePreviewEditionPanel.addElement(2, elementReferenceDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(2, false);
            for (ElementReferenceDataControl elementReferenceDataControl : activeAreasListDataControl.getParentSceneAtrezzoReferences()) {
                scenePreviewEditionPanel.addElement(3, elementReferenceDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(3, false);
            for (ExitDataControl exitDataControl : activeAreasListDataControl.getParentSceneExits()) {
                scenePreviewEditionPanel.addExit(exitDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(7, false);
            for (BarrierDataControl barrierDataControl : activeAreasListDataControl.getParentSceneBarriers()) {
                scenePreviewEditionPanel.addBarrier(barrierDataControl);
            }
            scenePreviewEditionPanel.setMovableCategory(4, false);
            for (ActiveAreaDataControl activeAreaDataControl : activeAreasListDataControl.getActiveAreas()) {
                scenePreviewEditionPanel.addActiveArea(activeAreaDataControl);
            }
            scenePreviewEditionPanel.changeController(new NormalScenePreviewEditionController(scenePreviewEditionPanel));
            scenePreviewEditionPanel.setDataControlSelectionListener(this);
            scenePreviewEditionPanel.setMovableCategory(5, true);
        }
    }

    protected void updateAuxPanel() {
        if (this.auxPanel == null) {
            return;
        }
        this.auxPanel.removeAll();
        this.smallActions = null;
        if (this.table.getSelectedRow() == -1) {
            this.previewAuxSplit.setDividerLocation(Integer.MAX_VALUE);
            return;
        }
        this.auxPanel.setLayout(new BorderLayout());
        this.smallActions = new SmallActionsListPanel(this.dataControl.getActiveAreas().get(this.table.getSelectedRow()).getActionsList());
        this.auxPanel.add(this.smallActions);
        this.previewAuxSplit.setDividerLocation(Integer.MAX_VALUE);
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getActiveAreas().size(); ++i) {
                if (this.dataControl.getActiveAreas().get(i) != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public void dataControlSelected(DataControl dataControl) {
        if (dataControl != null) {
            for (int i = 0; i < this.dataControl.getActiveAreas().size(); ++i) {
                if (this.dataControl.getActiveAreas().get(i) != dataControl) continue;
                this.table.changeSelection(i, i, false, false);
            }
        } else {
            this.table.clearSelection();
        }
    }

    @Override
    public boolean updateFields() {
        final int n = this.previewAuxSplit.getDividerLocation();
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getRowCount();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n3 > 0 && n3 == this.dataControl.getActiveAreas().size() && n2 != -1 && n2 < this.table.getRowCount()) {
            this.table.changeSelection(n2, 0, false, false);
            if (this.smallActions != null && this.smallActions instanceof Updateable) {
                this.smallActions.updateFields();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveAreasListPanel.this.previewAuxSplit.setDividerLocation(n);
                }
            });
        }
        this.iaep.repaint();
        return true;
    }
}

